#include "stdafx.h"
#include "header.h"

const int iBufferSize = 1200;	// How many characters the parser is allowed to read
								// at a time.

int parSettingsIni (void)
{
	// Opens the settings.ini file and parses the user
	// settings data.

	FILE * pFile;					// A pointer to the file itself.
	char cCommand[iBufferSize];		// The bit of text that we're dealing with from the file.

	// Currently, we aren't set up to handle what happens if the .ini
	// file is missing, so we'll alert the user and exit for now.
	// In the future, we will create a work around so that if the
	// .ini file is missing, the engine will either just ignore it,
	// or create a new one from scratch.
	
	if(!exists("data/settings.ini"))
	{
		allegro_message("Cannot find the settings.ini file, or it may be corrupt.");
		exit(-1);
	};
	
	pFile = fopen("data/settings.ini", "rt");

	// Now, to begin parsing.

	while(!feof(pFile))
	{
		fscanf(pFile, "%s", &cCommand);

		// Windowed Mode

        if(strcmp(cCommand, "WindowedMode") == 0)
        {
			fscanf(pFile, "%s", &cCommand);
			if(strcmp(cCommand, "OFF") == 0)
		    {
				sys_bWindowedMode = false;
            };
            if(strcmp(cCommand, "ON") == 0)
		    {
				sys_bWindowedMode = true;
            };
		};

		// Debug Mode

        if(strcmp(cCommand, "DebugMode") == 0)
        {
			fscanf(pFile, "%s", &cCommand);
			if(strcmp(cCommand, "OFF") == 0)
		    {
				sys_bDebugMode = false;
            };
            if(strcmp(cCommand, "ON") == 0)
		    {
				sys_bDebugMode = true;
            };
		};

		// Language Settings

        if(strcmp(cCommand, "Language") == 0)
        {
			fscanf(pFile, "%s", &cCommand);
			sys_tLanguage = cCommand;
		};

        // Skip-Fram Mode

        if(strcmp(cCommand, "FrameSkip") == 0)
        {
			fscanf(pFile, "%s", &cCommand);
			if(strcmp(cCommand, "OFF") == 0)
		    {
				sys_bFrameSkip = false;
            };
            if(strcmp(cCommand, "ON") == 0)
		    {
				sys_bFrameSkip = true;
            };
		};
        
		// Ignore comment lines marked with #

		if(strcmp(cCommand, "#") == 0)
        {
			while(strcmp(cCommand, "\n") != 0)
			{
				fscanf(pFile, "%c", &cCommand);
			};
		};
	};

	// Okay, we're done here; close the file.

	fclose(pFile);

	return 0;
};
