#include "stdafx.h"
#include "header.h"

int unitAddPath (int iUnit, int iX, int iY, bool bIgnoreCost)
{
    // Adds a tile to a unit's assigned path. If the tile is
    // already in the list, the everything after that tile will be
    // cleared, so that the unit does not move in circles to get
    // to a destination.
    //
    // If bIgnoreCost is set to true, then movement cost will be
    // ignored, which is useful for cutscenes. Otherwise, the
    // function will clear the entire path and set up a new one
    // if the unit cannot make it to that point using the current
    // path. (In order for this to work, the movement range array
    // used by the map must have been activated for the given unit.)
    
    sPath tempPath;
    int iLast = unit[iUnit].vPath.size() - 1;
    
    // Unless bIgnoreCost has been set, we must check to make sure the given
    // tile is within the unit's movement range.
    
    //if(!bIgnoreCost && map.iRange[iX][iY] != 1)
    {
        //return -1; // The unit cannot move here because it is out of their movement range.
    };
    
    // We now will check to see if the given tile  has already been placed in
    // the list, in which case we revert the path to end at that tile (otherwise
    // you end up with units going in weird circles, making it hard to select
    // a destination).
    
    for(vector<sPath>::iterator i = unit[iUnit].vPath.begin(); i < unit[iUnit].vPath.end(); i++)
    {
        if(i->iX == iX && i->iY == iY)
        {
            unit[iUnit].vPath.erase(i + 1, unit[iUnit].vPath.end());
            return 0; // Done; the path has been reverted back to end at this square
        };
    };
    
    // Check if the tile is adjacent to the previous one.
    
    if(unit[iUnit].vPath.size() > 0)
    {
        if(aiHeuristic(unit[iUnit].vPath[iLast].iX, unit[iUnit].vPath[iLast].iY, iX, iY) > 1)
        {
            aiFindPath(iUnit, iX, iY, false);
            return 0; // Done, we calculated a new route to the target
        };
        if(terrain[map.Terrain(iX, iY)].iCost[0] + unit[iUnit].vPath[iLast].iDistance > unit[iUnit].iMoves
            && !bIgnoreCost)
        {
            aiFindPath(iUnit, iX, iY, false);
            return 0;
        };
    };
    
    // Okay, all's good, add the tile to the end of the list.
    
    tempPath.iX = iX;
    tempPath.iY = iY;
    
    if(unit[iUnit].vPath.size() > 1)
        tempPath.iDistance = terrain[map.Terrain(iX, iY)].iCost[0] + unit[iUnit].vPath[iLast].iDistance;
    else
        tempPath.iDistance = 0;
    
    unit[iUnit].vPath.push_back(tempPath);
    
    return 0; // Done
};

int unitAt (int iX, int iY)
{
    // Checks to see if there's a unit at a given space.  Returns
    // -1 if not, or the unit's faction ID if there is on.
    
    for(int i = 0; i < giMaxUnits; i++)
    {
        if(unit[i].bActive && unit[i].iLocX == iX && unit[i].iLocY == iY)
        {
            return unit[i].iFaction;
        };
    };
    
    return - 1;
};

int unitAvoid (int iUnit)
{
    // Calculates a unit's hit stat.
    
    int iAvoid = (unit[iUnit].iAGL / 2) + (terrain[unitTerrain(iUnit)].iAvo * 10) + (unit[iUnit].iLUK / 2);
    
    return iAvoid;
};

bool unitCanAttack (int iUnit, int iX, int iY)
{
    // Checks if a given unit can attack from
    // their current position.
    
    if(unit[iUnit].iNear < 1)
        return false; // The unit cannot attack at all.
    
    aiAttackRange(iUnit, iX, iY);
    
    for(int x = 0; x < map.iSizeX; x++)
    {
        for(int y = 0; y < map.iSizeY; y++)
        {
            for(int i = 0; i < giMaxUnits; i++)
            {
                if(unit[i].bActive && unit[i].iLocX == x && unit[i].iLocY == y
                    && unit[i].iFaction != unit[iUnit].iFaction && map.iRange[x][y] == 3)
                {
                    map.ClearRange();
                    return true; // This unit can attack from here.
                };
            };
        };
    };
    
    map.ClearRange();
    
    return false; // This unit cannot attack from this position.
};

int unitClear (void)
{
    // Clears all unit data
  
    for(int i = 0; i < giMaxUnits; i++)
    {
        unit[i].bActive = false;
        unit[i].vPath.clear();
    };    
    
    return 0; // Success
};

int unitDisplay (int iClass, int iColor, int iAnim, int iX, int iY)
{
    // Displays a given unit at a given coordinate.
    
    BITMAP *mImage = create_bitmap(giUnitWidth, giUnitHeight);
    
    if(rank[iClass].bNoAnim)
        blit(rank[iClass].mUnit, mImage, giUnitSourceX, giUnitSourceY + (giUnitHeight * iAnim), 0, 0, giUnitWidth, giUnitHeight);
    else
        blit(rank[iClass].mUnit, mImage, giUnitSourceX + (giUnitWidth * giUnitBob[0]), giUnitSourceY + (giUnitHeight * iAnim), 0, 0, giUnitWidth, giUnitHeight);
    
    //colorSwap(mImage, 0, faction[iColor].iColor);
    draw_sprite(mBuffer, mImage, iX - giUnitOffsetX, iY - giUnitOffsetY);
    draw_sprite(mBuffer, faction[iColor].mIcon, iX + 20, iY + 20);
    
    destroy_bitmap(mImage);
    
    return 0; // Success
};

int unitHit (int iUnit)
{
    // Calculates a unit's hit stat.
    
    int iHit = 80 + unit[iUnit].iSPD + (unit[iUnit].iLUK / 2);
    
    return iHit;
};

int unitKillAll (void)
{
    // Clears all Units' Data
    
    for(int i = 0; i < giMaxUnits; i++)
    {
        unit[i].bActive = false;
        destroy_bitmap(unit[i].mImage);
        unit[i].mImage = NULL;
    };
    
    return 0; // Done
};

bool unitMoving (void)
{
    // Checks all units and returns true if any of them are currently moving.

    for(int i = 0; i < giMaxUnits; i++)
    {
        if(unit[i].bActive && unit[i].bMoving)
            return true;
    };
    
    return false;
};

int unitReset (int iFaction)
{
    // Resets the movement and images of all a faction's units, to prepare
    // for the next faction's turn.
    
    for(int i = 0; i < giMaxUnits; i++)
    {        
        if(unit[i].bActive == true && unit[i].iFaction == iFaction)
        {
            blit(rank[unit[i].iClass].mUnit, unit[i].mImage, 0, 0, 0, 0, unit[i].mImage->w, unit[i].mImage->h);
            colorSwap(unit[i].mImage, 0, unit[i].iFaction + 1);
            unit[i].iMoves = unit[i].iMOV;
        };
    };
    
    return 0; // Done
};

int unitTerrain (int iUnit)
{
    // Returns the ID of the terrain that the unit is currently on.
    
    return map.Terrain(unit[iUnit].iLocX, unit[iUnit].iLocY);
};

int unitUpdate (void)
{
    // Updates all the unit animation and movement.
  
    giUnitBob[1]++;
    
    if(giUnitBob[1] > 15)
    {
        giUnitBob[1] = 0;
        giUnitBob[0]++;
        
        if(giUnitBob[0] > 3)
            giUnitBob[0] = 0;
    };
    
    // Check on all units.
    
    for(int i = 0; i < giMaxUnits; i++)
    {        
        if(unit[i].bActive)
        {
            // Update HP Bar
            
            if(unit[i].iHPBar > unit[i].iHP)
                unit[i].iHPBar--;
            if(unit[i].iHPBar < unit[i].iHP)
                unit[i].iHPBar++;
            
            // Check to see if the unit is dead.
            
            if(unit[i].iHPBar < 1)
            {
                int iFaction = unit[i].iFaction;
                
                unit[i].bActive = false;
                faction[iFaction].iUnits--;
                
                // Check to see if this was the last unit of its faction.
                
                if(faction[iFaction].iUnits < 1)
                {
                    faction[iFaction].bActive = false;
                    giTeams--;
                };
            };            
        };
        
        // Move units
        
        if(unit[i].bActive && unit[i].bMoving)
        {
            if(unit[i].vPath.size() > 0)
            {
                gtDebug = txtInt(unit[i].vPath[0].iX) + " " + txtInt(unit[i].vPath[0].iY) + " - "
                    + txtInt(unit[i].iX) + " " + txtInt(unit[i].iY) + " - "
                    + txtInt(unit[i].iLocX) + " " + txtInt(unit[i].iLocY);
                
                if(unit[i].vPath[0].iX < unit[i].iLocX)
                    unit[i].iX -= unit[i].iSpeed;
                if(unit[i].vPath[0].iX > unit[i].iLocX)
                    unit[i].iX += unit[i].iSpeed;
                if(unit[i].vPath[0].iY < unit[i].iLocY)
                    unit[i].iY -= unit[i].iSpeed;
                if(unit[i].vPath[0].iY > unit[i].iLocY)
                    unit[i].iY += unit[i].iSpeed;
                
                if(unit[i].vPath[0].iX * giTileX == unit[i].iX
                    && unit[i].vPath[0].iY * giTileY == unit[i].iY)
                {
                    vector<sPath>::iterator PathIterator = unit[i].vPath.begin();
                    unit[i].iLocX = unit[i].vPath[0].iX;
                    unit[i].iLocY = unit[i].vPath[0].iY;
                    unit[i].vPath.erase(PathIterator);
                };
            }
            else
            {
                gtDebug = "";
                unit[i].vPath.clear();
                unit[i].bMoving = false;
            };
        };
    };
    
    return 0; // Success
};
