#include "stdafx.h"
#include "header.h"

// TODO: This file is a pig sty! Eventually, we need
// to clean the whole thing up and convert it to a
// C++ style class object.

const int iTotalChars = 256;		// How many characters/letters the font
									// system supports.
const int iTotalTObjects = 100;

typedef struct stFont
{
	BITMAP *bSource;			// The actual bitmpap containing the font.
	int iHeight;				// How tall the font is, in pixels.
	int iStart[iTotalChars];	// How many pixels to the left to offset each individual letter.
	int iWidth[iTotalChars];	// How wide, in pixels, each individual letter is.
	int iWidthSource;			// How wide the letters are in the source bitmap.
} sMakeFont;

typedef struct stTextObject
{
	bool bActive;
	int iAlign;
	int iFont;
	int iSpeed;					// How many characters to add to iToPrint each update.
	int iTillNext;				// How long (in frames) it will be until iToPrint should be increased.
	int iToPrint;				// How many characters in the text object to print--Creates text "scroll in" effect.
	int iWidth;
	int iX;
	int iY;
	string tText;
} sMakeTObject;

sMakeFont sFont[10];
sMakeTObject sText[iTotalTObjects];

BITMAP *mTxtTo;


int txtCheckWordLength(int iFont, string tText)
{
	// Checks how wide (in pixels) a given string would be.

	int i;
	int iLetters = tText.length();
	int iLength = 0;
	int iTextValue;					// The numeric value of a character.

	for(i = 0; i < iLetters; i++)
	{
		iTextValue = tText[i];

		// If the value of a character is higher than 127, it is stored as a
		// negative number because strings used signed char characters.  We
		// need to alter this for our own use, simply by adding 256.

		if(iTextValue < 0)
			iTextValue += 256;

		iLength += sFont[iFont].iWidth[iTextValue];
	};

	return iLength;
};



int txtCenter(int iFont, int iLocX, int iLocY, string tText, int iLength, int iToPrint)
{
	// Figures how much offset to give to a string of text to make it appear
	// centered on the screen, then passes this information onto txtOut.
	
	int iOffset = 0;
    int iPosition = 0;
    string tReadyToPrint = "";
    if(iToPrint < 0)
        iToPrint = tText.length();
    
    // If there are several rows of text, we'll want them to display
    // correctly!  So let's cut the text into printable, bite-size
    // chunks.
    
	while(iPosition < iToPrint) // && iLength > 0)
    {
        //string tGetNew = "";
        string tCheckText = tReadyToPrint;
        //int iCheck = iPosition;
        
        /*while (tText[iCheck] == 32 && iCheck < iToPrint)
        {
            tGetNew += " ";
            iCheck++;
        };
        
        while (tText[iCheck] != 32 && iCheck < iToPrint)
        {
            tGetNew += tText[iCheck];
            iCheck++;
        };*/
        
        //tCheckText = "B";//tReadyToPrint + tGetNew;
        
        tCheckText = tReadyToPrint + tText[iPosition];

        if (txtCheckWordLength(iFont, tCheckText) > iLength && iLength > 0 /* || iPosition >= iToPrint*/
            || tText[iPosition] == 47 && tText[iPosition + 1] == 110)
        {
            if(tText[iPosition] == 47 && tText[iPosition + 1] == 110)
                iPosition += 2;
            
            while(tText[iPosition] == 32 && iPosition < iToPrint)
            {
                iPosition ++;
            };
            
            /*if(iPosition == iToPrint)
            {
                tReadyToPrint += tGetNew;
                iPosition = iToPrint;
            };*/
            
            //iPosition--;
            
            iOffset = txtCheckWordLength(iFont, tReadyToPrint) / 2;
            txtOut(iFont, iLocX - iOffset, iLocY, tReadyToPrint, 0, -1);
            iLocY += sFont[iFont].iHeight;
            tCheckText = "";
            tReadyToPrint = "";
        }
        else
        {
            tReadyToPrint = tCheckText;
            iPosition++;
            //iPosition = iCheck;
        };
    }

    //if(iLength <= 0)
    {
        iOffset = txtCheckWordLength(iFont, tReadyToPrint) / 2;
        txtOut(iFont, iLocX - iOffset, iLocY, tReadyToPrint, 0, -1); //iToPrint);
    };

	return 0;
};


void txtDisplay()
{
	// Displays all the text objects that are currently active.

	for(int i = 0; i < iTotalTObjects; i++)
	{
		if(sText[i].bActive == true)
		{			
			if(sText[i].iToPrint < sText[i].tText.length() && sText[i].iTillNext >= 0)
			{
				if(sText[i].iSpeed > 1)
					sText[i].iToPrint += sText[i].iSpeed;
				else
					sText[i].iToPrint++;
				sText[i].iTillNext = sText[i].iSpeed;
			}
			else if(sText[i].iTillNext < 0)
				sText[i].iTillNext++;

			if(sText[i].iToPrint > sText[i].tText.length())
				sText[i].iToPrint = sText[i].tText.length();

			switch(sText[i].iAlign)
			{
			case 0:
				txtOut(sText[i].iFont, sText[i].iX, sText[i].iY, sText[i].tText, sText[i].iWidth, sText[i].iToPrint);
				break;
			case 1:
				txtCenter(sText[i].iFont, sText[i].iX, sText[i].iY, sText[i].tText, sText[i].iWidth, sText[i].iToPrint);
				break;               
			};
		};
	};
};

int txtHeight(int iFontToUse, string tText, int iTextLength, int iNumberOfCharactersToPrint)
{
	// Checks how tall a given text will be.
	
	int iTextValue;  /* The numerical value of a given text character. */
	int iTextLocationY = 0;
	int iTextLocationX = 0;

	if(iNumberOfCharactersToPrint < 0)
		iNumberOfCharactersToPrint = tText.length();

	for (int i = 0; i < iNumberOfCharactersToPrint; i++)
	{
		iTextValue = tText[i];  /* Get the value of the current text character. */

		// Because we'll be using characters with a higher value than 127 in order to have
		// multi-language support, this presents a problem because string char charaters
		// are signed.  There for, anything higher than 127 becomes a negative number. This
		// is easily remedied, however, by adding 256 to the number so that the text
		// display we're using knows what character it is.

		if(iTextValue < 0)
			iTextValue += 256;

		/* Check to see if the next word will fit. */

		if(iTextValue == 32 && iTextLength > 0)
		{
			string tCheckText = " ";
			int iCheck = i + 1;
			//int iStart = i + 1;
			int iTotal = tText.length();
			
			while (tText[iCheck] != 32 && iCheck < iTotal)
			{
				tCheckText += tText[iCheck];
				//tCheckText[iCheck - iStart] = tText[iCheck];
				iCheck++;
			};

			if (iTextLocationX + txtCheckWordLength(iFontToUse, tCheckText) > iTextLength)
			{
				while(tText[i] == 32 && i < iTotal)
				{
					i = i + 1;
				};

				iTextValue = tText[i];
				iTextLocationY += sFont[iFontToUse].iHeight;
				iTextLocationX = 0;
			};
		};

		
		// Skip "/w" slow downs, used to pause the text a moment when in auto-scroll mode.
		
		/*if (iTextValue == 47 && tText[i + 1] == 119)
		{
			i += 2;
			iTextValue = tText[i];
		};*/

		/* Line Break */
		
		while (iTextValue == 47 && tText[i + 1] == 110)
		{
			i += 3;
			iTextValue = tText[i];
			iTextLocationY += sFont[iFontToUse].iHeight;
			iTextLocationX = 0;
		};

		/*while (iTextValue == 10)
		{
			i = i + 1;
			iTextValue = tText[i];
			iTextLocationY += sFont[iFontToUse].iHeight;
			iTextLocationX = 0;
		};*/
		
		iTextLocationX += sFont[iFontToUse].iWidth[iTextValue];
	};
	
	// Add the last line break for the ending text.
	
	iTextLocationY += sFont[iFontToUse].iHeight;

	return iTextLocationY;
};


string txtInt (int iInteger)
{
    // Simple function for converting integers to strings.
    
    char cChar[500];        // The buffer to store the results in,
                            // which we will hand off as the
                            // return value.
    
    // We will use sprintf to convert the integer to a
    // C-style string.
    
    sprintf(cChar, "%i", iInteger);
    
    // And...  We're done! :3
    
    return cChar; // Success
};


int txtMove (int iToSet, int iNewX, int iNewY)
{
    // Moves a text object to a new location.
	
    sText[iToSet].iX = iNewX * giGrid;
	sText[iToSet].iY = iNewY * giGrid;
    
    return 0; // Success
};


int txtNew(int iToSet, int iLocX, int iLocY, string tText, int iFont, int iWidth, int iAlign, int iSpeed)
{
	// Makes a new text object.  Text objects are "short cuts" so that each individual loop
	// doesn't have to handle each bit of text every time the screen refreshes.

    if(sText[iToSet].bActive)
        return -1; // This text object already exists.
    
	if(iSpeed == 0)
		sText[iToSet].iToPrint = tText.length();
	else
		sText[iToSet].iToPrint = 0;

	sText[iToSet].bActive = true;
	sText[iToSet].iX = iLocX * giGrid;
	sText[iToSet].iY = iLocY * giGrid;
	sText[iToSet].iFont = iFont;
	sText[iToSet].iWidth = iWidth * giGrid;
	sText[iToSet].iAlign = iAlign;
	sText[iToSet].tText = tText;
	sText[iToSet].iSpeed = iSpeed;
	sText[iToSet].iTillNext = 0;

	return 0;
};



int txtKill(int iToKill)
{
	// Deletes a specific text objects.

	sText[iToKill].bActive = false;

	return 0;
};



int txtKillAll()
{
	// Deletes all the text objects.

	for(int i = 0; i < iTotalTObjects; i++)
	{
		txtKill(i);
	};

	return 0;
};



int txtOut(int iFontToUse, int iTextLocationX, int iTextLocationY, string tText, int iTextLength, int iNumberOfCharactersToPrint)
{
    // Displays text on the screen.  Based on the TextOut function used in The Pickles and
    // later ported to several other projects, thus making this the oldest code in the engine,
    // though heavily modified since its very simple first illiteration.

	int iIndentLocation = iTextLocationX;  /* Where to put the indent on line breaks. */
	int iTextOutLoop;  /* A looping variable. */
	int iTextValue;  /* The numerical value of a given text character. */

	if(iNumberOfCharactersToPrint < 0)
		iNumberOfCharactersToPrint = tText.length();	
	
	// Display a box for debug mode.
	
	//if(sys_bDebugMode)
		//rect(mTxtTo, iTextLocationX, iTextLocationY, iTextLocationX + iTextLength, iTextLocationY + txtHeight(iFontToUse, tText, iTextLength, iNumberOfCharactersToPrint), makecol(255, 0, 0));	

	for (iTextOutLoop = 0; iTextOutLoop < iNumberOfCharactersToPrint; iTextOutLoop++)
	{
		iTextValue = tText[iTextOutLoop];  /* Get the value of the current text character. */

		// Because we'll be using characters with a higher value than 127 in order to have
		// multi-language support, this presents a problem because string char charaters
		// are signed.  There for, anything higher than 127 becomes a negative number. This
		// is easily remedied, however, by adding 256 to the number so that the text
		// display we're using knows what character it is.

		if(iTextValue < 0)
			iTextValue += 256;

		/* Check to see if the next word will fit. */

		if(iTextValue == 32 && iTextLength > 0)
		{
			string tCheckText =" ";
			int iCheck = iTextOutLoop + 1;
			//int iStart = iTextOutLoop + 1;
			int iTotal = tText.length();
			
			while (tText[iCheck] != 32 && iCheck < iTotal)
			{
				tCheckText += tText[iCheck];
				//tCheckText[iCheck - iStart] = tText[iCheck];
				iCheck++;
			};

			if (iTextLocationX + txtCheckWordLength(iFontToUse, tCheckText) > iTextLength + iIndentLocation)
			{
				while(tText[iTextOutLoop] == 32 && iTextOutLoop < iTotal)
				{
					iTextOutLoop = iTextOutLoop + 1;
				};

				iTextValue = tText[iTextOutLoop];
				iTextLocationY += sFont[iFontToUse].iHeight;
				iTextLocationX = iIndentLocation;
			};
		};

		
		/* Skip "/w" slow downs, used to pause the text a moment when in auto-scroll mode. */
		
		/*if (iTextValue == 47 && tText[iTextOutLoop + 1] == 119)
		{
			iTextOutLoop = iTextOutLoop + 2;
			iTextValue = tText[iTextOutLoop];
		};*/

		/* Line Break */
		
		while (iTextValue == 47 && tText[iTextOutLoop + 1] == 110)
		{
			iTextOutLoop = iTextOutLoop + 3;
			iTextValue = tText[iTextOutLoop];
			iTextLocationY = iTextLocationY + sFont[iFontToUse].iHeight;
			iTextLocationX = iIndentLocation;
		};

		/*while (iTextValue == 10)
		{
			iTextOutLoop = iTextOutLoop + 1;
			iTextValue = tText[iTextOutLoop];
			iTextLocationY = iTextLocationY + sFont[iFontToUse].iHeight;
			iTextLocationX = iIndentLocation;
		};*/		
		
		/* 1/2 - Spaced Paragraph Break */

		/*if (iTextValue == 47 && tText[iTextOutLoop + 1] == 112)
		{
			iTextOutLoop = iTextOutLoop + 3;
			iTextValue = tText[iTextOutLoop];
			iTextLocationY = iTextLocationY + sFont[iFontToUse].iHeight + (sFont[iFontToUse].iHeight / 2);
			iTextLocationX = iIndentLocation;
		};*/

		/* Now, to actually display the text character on the screen. */
		
		masked_blit(sFont[iFontToUse].bSource, mTxtTo, sFont[iFontToUse].iWidthSource + (iTextValue - ((iTextValue / 16) * 16)) * sFont[iFontToUse].iWidthSource, sFont[iFontToUse].iHeight + 1 + ((iTextValue / 16) * (sFont[iFontToUse].iHeight + 1)), iTextLocationX, iTextLocationY, sFont[iFontToUse].iWidthSource, sFont[iFontToUse].iHeight);
		iTextLocationX = iTextLocationX + sFont[iFontToUse].iWidth[iTextValue];
	};
	
	return 0;
};

int txtRight(int iFont, int iLocX, int iLocY, string tText, int iLength, int iToPrint)
{
	// Figures how much offset to give to a string of text to make it appear
	// aligned to the right on the screen, then passes this information onto txtOut.
	
	int iOffset = 0;
    int iPosition = 0;
    string tReadyToPrint = "";
    if(iToPrint < 0)
        iToPrint = tText.length();
    
    // If there are several rows of text, we'll want them to display
    // correctly!  So let's cut the text into printable, bite-size
    // chunks.
    
	while(iPosition < iToPrint) // && iLength > 0)
    {
        //string tGetNew = "";
        string tCheckText = tReadyToPrint;
        //int iCheck = iPosition;
        
        /*while (tText[iCheck] == 32 && iCheck < iToPrint)
        {
            tGetNew += " ";
            iCheck++;
        };
        
        while (tText[iCheck] != 32 && iCheck < iToPrint)
        {
            tGetNew += tText[iCheck];
            iCheck++;
        };*/
        
        //tCheckText = "B";//tReadyToPrint + tGetNew;
        
        tCheckText = tReadyToPrint + tText[iPosition];

        if (txtCheckWordLength(iFont, tCheckText) > iLength && iLength > 0 /* || iPosition >= iToPrint*/
            || tText[iPosition] == 47 && tText[iPosition + 1] == 110)
        {
            if(tText[iPosition] == 47 && tText[iPosition + 1] == 110)
                iPosition += 2;
            
            while(tText[iPosition] == 32 && iPosition < iToPrint)
            {
                iPosition ++;
            };
            
            /*if(iPosition == iToPrint)
            {
                tReadyToPrint += tGetNew;
                iPosition = iToPrint;
            };*/
            
            //iPosition--;
            
            iOffset = txtCheckWordLength(iFont, tReadyToPrint);
            txtOut(iFont, iLocX - iOffset, iLocY, tReadyToPrint, 0, -1);
            iLocY += sFont[iFont].iHeight;
            tCheckText = "";
            tReadyToPrint = "";
        }
        else
        {
            tReadyToPrint = tCheckText;
            iPosition++;
            //iPosition = iCheck;
        };
    }

    //if(iLength <= 0)
    {
        iOffset = txtCheckWordLength(iFont, tReadyToPrint);
        txtOut(iFont, iLocX - iOffset, iLocY, tReadyToPrint, 0, -1); //iToPrint);
    };

	return 0;
};

int  txtReset (int iToSet, string tText)
{
    // Resets the text of a text object.
    
    sText[iToSet].tText = tText;
    sText[iToSet].iToPrint = tText.length();
    
    return 0;
};

int txtSetBitmap(BITMAP *mToSetTo)
{
	mTxtTo = mToSetTo;
	
	return 0; // Success
};

int txtSetFont(int iFontNumberToSet, char cFontImageName[], int iFontWidthToSet, int iFontHeightToSet)
{
	// This routine will load a font into memory, so that it can be used by the engine. It will also
	// "read" the topmost row of pixels looking for blue (0, 0, 255). This signals the "end" of the
	// letter, thus creating variable-width fonts. This code came from the old "OFE Engine" used in
	// the Fire Emblem Factory project.

	int i[2];	// A looping variable used when setting the default font width.
	
	// First, to load the font bmp image.
	
	sFont[iFontNumberToSet].bSource = load_bmp(cFontImageName, NULL);

	// If the bitmap has an alternate "magic pink," we need to manually replace it with
	// "true" magic pink.

	colorReplace(sFont[iFontNumberToSet].bSource, makecol(255, 128, 255), makecol(255, 0, 255));
	
	// Now, to set the standard width of each character.
	// If the routine hits a pixel with the value of R0 G0 R255, it will set that pixel to be the
	// "clipping point," thus creating variable width fonts.  If no such pixel exists within the boundry
	// of the default font width, then the width for that character will be set to the default font
	// width.
	
	i[0] = 0;
		
	while(i[0] < iTotalChars)
	{
		i[1] = 0;

		while(i[1] < iFontWidthToSet && getpixel(sFont[iFontNumberToSet].bSource, i[1] + iFontWidthToSet + (i[0] - ((i[0] / 16) * 16)) * iFontWidthToSet, iFontHeightToSet + ((i[0] / 16) * (iFontHeightToSet + 1))) != makecol(0, 0, 255))
		{
			i[1]++;
		};
		
		sFont[iFontNumberToSet].iWidth[i[0]] = i[1];
		i[0]++;
	};

	// Finally, to set the vertical font size.  Since there's no reason for me to support variable
	// height fonts, setting this up is a piece of cake.

	sFont[iFontNumberToSet].iHeight = iFontHeightToSet;

	// We also need to record how wide the letters are in the source bitmap.

	sFont[iFontNumberToSet].iWidthSource = iFontWidthToSet;

	return 0;
};


int  txtWidthOfChar (const int iFont, const int iChar)
{
	// Returns the width of a given character in the font.  Primarily just
	// present for minor debugging purposes.

	return sFont[iFont].iWidth[iChar];
};
