#include "stdafx.h"
#include "header.h"

// Public

int CText::Clear (void)
{
	// Clears all the text in this class object, so that there will not
	// be "leftovers" the next time it is used.

	for (int i = 0; i < giTotalStrings; i++)
	{
		bOccupied[i] = false;
		tHandle[i] = "";
		tString[i] = "";
	}; // end for

	return 0; // Success
};


string CText::Get (string tName)
{
	// Finds a string, then returns the text.  On error, return an empty string,
	// unless debug mode is active, in which case return the text "!Error!"

	int iID = Find(tName);

	if (iID != -1)
		return tString[iID]; // Return the text.
	else
	{
		if (sys_bDebugMode == true)
			return "!Error!"; // Debug Error Message
		else
			return ""; // Empty string
	}; // end else
};

int CText::Put (string tName, string tContent)
{
	// Puts a string of text into the collection and gives it a handle.

	int iFind = FindEmpty();

	if(iFind != -1)
	{
		tHandle[iFind] = tName;
		tString[iFind] = tContent;
		bOccupied[iFind] = true;
		return 0; // Success
	} // end if
	else
	{
		return -1; // Faliure
	}; // end else
};



// Private

int CText::Find (string tName)
{
	// Finds a given string by searching for the handle.

	for (int i = 0; i < giTotalStrings; i++)
	{
		if (tName == tHandle[i])
			return i; // Return the ID of the string;
	}; //end for

	return -1; // Faluire
};

int CText::FindEmpty (void)
{
	// Finds an unoccupied string and returns its ID.

	for (int i = 0; i < giTotalStrings; i++)
	{
		if (bOccupied[i] == false)
			return i; // Return the ID of the empty string.
	}; // end for

	return -1; // Faliure
};
