#include "stdafx.h"
#include "header.h"

class CMouseButtons
{
public:
	bool bDown[4];
	bool bPressed[4];
} butcheck;

bool mouseClick (int iButton)
{
	// Checks if a given button has been pressed, then
	// reset its state and report the results.

	if(butcheck.bPressed[iButton] == true)
	{
		butcheck.bPressed[iButton] = false;
		return true; // Yes, the button has been pressed.
	} // end if
	else
		return false; // No, the button has not been pressed.
};

int mouseClear (void)
{
    // Clears all the button states.
    
    for(int i = 0; i < 4; i++)
        butcheck.bPressed[i] = false;
    
    return 0; // Done
};

int mouseGFX(string tFileName)
{
    // Changes the mouse pointer to the selected file.
    
    destroy_bitmap(mMouse);
	mMouse = gfxLoad(tFileName, "mouse");
	set_mouse_sprite(mMouse);
	set_mouse_sprite_focus(32, 32);
    
    return 0; // Success
};

int  mouseUpdate (void)
{
    // Updates the state of the mouse buttons.
    
	if(mouse_b & 1)
        butcheck.bDown[1] = true;
    if(!(mouse_b & 1) && butcheck.bDown[1] == true)
	{
		butcheck.bDown[1] = false;
		butcheck.bPressed[1] = true;
    }; // end if    

	if(mouse_b & 2)
        butcheck.bDown[2] = true;
    if(!(mouse_b & 2) && butcheck.bDown[2] == true)
	{
		butcheck.bDown[2] = false;
		butcheck.bPressed[2] = true;
    }; // end if    

	if(mouse_b & 4)
        butcheck.bDown[3] = true;
    if(!(mouse_b & 4) && butcheck.bDown[3] == true)
	{
		butcheck.bDown[3] = false;
		butcheck.bPressed[3] = true;
    }; // end if    
    
    return 0;
};
