#include "stdafx.h"
#include "header.h"

int CMessage::ClearAll (void)
{
    // Clears all messages.
    
    for(int i = 0; i < giTotalMessages; i++)
        bActive[i] = false;
    
    return 0; // Done
};

int CMessage::Display (int iOffsetX, int iOffsetY)
{
    // Displays all the active messages. One helpful little feature is
    // the inclusion of offset. You can set messages to display at specific
    // areas of the map and then call this routine with offset so that when
    // the player scrolls, the messages will appear to scroll as well.
    
    for(int i = 0; i < giTotalMessages; i++)
    {
        if(bActive[i])
        {
            txtCenter(4, iX[i] - iOffsetX, iY[i] - iOffsetY, tText[i], -1, -1);
            
            iY[i] -= iSpeed[i];
            iLife[i]--;
            
            if(iLife[i] < 0)
                bActive[i] = false;
        };
    };
    
    return 0; // Done
};

int CMessage::New (int iAtX, int iAtY, string tMessage)
{
    // Creates a new message.
    
    int iSlot = FindEmpty_();
    
    if(iSlot == -1)
        return -1; // There are no open message slots D:
    
    bActive[iSlot] = true;
    iX[iSlot] = iAtX;
    iY[iSlot] = iAtY;
    tText[iSlot] = tMessage;
    iSpeed[iSlot] = 1;
    iLife[iSlot] = 30;
    
    return 0; // Success.
};

int CMessage::FindEmpty_ (void)
{
    // Finds an empty slot, or return -1 if no slots are open.
    // TODO: In the future, force a slot open if neccissary.
    
    for(int i = 0; i < giTotalMessages; i++)
    {
        if(!bActive[i])
            return i; // Success, return the ID of the open slot. :D
    };
    
    return -1; // Failure, can't find an open slot :'(    
};
