// This is the data for the message system that the game uses.
// "Messages" are a generic term for the little text pop-ups that
// appear to "float" over the map, such as when a unit takes
// damage, for example. This system is seperate from the default
// text object system because it needs to appear BELOW all GUI
// objects currently on the screen.

const int giTotalMessages = 50;

class CMessage
{
public:
    int ClearAll (void);
    int Display (int iOffsetX, int iOffsetY);
    int New (int iAtX, int iAtY, string tMessage);
private:
    int FindEmpty_ (void);
    
    bool bActive[giTotalMessages];              // Whether or not this message is active.
    
    int iLife[giTotalMessages];                 // How many more frames this message will last.
    int iSpeed[giTotalMessages];                // How many pixels per frame this message will move upwards.
    int iX[giTotalMessages];                    // Where the text is right now.
    int iY[giTotalMessages];                    // Where the text is right now.
    
    string tText[giTotalMessages];              // Message text.
};
