#include "stdafx.h"
#include "header.h"

class CKeys
{
public:
	bool bDown[256];
	bool bPressed[256];
} keycheck;

bool keyCheck (int iKey)
{
	// Checks if a given button has been pressed, then
	// reset its state and report the results.

	if(keycheck.bPressed[iKey] == true)
	{
		keycheck.bPressed[iKey] = false;
		return true; // Yes, the button has been pressed.
	} // end if
	else
		return false; // No, the button has not been pressed.
};

int keyReset (void)
{
	// Resets all the key flags.

	for(int i = 0; i < 256; i++)
		keycheck.bPressed[i] = false;

	return 0; // Success
};

int keyUpdate (void)
{
	// Checks to see if any keys have been pressed.

	for(int i = 0; i < 256; i++)
	{
		if(key[i])
			keycheck.bDown[i] = true;
		if(!key[i] && keycheck.bDown[i] == true)
		{
			// If a key has been pressed and the user has let go of
			// it, then set a flag.

			keycheck.bDown[i] = false;
			keycheck.bPressed[i] = true;
		}; // end if
	}; // end if

	return 0; // Success
};

