#include "stdafx.h"
#include "header.h"

int colorAlpha (BITMAP *bImage)
{
	// Since we'll be working with some non-32 bit images,
	// Allegro will mark everything as "translucent" when
	// they get loaded.  Normally this isn't a problem,
	// because we usually use the awesome power of Magic Pink.
	// However, if we want to use a hyrbrid of 32-bit and
	// non-32-bit images, we'll need to generate a valid
	// alpha channel for the image.  Everything that's not
	// magic pink will be turned into a "solid."

	int r;	// Red
	int g;	// Green
	int b;	// Blue

	for (int y = 0; y < bImage->h; y++)
	{
		for (int x = 0; x < bImage->w; x++)
		{
			int iColor = getpixel(bImage, x, y);
			r = getr(iColor);
			g = getg(iColor);
			b = getb(iColor);
			if(getpixel(bImage, x, y) != makecol(255, 0, 255)
                && getpixel(bImage, x, y) != makeacol(255, 255, 255, 0))
				putpixel(bImage, x, y, makeacol(r, g, b, 255));
			else
				putpixel(bImage, x, y, makeacol(r, g, b, 0));
		}; //end for
	}; //end for

	return 0; //Success.
};

int colorGet (void)
{
    // Copies color data from a bitmap image that will
    // be used to simulate "palette swaps."
    
    BITMAP *bImage = gfxLoad("color", "elements");
    
    for(int x = 0; x < 10; x++)
    {
        for(int y = 0; y < 7; y++)
        {
            giColorChart[x][y] = getpixel(bImage, x*4, y*4);
        }; // end y
    }; // end x
    
    destroy_bitmap(bImage);
    
    return 0; // Success
};

int colorGray (BITMAP *bImage)
{
    // Desaturates the color of a bitmap.

	int iX;
	int iY;

	for(iY = 0; iY < bImage->h; iY++)
	{
		for(iX = 0; iX < bImage->w; iX++)
		{
			int iColor = getpixel(bImage, iX, iY);
            if(iColor != makecol(255, 0, 255))
            {
                int iB = getb(iColor) - 64;
                int iG = getg(iColor) - 64;
                int iR = getr(iColor) - 64;
                if(iB < 0)
                    iB = 0;
                if(iG < 0)
                    iG = 0;
                if(iR < 0)
                    iR = 0;
                iColor = (iB + iG + iR) / 3;
                iColor = makecol(iR, iG, iB);
                //iColor = makecol(iColor, iColor, iColor);
                putpixel(bImage, iX, iY, iColor);
            }; // end if
		}; // end x
	}; // end y

	return 0;
};

int colorReplace (BITMAP *bImage, const int iColor, const int iReplace)
{
	// Replaces all pixels of a given color in an Allegro
	// bitmap with another color.  Useful for "palette
	// swap" since the engine runs in 32 bits, not in
	// a 256 color palette.

	int iX;
	int iY;

	for(iY = 0; iY < bImage->h; iY++)
	{
		for(iX = 0; iX < bImage->w; iX++)
		{
			if(getpixel(bImage, iX, iY) == iColor)
            {
                putpixel(bImage, iX, iY, iReplace);
            };
		};
	};

	return 0;
};

int colorSwap (BITMAP *bImage, const int iFrom, const int iTo)
{
    // Performs a palette swap on the selected image.

	for(int iY = 0; iY < bImage->h; iY++)
	{
		for(int iX = 0; iX < bImage->w; iX++)
		{
            int iColor = getpixel(bImage, iX, iY);
            for(int i = 0; i < 7; i++)
            {            
                if(iColor == giColorChart[iFrom][i])
                {
                    putpixel(bImage, iX, iY, giColorChart[iTo][i]);
                };
            }; // end i
		}; // end x
	}; // end y

    //for(int i = 0; i < 7; i++)
    //    {colorReplace(bImage, giColorChart[iFrom][i], giColorChart[iTo][i]);    
    
    return 0; // Success
};
