#include "stdafx.h"
#include "header.h"

class CSetup
{
public:
	int Init (void);
	int Graphics (void);
	int Input (void);
	int Network (void);
	int Sound (void);
	int Timers (void);
    int Text (void);
private:
	string tPath; // A temporary string for specifying file locations.
} setup;

int CSetup::Init()
{
	// Initializes the Allegro library, which is how the engine will
	// interface with the computer. The Allegro library allows the engine
	// to be easily ported to other platforms.  The engine may also use other
	// libraries which are listed in the stdafx.h header file.

	// Reserved error code space: 1xx
	
	if(allegro_init() != 0)
	{
	    allegro_message("Could not initialize the Allegro library.");
	    exit(101);
	};
    
    // We also want to grab the user's setting.ini file settings.
    
    parSettingsIni();
    
    // Now set the title for the application, for if the user will be
    // in windowed mode.
    
    //set_window_title(gTxt.Get("name"));
    
    // Make sure the user can quit by pressing the close button in
    // Windows or whatever other OS they're using.
    
    // TODO: Add the overly complicated code for the close button callback.
    
    // Initialize the random number generator.
    
    srand(time(0));

	return 0;
};

int CSetup::Graphics (void)
{
	// Sets up the graphic modes. This section can get a little lengthy because
	// it's hard keeping everyone and their computer happy. The graphic mode that
	// is currently used is 640 x 480, or whatever is listed in the header.h
	// header file.

	// Reserved error code space: 3xx

	// We want to enable hardware acceleration for "blitting" (displaying bitmap
	// graphics) to the screen.

	gfx_capabilities = GFX_HW_MEM_BLIT;

	// The color depth needs to be set at 32-bits. 24-bit color would work, however
	// 24-bit color also tends to be notoriously slow.

	set_color_depth(32);
    
	// The user can choose between fullscreen and windowed mode.  The default is
	// fullscreen.  Holding the shift key while starting the engine will force
	// windowed mode.  For that reason, the keyboard routine MUST be intilized first.

	if(key[KEY_LSHIFT] || key[KEY_RSHIFT])
		sys_bWindowedMode = true;

	if(sys_bWindowedMode == false)
	{
        if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
    	{
			set_color_depth(16);
			if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
			{
				allegro_message("There was a problem, and the program was unable to setup the FULLSCREEN display. Try running the game in windowed mode by holding the shift key when booting up.\n\nAllegro Error:\n%s", allegro_error);
				exit(301);
			};
		};    
	}
	else
	{
		if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
    	{
			set_color_depth(16);
			if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
			{
				allegro_message("There was a problem, and the program was unable to setup the WINDOWED display.\n\nAllegro Error:\n%s", allegro_error);
				exit(302);
			};
		};    
	};

	// Enable Transparency

	set_trans_blender(0, 0, 0, 127);

	// Start up the external library routines so we can use png and jpeg files.

	loadpng_init();
	jpgalleg_init();

	// Now, we initialize the screen buffer.

	mBuffer = create_bitmap(sys_iScreenWidth, sys_iScreenHeight);
	clear(mBuffer);

	// The following loads and sets the default mouse cursor.  The user can
	// change it for their own campaigns, but this is what we start with.

    mouseGFX("Pointer_01");

	return 0;
};

int CSetup::Input (void)
{
	// Installs the input

	// Reserved error code space: 4xx

	install_keyboard();
	install_mouse();
    
    //set_mouse_speed(2000, 2000);

	return 0;
};


int CSetup::Network (void)
{
	// Installs all the networking functions that the engine will
	// use for LAN and internet play.

	// Reserved error code space: 6xx

	// TODO: Add an option in the user prefrences file that can allow the
	// end-user to disable the networking features, in which case this
	// entire function will be skipped.

	// Currently, the engine does not support network play. This may
	// or may not be added at a future date.  This routine is present
	// for future support.

	return 0;
};

int CSetup::Sound (void)
{
	// Installs all the sound and music routines that the engine
	// will need to use.

	// Reserved error code space: 5xx

	install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);

	// TODO: Add volume controls in the user prefrences file. Until then,
	// the volume will be hardcoded here.

	set_volume(255, 255);

	return 0;
};

int CSetup::Text (void)
{
    // Imports any text or text support that the engine will
    // need.
    
    // Reserved error code space: 7xx
    
    // Load all the system text for the current language.
    
    parStrings(gTxt, "system");
    
    return 0; // Success
};

int CSetup::Timers (void)
{
	// Installs the timers used by the game. This allows the game
	// to run at the same speed on all computers.

	// Reserved error code space: 2xx

	install_timer();

	// The game runs at 60 fps, so we need to install and Allegro
	// timer that ticks every 1/60th of a second. The timer code
	// is located elsewhere.

	if(install_int_ex(timeIncrease, BPS_TO_TIMER(60)) != 0)
	{
	    allegro_message("Error setting up the frames per second timer.\n\nTry shutting down any other applications running, and then run the program again.");
	    exit(201);
	};

	if(install_int_ex(timeSecondIncrease, SECS_TO_TIMER(1)) != 0)
	{
	    allegro_message("Error setting up the clock timer.\n\nTry shutting down any other applications running, and then run the program again.");
	    exit(201);
	};

	return 0;
};

int setupCore (void)
{
	setup.Init();
	setup.Timers();
	setup.Input();
	setup.Graphics();
	setup.Sound();
    if(sys_tLanguage != "XX")
        setup.Text();
    setup.Network();
	
	return 0;
};
