#include "stdafx.h"
#include "header.h"

int CTerrain::Purge (void)
{
    tName = "";
    tHandle = "";
    tBase = "!NONE";
    
    iPriority = 0;
    iSmooth = 0;
    iBase = -1;
    
    for(int i = 0; i < 12; i++)
        iCost[i] = -1;
    
    iDef = 0;
    iRes = 0;
    iAvo = 0;
    iHeal = 0;
    iRec = 0;
    
    return 0; // Success
};

int terrainAt (int iX, int iY)
{
    // Returns the ID of the terrain at a given space.
    
    int iTerrain = 0;
    
    for(int l = 3; l > -1; l--)
    {
        if(map.iTerrain[l][iX][iY] != 0)
        {
            iTerrain = map.iTerrain[l][iX][iY];
            l = -1;
        };
    };    
    
    return iTerrain;
};

int terrainFind (string tToFind)
{
    // Finds a terrain type with a given handle.
    
    for(int i = 0; i <= giTerrainSlotsUsed; i++)
    {
        if(terrain[i].tHandle == tToFind)
            return i; // Success. Found the terrain.
    }; // end for
    
    return -1; // Failure. The terrain does not appear to exist.
}; // end terrainFind

int terrainLoad (string tFile)
{
	// A routine for parsing terrain data from a file.
	
	FILE * pFile;					// A pointer to the file.
	string tInput;					// Input from the parser.
	
	// First, we need to make sure the file is actually there. In the future,
	// if it's missing, we fall back on the default class data. For now, we
	// just boot the player. :3
	
	if(!exists(tFile.c_str()))
	{
		allegro_message("The terrain data that the engine needs appears to be missing.");
		exit(-1);
	}; //end if
	
	// Okay, let's start by clearing out major terrain data. Everything else
	// we can pretty much clear as we go.
	
	giTerrainSlotsUsed = -1;
	
	// We can now open the file...
	
	pFile = fopen(tFile.c_str(), "rt");
	
	// ...And begin parsing the data. We keep going until we hit the end of the file.
	
	while(!feof(pFile))
	{
		// First get the next command.
		
		tInput = parGet(pFile, ' ', '\n', ',');

		// CLASS
		
		if(tInput == "TERRAIN")
		{
			int iSlot = 0;				// The slot number this terrain will take.
			
            // Increase the total number of terrains availible by one.
            
            giTerrainSlotsUsed++;
            
			// Get the terrain's slot number, then assign this terrain to
            // the priority list.
			
			tInput = parGet(pFile, ' ', '\n', ',');
			iSlot = atoi(tInput.c_str());
            giTerrainPres[giTerrainSlotsUsed] = iSlot;
            
            // Reset any vital data.
            
            terrain[iSlot].Purge();
			
			// Then get the terrain's name.
            
            tInput = parGet(pFile, ' ', '\n', ',');
            terrain[iSlot].tName = tInput;
            terrain[iSlot].tHandle = tInput;
            
            // Now start processing data
            
            tInput = parGet(pFile, ' ', '\n', ',');        

            while(tInput != "}" && !feof(pFile))
            {            
                // base
                
                if(tInput == "base")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    tInput = parGet(pFile, ' ', '\n', ',');
                    terrain[iSlot].tBase = tInput;
                }; // end if base
                
                // smoothing
                
                if(tInput == "smoothing")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    tInput = parGet(pFile, ' ', '\n', ',');
                    
                    if(tInput == "on")
                        terrain[iSlot].iSmooth = 1;
                    if(tInput == "manual")
                        terrain[iSlot].iSmooth = 2;
                }; // end if smoothing
                
                // PROPERTIES
                
                if(tInput == "PROPERTIES")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    
                    while(tInput != "}")
                    {
                        // Cost
                        
                        if(tInput == "cost")
                        {
                            int iFor = 0;
                            tInput = parGet(pFile, ' ', '\n', ',');
                            iFor = atoi(tInput.c_str());
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            terrain[iSlot].iCost[iFor] = atoi(tInput.c_str());
                        }; // end if cost
                        
                        // Def
                        
                        if(tInput == "def" || tInput == "defense")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            terrain[iSlot].iDef = atoi(tInput.c_str());
                        } // end if def
    
                        // Res
                        
                        if(tInput == "res" || tInput == "resistance")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            terrain[iSlot].iRes = atoi(tInput.c_str());
                        } // end if res                    
    
                        // Avoid
                        
                        if(tInput == "avo" || tInput == "avoid")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            terrain[iSlot].iAvo = atoi(tInput.c_str());
                        } // end if avoid
                        
                        // Heal
                        
                        if(tInput == "heal")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            terrain[iSlot].iHeal = atoi(tInput.c_str());
                        } // end if heal
    
                        // Recover
                        
                        if(tInput == "rec" || tInput == "recover" || tInput == "restore")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            terrain[iSlot].iRec = atoi(tInput.c_str());
                        } // end if recover                    
                        
                        tInput = parGet(pFile, ' ', '\n', ',');
                    }; // end while
                }; // end if PROPERTIES
                
                tInput = parGet(pFile, ' ', '\n', ',');
            }; // end while
        };
        
		// If we ever hit a # comment line, then we want to skip the
		// entire thing. We'll have to handle that locally, so we
		// create a new char variable to deal with it.
		
		if(tInput == "#")
		{
			char cSingle;
            
            cSingle = (char)fgetc(pFile);
			
			while(cSingle != '\n')
			{
				cSingle = (char)fgetc(pFile);
			}; // end while
		}; // end if COMMENTS
	}; // end while
	
	return 0; // Success
};
