#include "stdafx.h"
#include "header.h"

// class CMap's functions.

int CMap::Clear (void)
{
	// Clears all the map data so that "artifacts" from old maps
	// won't show up when a new map is loaded.

	ClearHeader_();
    ClearRange();
	ClearTerrain_();
    ClearUnits_();

	return 0;	// Success
};

int CMap::ClearHeader_ (void)
{
	// Clears the header data.

	tName = "";
	tAuthor = "";
	tDescription = "";
	tVersion = "";
	iSizeX = giTilesWide;
	iSizeY = giTilesHigh;
	iTileSet = 0;

	return 0;	// Done
};

int CMap::ClearRange (void)
{
    // Clears the movement range colors from the map.
    
    for(int x = 0; x < maxWIDTH; x++)
    {
        for(int y = 0; y < maxHEIGHT; y++)
        {
            iRange[x][y] = 0;
        }; // end y
    }; // end x
    
    return 0; // Done
};

int CMap::ClearTerrain_ (void)
{
	// Clears the terrain data

	for(int layer = 0; layer < 4; layer++)
	{
		for(int x = 0; x < maxWIDTH; x++)
		{
			for(int y = 0; y < maxHEIGHT; y++)
			{
                iFlag[x][y] = -1;
                iTile[layer][x][y] = 0;
				if(layer == 0)
					iTerrain[layer][x][y] = 1; // If it's the base layer, set the default tile.
				else
					iTerrain[layer][x][y] = 0; // Otherwise, set an "empty" null tile.
			}; // end x for
		}; // end y for
	}; // end layer for
    
	// Now, destory and clear the bitmap to avoid memory leaks.

	destroy_bitmap(mTiles);
	mTiles = NULL;

	return 0;	// Done
};

int CMap::ClearUnits_ (void)
{
    // Clears unit data.
    
    giTotalUnits = 0;
    
    // Clear the generic unit data

    for(int x = 0; x < maxWIDTH; x++)
	{
		for(int y = 0; y < maxHEIGHT; y++)
		{
			iGeneric[x][y] = 0;
		}; // end x for
    }; // end y for 
    
    return 0; // Done
};

int CMap::Display (int iX, int iY, int iOffsetX, int iOffsetY, bool bOjectsOn, int iWorkingLayer)
{
	// Displays the map to the screen buffer bitmap.

    for(int y = -1; y < giTilesHigh + 1; y++)
    {
        for(int x = -1; x < giTilesWide + 1; x++)
        {
            DisplayTile_(mBuffer, x+iX, y+iY, x*giTileX + iOffsetX, y*giTileY + iOffsetY);
        }; // end x for
    }; // end y for
    
    // Display the movement range tiles
    
   for(int y = -1; y < giTilesHigh + 1; y++)
    {
        for(int x = -1; x < giTilesWide + 1; x++)
        {
            if(iRange[x+iX][y+iY] == 1 || iRange[x+iX][y+iY] == 2)
            {
                drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
                rectfill(mBuffer, x*giTileX + iOffsetX, y*giTileY + iOffsetY, (x*giTileX) + giTileX - 1 + iOffsetX, (y*giTileY) + giTileY - 1 + iOffsetY, makecol(iGlowValue, 127, iGlowValue));
                solid_mode();
            };    
            if(iRange[x+iX][y+iY] == 3)
            {
                drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
                rectfill(mBuffer, x*giTileX + iOffsetX, y*giTileY + iOffsetY, (x*giTileX) + giTileX - 1 + iOffsetX, (y*giTileY) + giTileY - 1 + iOffsetY, makecol(255, iGlowValue, iGlowValue));
                solid_mode();
            };                
        };
   };
   
    if(iGlowAt == 0 || iGlowValue <= 0)
    {
        iGlowAt = 2;
    }
    else if(iGlowValue >= 127)
    {
        iGlowAt = -2;
    };
    
    iGlowValue += iGlowAt;
    
    // Display Gird if Needed
    
    if(bGrid)
		Grid(iOffsetX, iOffsetY);

    // Displays Units Starting Points (Editor Only)
    
	for(int y = -1; y < giTilesHigh + 1; y++)
	{
		for(int x = -1; x < giTilesWide + 1; x++)
		{
            int iUnitHere = iGeneric[x + iX][y + iY];
			if(iUnitHere != 0 && x + iX > -1 && y + iY > -1)
            {
                int iLocX = (x * giTileX);// - giUnitOffsetX;
                int iLocY = (((y) * giTileY));// /*- (giTileHeight - giTileY)*/) - giUnitOffsetY;
                //int iSrcX = giUnitSourceX;
                //int iSrcY = giUnitSourceY;
                unitDisplay(iUnitHere, iFaction[x + iX][y + iY], 0, iLocX + iOffsetX, iLocY + iOffsetY);
            };
		}; // end x for
    }; // end y for

	return 0; // Success
};

int CMap::DisplayTile_ (BITMAP *mTo, int iX, int iY, int iAtX, int iAtY)
{
    // Displays a single tile at a given location on a given bitmap.
    
    iAtY = iAtY - (giTileHeight - giTileY);
    
    for(int l = 0; l < giTerrainLayers; l++)
    { 
        int iThis = iTerrain[l][iX][iY];
        int iUp = iTerrain[l][iX][iY - 1];
        int iRight = iTerrain[l][iX + 1][iY];
        int iLeft = iTerrain[l][iX - 1][iY];
        int iDown = iTerrain[l][iX][iY + 1];
        int iUpRight = iTerrain[l][iX + 1][iY - 1];
        int iDownRight = iTerrain[l][iX + 1][iY + 1];
        int iUpLeft = iTerrain[l][iX - 1][iY - 1];
        int iDownLeft = iTerrain[l][iX - 1][iY + 1];
        
        int iSrcX = (iTile[l][iX][iY] * giTileWidth) + giTileWidth;
        int iSrcY; // = ((iTerrain[l][x + iX][y + iY] - 1) * giTileHeight) + giTileHeight;
        //if(iTerrain[l][x + iX][y + iY] != 0)
        //	masked_blit(mTiles, mBuffer, iSrcX, iSrcY, iLocX + iOffsetX, iLocY + iOffsetY, giTileWidth, giTileHeight);
        
        if(iX < 1)
        {
            iLeft = iThis;
            iUpLeft = iThis;
            iDownLeft = iThis;
        };
        if(iY < 1)
        {
            iUp = iThis;
            iUpLeft = iThis;
            iUpRight = iThis;
        };
        if(iX > map.iSizeX - 2)
        {
            iRight = iThis;
            iUpRight = iThis;
            iDownRight = iThis;
        };
        if(iY > map.iSizeY - 2)
        {
            iDown = iThis;
            iDownRight = iThis;
            iDownLeft = iThis;
        };
        
        // Smoothing
        
        for(int j = giTerrainSlotsUsed - 1; j >= 0; j--)
        {
            // Get the terrain we will be checking.
            
            int i = giTerrainPres[j];
            
            // Centers
    
            if(i == iThis && iThis != 0)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            
            if(i != iThis && i == iUp && i == iDown && i == iRight && i == iLeft && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 32, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
            
            // Three-Way Corners
            
            else if(i != iThis && i == iLeft && i == iUp && i == iDown && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 320, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }                    
            else if(i != iThis && i == iDown && i == iLeft && i == iRight && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 352, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
            else if(i != iThis && i == iRight && i == iUp && i == iDown && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 384, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
            else if(i != iThis && i == iLeft && i == iUp && i == iRight && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 416, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
    
            // Two-Way Corners
            
            else if(i != iThis && i == iUp && i == iLeft && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 64, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
            else if(i != iThis && i == iDown && i == iLeft && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 128, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
            else if(i != iThis && i == iDown && i == iRight && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 160, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            }
            else if(i != iThis && i == iUp && i == iRight && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 96, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            
            // Sides
    
            if(i != iThis && i == iRight && i != iUp && i != iDown && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 224, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            if(i != iThis && i == iLeft && i != iUp && i != iDown && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 192, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            if(i != iThis && i == iDown && i != iRight && i != iLeft && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 288, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            if(i != iThis && i == iUp && i != iRight && i != iLeft && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 256, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            
            // Diagonals
            
            if(i != iThis && i == iUpLeft && i != iUp && i != iLeft  && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 448, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            if(i != iThis && i == iUpRight && i != iUp && i != iRight  && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 480, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            if(i != iThis && i == iDownLeft && i != iDown && i != iLeft  && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 512, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            if(i != iThis && i == iDownRight && i != iDown && i != iRight  && terrain[i].iSmooth == 1)
            {
                iSrcY = ((i - 1) * giTileHeight) + giTileHeight;
                masked_blit(mTiles, mTo, iSrcX + 544, iSrcY, iAtX, iAtY, giTileWidth, giTileHeight);
            };
            
        }; // end smoothing    
    }; // end l
    
    return 0; // Done
};

int CMap::Grid (int iX, int iY)
{
	// Displays a grid. iX and iY are the offset from the screen
	// origin for when you want smooth scrolling.
	
	drawing_mode(DRAW_MODE_TRANS, 0, 0, 0); // Turn on transparency
	
	for(int y = -1; y < giTilesHigh + 1; y++)
	{
		for(int x = -1; x < giTilesWide + 1; x++)
		{
			line(mBuffer, (x * giTileX) + iX, (y * giTileY) + iY, ((x + 1) * giTileX) + iX - 1, (y * giTileY) + iY, makecol(0, 0, 0));
			line(mBuffer, (x * giTileX) + iX, (y * giTileY) + iY + 1, (x * giTileX) + iX, ((y + 1) * giTileY) + iY - 1, makecol(0, 0, 0));
		}; // end x for
	}; // end y for
	
	solid_mode(); // Turn off transparency
	
	return 0; // Success
};	

int CMap::LoadTiles (string tFileName)
{
	// This function will load the map tiles to be used.

	mTiles = gfxLoad(tFileName, "tiles");
	colorReplace(mTiles, makecol(255, 128, 255), makecol(255, 0, 255));

	return 0; // Success
};

int CMap::Terrain (int iX, int iY)
{
    // Returns the ID of the top-most terrain at a given map cordinate.
    
    int iTerrain = 0;
    
    for(int l = 3; l > -1; l--)
    {
        if(map.iTerrain[l][iX][iY] != 0)
        {
            iTerrain = map.iTerrain[l][iX][iY];
            l = -1;
        };
    };    
    
    return iTerrain;
};    

int CMap::ToggleGrid (void)
{
	// Toggles the grid display on or off.
	
	if(bGrid)
		bGrid = false;
	else
		bGrid = true;
	
	return 0; // Success
};
