#include "stdafx.h"
#include "header.h"

class CMainLoop
{
public:
    int Main (void);
    int SetupMap (void);
private:
    int Display_ (void);
    int FindMouse_ (void);
    int MoveMap_ (int iDirection);
    int ScrollMap_ (void);
    int SetUnit_ (int iUnit, int x, int y);
    int TurnStart_ (void);
    
    BITMAP *mArrows;        // The movement arrows.
    BITMAP *mHP;            // The HP bar.
    BITMAP *mStatBG[5];     // The status screen backgrounds
    
    bool bTurnHasStarted;   // Whether or not the phase intro animation has completed and the faction's turn has begun.
    bool bQuit;             // True when the main loop is finished.
    
    int iFade;              // How opaque the color fade at the beginning of a faction's turn is right now.
    int iFadeSpeed;         // How quickly the fade is to occure.
    
    int iFaction;           // Who's turn it is.
	int iOffsetX;			// How far from the map's X origin the screen is.
	int iOffsetY;			// How far from the map's X origin the screen is.
	int iOffsetXX;			// An additional pixel offset to add to OffsetX to give a true scrolling effect.
	int iOffsetYY;			// An additional pixel offset to add to OffsetY to give a true scrolling effect.
	int iScrollSpeed;		// How quickly to scroll the screen.
    int iStatWindow;        // The stat window for this unit is up.
    int iWinner;            // Which team has won this map; the value that the main loop will return.
	int iX;					// The X Location of the Tile that the mouse is currently hovering over.
	int iY;					// The Y Location of the Tile that the mouse is currently hovering over.
	int iXPos;				// The exact location on the screen of the tile that the mouse is hovering over on the screen.
	int iYPos;				// The exact location on the screen of the tile that the mouse is hovering over on the screen.
} loop;

int CMainLoop::Main (void)
{
    // The main game loop.  Cycles through each faction's turn and
    // handles the display.
    
    bQuit = false;
    
    iWinner = -1;
    iStatWindow = -1;
    mHP = gfxLoad("hp_bar", "elements");
    mArrows = gfxLoad("movement", "elements");
    mStatBG[0] = gfxLoad("stats_bg", "gui");
    mStatBG[1] = gfxLoad("stats_01", "gui");
    mStatBG[2] = gfxLoad("stats_02", "gui");
    colorReplace(mArrows, makecol(255, 128, 255), makecol(255, 0, 255));
    map.LoadTiles("001");
    iOffsetX = 0;
    iOffsetXX = 0;
    iOffsetY = 0;
    iOffsetYY = 0;
    iScrollSpeed = 4;
    
    playerTurn(-1);
    iFaction = 0;
    iFadeSpeed = 4;
    iFade = 0;
    
    //aiRange(1);
    
    while(!bQuit)
    {
        // Update the Mouse
        
        FindMouse_();
        
        // Run the display
        
        Display_();
        
        // Get Commands from the Player or AI
        
        if(iFade == 0 && !battle.bActive && iStatWindow == -1)
        {
            int iReturn = 0;
            
            if(!bTurnHasStarted)
            {
                factionStart(iFaction);
                bTurnHasStarted = true;
            }
            else
                iReturn = playerTurn(iFaction);
            
            if(iReturn > 0)
            {
                // Bring up Stat Window
                iStatWindow = iReturn - 2;
            };
            
            if(iReturn == -1)
            {
                unitReset(iFaction);
                if(giTeams > 1)
                    iFaction ++;
                iFadeSpeed = 8;
                bTurnHasStarted = false;
            };
            
            if(iReturn == -2)
            {
                bQuit = true;
                iWinner = iFaction;
            };
        }
        
        // Perform the battle animation.
        
        else if(battle.bActive)
        {
            battle.Simple();
        };
        
        while(faction[iFaction].bActive == false && giTeams > 1)
        {
            iFaction ++;
            if(iFaction > 6)
                iFaction = 0;
        };
        
        // Check if a team has won.
        
        if(giTeams == 1)
        {
            bQuit = true;
            iWinner = iFaction;
        };
        
        // Perform the effects at the beginning of a faction's turn, as neccissary.
        
        if(iFadeSpeed != 0)
        {
            iFade += iFadeSpeed;
            if(iFade >= 256)
                iFadeSpeed = -4;
            if(iFade <= 0)
            {
                iFadeSpeed = 0;
                iFade = 0;
            };
        };
        
        // Handle Map Scrolling Goodness
		
		ScrollMap_();
		
		if(mouse_x > (SCREEN_W - giTileX) && iOffsetX < map.iSizeX - giTilesWide
			|| key[KEY_RIGHT] && iOffsetX < map.iSizeX - giTilesWide)
			MoveMap_(dRIGHT);
		if(mouse_x < giTileX && iOffsetX > 0
			|| key[KEY_LEFT] && iOffsetX > 0)
			MoveMap_(dLEFT);
		if(mouse_y > (SCREEN_H - giTileY) && iOffsetY < map.iSizeY - giTilesHigh
			|| key[KEY_DOWN] && iOffsetY < map.iSizeY - giTilesHigh)
			MoveMap_(dDOWN);
		if(mouse_y < giTileY && iOffsetY > 0
			|| key[KEY_UP] && iOffsetY > 0)
			MoveMap_(dUP);
        
        // Control Keys -- These need to be active even outside the player's turn.
        
        if(iFade != 0)
        {
            if(mouseClick(1) || mouseClick(2))
            {
                iFadeSpeed = 0;
                iFade = 0;
            };
        };
        if(keyCheck(KEY_ESC))
        {
            bQuit = true;
        };
		if(keyCheck(KEY_G))
			map.ToggleGrid();
    };    

    // clean everything up before going back.
    
    msg.ClearAll();
    unitKillAll();
    unitClear();
    guiKillAll();    
    destroy_bitmap(mHP);
    destroy_bitmap(mArrows);
    
    return iWinner; // Done
};

int CMainLoop::SetupMap (void)
{
    // Sets the raw map data up to play a game.
    
    int iUnit = 0;
    
    giTeams = 0;
    
    // First, we must turn off all the factions.
    
    for(int i = 0; i < 7; i++)
    {
        faction[i].bActive = false;
        faction[i].iUnits = 0;
    };
    
    // Now, parse the text data.
    
    parStrings(txt, "gameplay");
    
    // We need to transfer all the unit's starting positions
    // to actual units.
    
    for(int x = 0; x < map.iSizeX; x++)
    {
        for(int y = 0; y < map.iSizeY; y++)
        {
            if(map.iGeneric[x][y] != 0)
            {
                SetUnit_(iUnit, x, y);
                iUnit++;
            };
        };
    };
    
    return 0; // Done
};

int CMainLoop::Display_ (void)
{
    // Run the Display
    
    if(iStatWindow == -1)
    {
        map.Display(iOffsetX, iOffsetY, iOffsetXX, iOffsetYY, false, 0);
        unitUpdate();
        
        for(int x = 0; x < map.iSizeX; x++)
        {
            for(int y = 0; y < map.iSizeY; y++)
            {
                for(int i = 0; i < 250; i++)
                {
                    if(unit[i].bActive && unit[i].iLocX == x && unit[i].iLocY == y)
                    {
                        int iHPLength = 0;
                        
                        if(unit[i].iHPBar == unit[i].iMaxHP)
                            iHPLength = 20;
                        else
                        {
                            iHPLength = (unit[i].iHPBar * 20) / unit[i].iMaxHP;
                        };
                        
                        if(rank[unit[i].iClass].bNoAnim)
                            masked_blit(unit[i].mImage, mBuffer, giUnitSourceX, giUnitSourceY + (giUnitHeight*0),
                                (unit[i].iX - iOffsetX * 32) - giUnitOffsetX + iOffsetXX, (unit[i].iY - iOffsetY*32) - giUnitOffsetY + iOffsetYY, giUnitWidth, giUnitHeight);                            
                        else
                            masked_blit(unit[i].mImage, mBuffer, giUnitSourceX + (giUnitWidth * giUnitBob[0]), giUnitSourceY + (giUnitHeight*0),
                                (unit[i].iX - iOffsetX * 32) - giUnitOffsetX + iOffsetXX, (unit[i].iY - iOffsetY*32) - giUnitOffsetY + iOffsetYY, giUnitWidth, giUnitHeight);
                        masked_blit(mHP, mBuffer, 0, 0, (unit[i].iX - iOffsetX * 32) + 24 + iOffsetXX, (unit[i].iY - iOffsetY * 32) - 2 + iOffsetYY, 8, 24);
                        masked_blit(mHP, mBuffer, 8, 22 - iHPLength, (unit[i].iX - iOffsetX * 32) + 24 + iOffsetXX, (unit[i].iY - iOffsetY * 32) - iHPLength + 20 + iOffsetYY, 8, iHPLength);                        
                        draw_sprite(mBuffer, faction[unit[i].iFaction].mIcon, (unit[i].iX - iOffsetX * 32) + 20 + iOffsetXX, (unit[i].iY - iOffsetY * 32) + 20 + iOffsetYY);
                    };
                };
            };
        };
        
        // Draw unit paths as neccisary (you should only need to draw one path at a time.
      
        if(!unitMoving())
        {
            for(int i = 0; i < 250; i++)
            {
                if(unit[i].bActive == true && unit[i].vPath.size() > 1)
                {
                    for(unsigned j = 0; j < unit[i].vPath.size(); j++)
                    {
                        int iArrowGFX = 0;
                        int iThisX = unit[i].vPath[j].iX;
                        int iThisY = unit[i].vPath[j].iY;                
                        
                        if(j > 0 && j < unit[i].vPath.size() - 1)
                        {
                            int iPastX = unit[i].vPath[j - 1].iX;
                            int iPastY = unit[i].vPath[j - 1].iY;
                            int iNextX = unit[i].vPath[j + 1].iX;
                            int iNextY = unit[i].vPath[j + 1].iY;
                            
                            if(iThisX > iPastX && iThisY == iPastY && iThisX < iNextX && iThisY == iNextY
                                || iThisX < iPastX && iThisY == iPastY && iThisX > iNextX && iThisY == iNextY)
                                iArrowGFX = 6;
                            else if(iThisX == iPastX && iThisY > iPastY && iThisX == iNextX && iThisY < iNextY
                                || iThisX == iPastX && iThisY < iPastY && iThisX == iNextX && iThisY > iNextY)
                                iArrowGFX = 5;
                            else if(iThisX > iPastX && iThisY == iPastY && iThisX == iNextX && iThisY > iNextY
                                || iThisX == iPastX && iThisY > iPastY && iThisX > iNextX && iThisY == iNextY)
                                iArrowGFX = 7;
                            else if(iThisX == iPastX && iThisY > iPastY && iThisX < iNextX && iThisY == iNextY
                                || iThisX < iPastX && iThisY == iPastY && iThisX == iNextX && iThisY > iNextY)
                                iArrowGFX = 8;
                            else if(iThisX < iPastX && iThisY == iPastY && iThisX == iNextX && iThisY < iNextY
                                || iThisX == iPastX && iThisY < iPastY && iThisX < iNextX && iThisY == iNextY)
                                iArrowGFX = 9;
                            else if(iThisX > iPastX && iThisY == iPastY && iThisX == iNextX && iThisY < iNextY
                                || iThisX == iPastX && iThisY < iPastY && iThisX > iNextX && iThisY == iNextY)
                                iArrowGFX = 10;
                        }
                        else if (j > 0)
                        {
                            int iPastX = unit[i].vPath[j - 1].iX;
                            int iPastY = unit[i].vPath[j - 1].iY;
                            
                            if(iThisX < iPastX)
                                iArrowGFX = 1;
                            if(iThisY < iPastY)
                                iArrowGFX = 2;
                            if(iThisX > iPastX)
                                iArrowGFX = 3;
                            if(iThisY > iPastY)
                                iArrowGFX = 4;        
                        }
                        else if (j == 0)
                        {
                            int iNextX = unit[i].vPath[j + 1].iX;
                            int iNextY = unit[i].vPath[j + 1].iY;
                            
                            if(iThisX < iNextX)
                                iArrowGFX = 13;
                            if(iThisY < iNextY)
                                iArrowGFX = 14;
                            if(iThisX > iNextX)
                                iArrowGFX = 11;
                            if(iThisY > iNextY)
                                iArrowGFX = 12;
                        };
                        
                        masked_blit(mArrows, mBuffer, iArrowGFX * giTileX, 0, (unit[i].vPath[j].iX - iOffsetX) * giTileX + iOffsetXX, (unit[i].vPath[j].iY - iOffsetY) * giTileY + iOffsetYY, giTileX, giTileY);
                    };
                };
            };
        };
    
        // Display any messages.
        
        msg.Display(iOffsetX * giTileX, iOffsetY * giTileY);
        
        // Highlight the square that the player is hovering over.
        
        drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
        if(!playerBusy() && iFade == 0)
            rectfill(mBuffer, iXPos, iYPos, iXPos + giTileX - 1, iYPos + giTileY - 1, makecol(255, 255, 255));        
        solid_mode();        
        
        // Perform the turn opening animation
        
        if(iFade != 0)
        {
            int iFadeAt = iFade;
            if(iFadeAt > 127)
                iFadeAt = 127;
            
            set_trans_blender(0, 0, 0, iFadeAt + iFadeAt/2);
            drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
            //rectfill(mBuffer, 0, 0, 640, 100, giColorChart[iFaction + 1][2]);
            //rectfill(mBuffer, 0, 380, 640, 480, giColorChart[iFaction + 1][2]);
            rectfill(mBuffer, 0, 150, 640, 330, giColorChart[iFaction + 1][2]);
            //rectfill(mBuffer, 0, 0, 640, 480, giColorChart[iFaction + 1][2]);
            //txtCenter(2, 320, 200, txt.Get("faction") + " " + txtInt(iFaction), 0, -1);
            txtCenter(5, 320, 224, faction[iFaction].tName + " " + txt.Get("phase"), 0, -1);
            txtCenter(2, 320, 260, txtInt(faction[iFaction].iUnits) + " " + txt.Get("left"), 0, -1);
            solid_mode();
            set_trans_blender(0, 0, 0, 127); // Return the trans_blender back to default.
        };
    }
    else
    {
        // TODO: The stat screen needs to move to its own function eventually,
        // outside of the main game loop, so that it doesn't take up so much
        // space, and so that editor functions can call on it.
        
        blit(mStatBG[0], mBuffer, 0, 0, 0, 0, sys_iScreenWidth, sys_iScreenHeight);
        masked_blit(mStatBG[1], mBuffer, 0, 0, 0, 0, sys_iScreenWidth, sys_iScreenHeight);
        masked_blit(mStatBG[2], mBuffer, 0, 0, 0, 0, sys_iScreenWidth, sys_iScreenHeight);
        
        txtOut(5, 2 *16, 1 *16, unit[iStatWindow].tName, 0, -1);
        //txtCenter(5, 8 *16, 16 *16, unit[iStatWindow].tName, 0, -1);
        txtOut(2, 3 *16, 52, rank[unit[iStatWindow].iClass].tName, 0, -1);
        
        txtOut(2, 4 *16, 20 *16, txt.Get("LEV"), 0, -1);
           txtRight(5, 9 *16, 19 *16, txtInt(unit[iStatWindow].iLev), 0, -1);
           txtOut(2, 10 *16, 20 *16, "/ " + txtInt(rank[unit[iStatWindow].iClass].iMaxLEV), 0, -1);
        txtOut(2, 4 *16, 22 *16, txt.Get("HP"), 0, -1);
           txtRight(5, 9 *16, 21 *16, txtInt(unit[iStatWindow].iHP), 0, -1);
           txtOut(2, 10 *16, 22 *16, "/ " + txtInt(unit[iStatWindow].iMaxHP), 0, -1);
        txtOut(2, 4 *16, 24 *16, txt.Get("MP"), 0, -1);
           txtRight(5, 9 *16, 23 *16, txtInt(unit[iStatWindow].iMP), 0, -1);
           txtOut(2, 10 *16, 24 *16, "/ " + txtInt(unit[iStatWindow].iMaxMP), 0, -1);
        txtOut(2, 4 *16, 26 *16, txt.Get("EXP"), 0, -1);
           txtRight(5, 9 *16, 25 *16, txtInt(unit[iStatWindow].iEXP), 0, -1);
           txtOut(2, 10 *16, 26 *16, "/ " + txtInt(unit[iStatWindow].iNext), 0, -1);
        
        //txtCenter(5, 28 *16, 6 *16, "Unit Stats", 0, -1);
        txtOut(5, 17 *16, 6 *16, "Unit Stats", 0, -1);
        txtOut(2, 18 *16, 10 *16, txt.Get("STR"), 0, -1);
          txtRight(5, 25 *16, 9 *16, txtInt(unit[iStatWindow].iSTR), 0, -1);
        txtOut(2, 29 *16, 10 *16, txt.Get("MAG"), 0, -1);
          txtRight(5, 36 *16, 9 *16, txtInt(unit[iStatWindow].iMAG), 0, -1);
        txtOut(2, 18 *16, 12 *16, txt.Get("DEX"), 0, -1);
          txtRight(5, 25 *16, 11 *16, txtInt(unit[iStatWindow].iDEX), 0, -1);
        txtOut(2, 29 *16, 12 *16, txt.Get("CON"), 0, -1);
          txtRight(5, 36 *16, 11 *16, txtInt(unit[iStatWindow].iCON), 0, -1);
        txtOut(2, 18 *16, 14 *16, txt.Get("RES"), 0, -1);
          txtRight(5, 25 *16, 13 *16, txtInt(unit[iStatWindow].iRES), 0, -1);
        txtOut(2, 29 *16, 14 *16, txt.Get("SPD"), 0, -1);
          txtRight(5, 36 *16, 13 *16, txtInt(unit[iStatWindow].iSPD), 0, -1);          
        txtOut(2, 18 *16, 16 *16, txt.Get("AGL"), 0, -1);
          txtRight(5, 25 *16, 15 *16, txtInt(unit[iStatWindow].iAGL), 0, -1);
        txtOut(2, 29 *16, 16 *16, txt.Get("LUK"), 0, -1);
          txtRight(5, 36 *16, 15 *16, txtInt(unit[iStatWindow].iLUK), 0, -1);          
        txtOut(2, 18 *16, 18 *16, txt.Get("BLD"), 0, -1);
          txtRight(5, 25 *16, 17 *16, txtInt(unit[iStatWindow].iBLD), 0, -1);
        txtOut(2, 29 *16, 18 *16, txt.Get("MOV"), 0, -1);
          txtRight(5, 36 *16, 17 *16, txtInt(unit[iStatWindow].iMOV), 0, -1);                    

        txtOut(2, 18 *16, 24 *16, txt.Get("might"), 0, -1);
          txtRight(5, 25 *16, 23 *16, txtInt(unit[iStatWindow].iSTR), 0, -1);
        txtOut(2, 29 *16, 24 *16, txt.Get("hitstat"), 0, -1);
          txtRight(5, 36 *16, 23 *16, txtInt(unitHit(iStatWindow)), 0, -1);
        txtOut(2, 18 *16, 26 *16, txt.Get("avoid"), 0, -1);
          txtRight(5, 25 *16, 25 *16, txtInt(unitAvoid(iStatWindow)), 0, -1);
        txtOut(2, 29 *16, 26 *16, txt.Get("crit"), 0, -1);
          txtRight(5, 36 *16, 25 *16, txtInt(0), 0, -1);          
          
        if(mouseClick(1))
        {
            // NULL
        };
        if(mouseClick(2))
        {
            iStatWindow = -1;
        };
    };
    
    displayAll();
        
    return 0; // Done
};        

int CMainLoop::FindMouse_ (void)
{
	// Finds which tile the mouse is hovering over and
	// updates the variables accordingly.  This is done
	// by simply diving the mouse coordinates by the
	// size of an individual tile.

	iX = mouse_x / giTileX;
	iY = mouse_y / giTileY;
	iXPos = iX * giTileX;
	iYPos = iY * giTileY;
    giMTileX = iX + iOffsetX;
    giMTileY = iY + iOffsetY;

	return 0; // Success
};

int CMainLoop::MoveMap_ (int iDirection)
{
	// Moves the map in a given direction.
	
	static int iWaiterX;
	static int iWaiterY;
	
	if(iDirection == dRIGHT && iWaiterX > 0 || iDirection == dLEFT && iWaiterX > 0)
		iWaiterX--;
	if(iDirection == dUP && iWaiterY > 0 || iDirection == dDOWN && iWaiterY > 0)
		iWaiterY--;
	
	// Set up the scrolling
	
	if(iDirection == dRIGHT && iOffsetXX == 0 && iWaiterX == 0)
	{
        iOffsetXX = -1 * (giTileX / iScrollSpeed);
		iWaiterX = giTileX / (-1 * iOffsetXX);		
	};

	if(iDirection == dLEFT && iOffsetXX == 0 && iWaiterX == 0)
	{
		iOffsetXX = giTileX / iScrollSpeed;
		iWaiterX = giTileX / iOffsetXX;
	};	

	if(iDirection == dDOWN && iOffsetYY == 0 && iWaiterY == 0)
	{
		iOffsetYY = -1 * (giTileY / iScrollSpeed);
		iWaiterY = giTileY / (-1 * iOffsetYY);
	};	

	if(iDirection == dUP && iOffsetYY == 0 && iWaiterY == 0)
	{
		iOffsetYY = giTileY / iScrollSpeed;
		iWaiterY = giTileY / iOffsetYY;
	};
	
	return 0; // Success
};

int CMainLoop::ScrollMap_ (void)
{
	// Handles the actual pixel scrolling set up by MoveMap_
	
	if(iOffsetXX > 0)
		iOffsetXX += giTileX / iScrollSpeed;
	if(iOffsetXX < 0)
		iOffsetXX -= giTileX / iScrollSpeed;
	if(iOffsetYY > 0)
		iOffsetYY += giTileY / iScrollSpeed;
	if(iOffsetYY < 0)
		iOffsetYY -= giTileY / iScrollSpeed;
	
	if(iOffsetXX >= giTileX)
	{
		iOffsetX --;
		iOffsetXX = 0;
	};
	if(iOffsetXX <= -1 * giTileX)
	{
		iOffsetX ++;
		iOffsetXX = 0;
	};
	if(iOffsetYY >= giTileY)
	{
		iOffsetY --;
		iOffsetYY = 0;
	};
	if(iOffsetYY <= -1 * giTileY)
	{
		iOffsetY ++;
		iOffsetYY = 0;
	};
	
	return 0; // Success
};

int CMainLoop::SetUnit_ (int iUnit, int x, int y)
{
    int iClass = map.iGeneric[x][y];
    int iSetFaction = map.iFaction[x][y];
    
    // Set General
    
    unit[iUnit].tName = faction[iSetFaction].tName + " " + rank[iClass].tName;
    unit[iUnit].bActive = true;
    unit[iUnit].mImage = create_bitmap(rank[iClass].mUnit->w, rank[iClass].mUnit->h);
    unit[iUnit].iX = x * giTileX;
    unit[iUnit].iY = y * giTileY;
    unit[iUnit].iLocX = x;
    unit[iUnit].iLocY = y;
    unit[iUnit].iFaction = iSetFaction;
    unit[iUnit].iClass = iClass;
    
    // Set Level and EXP Data
    
    unit[iUnit].iLev = 1;
    unit[iUnit].iNext = rank[iClass].iNext;
    
    // Set Animation
    
    unit[iUnit].iSpeed = rank[iClass].iSpeed * rank[iClass].iSpeed;
    unit[iUnit].bMoving = false;
    
    // Set Stats
    
    unit[iUnit].iMaxHP = rank[iClass].iBHP;
    unit[iUnit].iHP = rank[iClass].iBHP;
    unit[iUnit].iSTR = rank[iClass].iBSTR;
    unit[iUnit].iDEX = rank[iClass].iBDEX;
    unit[iUnit].iMAG = rank[iClass].iBMAG;
    unit[iUnit].iCON = rank[iClass].iBCON;
    unit[iUnit].iRES = rank[iClass].iBRES;
    unit[iUnit].iSPD = rank[iClass].iBSPD;
    unit[iUnit].iAGL = rank[iClass].iBAGL;
    unit[iUnit].iLUK = rank[iClass].iBLUK;
    unit[iUnit].iBLD = rank[iClass].iBBLD;
    unit[iUnit].iMOV = rank[iClass].iBMOV;
    unit[iUnit].iMoves = rank[iClass].iBMOV;
    
    // Set Attack
    
    unit[iUnit].iNear = rank[iClass].iNear;
    unit[iUnit].iRange = rank[iClass].iRange;
    
    // Set AI
    
    unit[iUnit].bBeenAttacked = false;
    unit[iUnit].vPath.clear();
    
    // Set Faction
    
    if(!faction[iSetFaction].bActive)
    {
        faction[iSetFaction].bActive = true;
        giTeams++;
    };
    faction[iSetFaction].iUnits++;
    
    blit(rank[iClass].mUnit, unit[iUnit].mImage, 0, 0, 0, 0, rank[iClass].mUnit->w, rank[iClass].mUnit->h);
    colorSwap(unit[iUnit].mImage, 0, iSetFaction + 1);
    map.iGeneric[x][y] = 0;
    
    return 0; // Done
};                

int playMap (void)
{
    // Calls up the main loop class, then returns the value of the main loop.
    
    int iWinner;
    
    loop.SetupMap();
    iWinner = loop.Main();
      
    return iWinner; // Done
};
