#include "stdafx.h"
#include "header.h"

int parStrings (CText &txtObj, string tFileName)
{
	// In order for multilanguage support to work correctly, all the
	// text needs to be stored externally. This function takes that
	// data and transfers it to something the engine can use.

	FILE * pFile;					// A pointer to the file itself.
	char cCommand;					// A single character from the file.
    string tFileLocation;           // Exact place the file is located.
	string tName;					// What the text object will be called.
	string tText;					// A group of letters that we can pass on to text string objects.

	// Open the file and check for errors.
	
	// TODO: Major rewrite for this section.  'Cause MinGW sucks.

	tFileLocation = sys_tPath + sys_tTextPath + sys_tLanguage + "/" + tFileName + ".txt";
	pFile = fopen(tFileLocation.c_str(), "rt");

	// We check in the current campaign or rule set folder first, and if the file
    // we're looking for is not there, then we look in the default system folder.

    if(!exists(tFileLocation.c_str()))  
    {        
        tFileLocation = sys_tSysPath + sys_tTextPath + sys_tLanguage + "/" + tFileName + ".txt";
        pFile = fopen(tFileLocation.c_str(), "rt");    
    
        if(!exists(tFileLocation.c_str()))
        {
            // Right now, if a file is missing, we boot the user.  In the future, a
            // work around will likely be sought.
            
            allegro_init();
            tFileLocation = "Cannot find the " + tFileLocation + " file.  Check and make sure that it is present.";
            allegro_message(tFileLocation.c_str());
            exit(-1);
        }; // end if
    }; // end if

	// Now we clear the object to get it ready.

	txtObj.Clear();

	// And now to begin parsing.

	while(!feof(pFile))
	{
		// Get text handle and assign it, along with the actual string.

		cCommand = (char)fgetc(pFile);

		if(cCommand == '[')
        {
			// Get the handle.

			tName = ""; // Reset the handle

			cCommand = (char)fgetc(pFile);

			while(cCommand != ']')
			{
				tName += cCommand;
				cCommand = (char)fgetc(pFile);
			};

			// Advance to, and then Get the text.

			cCommand = (char)fgetc(pFile);

			while(cCommand == ' ')
				cCommand = (char)fgetc(pFile);

			tText = ""; // Reset the String

			while(cCommand != '^')
			{
				if (cCommand == '\n') // Disregard line breaks.
					cCommand = ' ';

				tText += cCommand;

				cCommand = (char)fgetc(pFile);
			};

			// Now, put the text in place with the given handle.

			txtObj.Put(tName, tText);
		};

		// Ignore comment lines marked with #

		if(cCommand == '#')
        {
			while(cCommand != '\n')
			{
				cCommand = (char)fgetc(pFile);
			};
		};
	};

	// Okay, we're done here; close the file.

	fclose(pFile);

	return 0; // Success
};
