#include "stdafx.h"
#include "header.h"

int CTxtBox::Display (void)
{
    // Displays all the active text boxes.
    
    for (int i = 0; i < giMaxFields; i++)
    {
        if(bActive[i])
        {
            if(i == iActiveField)
            {
                txtOut(iFont[i], iX[i], iY[i], *tText[i] + "|", iW[i], -1);
                rect(mBuffer, iX[i] - 2, iY[i] - 2, iX[i] + iW[i] + 1, iY[i] + iH[i], makecol(255, 255, 0));
            }
            else
            {
                txtOut(iFont[i], iX[i], iY[i], *tText[i], iW[i], -1);
                rect(mBuffer, iX[i] - 2, iY[i] - 2, iX[i] + iW[i] + 1, iY[i] + iH[i], makecol(255, 255, 255));
            };
        }; // end if
    }; // end for
    
    return 0; // Success
};

int CTxtBox::Kill (int iID)
{
    // "Turns off" a text box when the GUI is done with it.
    
    bActive[iID] = false;
    //tText[iID] = NULL;
    
    return 0; // Success
};

int CTxtBox::KillAll (void)
{
    // Destroys all text boxes currently in use.
    
    iActiveField = -1;
    
    for (int i = 0; i < giMaxFields; i++)
        Kill(i);
    
    return 0; // Success
};

int CTxtBox::New (int iID, int iSetFont, string &tContent, int iSetX, int iSetY, int iSetW, int iSetH, int iMaxLetters)
{
    // Creates a new text box.
      
    if (iID < 0 || iID > giMaxFields)
        return -1; // Failure: invalid ID number
    
    bActive[iID] = true;
    
    iFont[iID] = iSetFont;
    iX[iID] = iSetX * giGrid;
    iY[iID] = iSetY * giGrid;
    iW[iID] = iSetW * giGrid;
    iH[iID] = iSetH * giGrid;    
    iMax[iID] = iMaxLetters;
    
    tText[iID] = &tContent;
    
    return 0; // Success
};

int CTxtBox::Update (void)
{
    // Checks all the text boxes, updating them as neccissary, adding
    // text that the user has entered, etc.
    
    // See if the user has clicked on a text box.

    for(int i = 0; i < giMaxFields; i++)
    {
        if(mouse_x >= iX[i] &&	mouse_x <= iX[i] + iW[i] &&
            mouse_y >= iY[i] &&	mouse_y <= iY[i] + iH[i] &&
            bActive[i] == true)
        {
            if(mouse_b & 1)
                iActiveField = i;
        }; // end if
    }; // end for
    
    // Add/Remove Characters at the user's request.
    
    if(keypressed())
    {
        int iInput = readkey();
        char cASCII = iInput & 0xff;
        char cScanCode = iInput >> 8;
        
        if(iActiveField >= 0)
        {
            if(bActive[iActiveField])
            {
                if(cASCII >= 32 && cASCII <= 126)
                {
                    if(txtHeight(iFont[iActiveField], *tText[iActiveField] + cASCII, iW[iActiveField], -1) <= iH[iActiveField])
                    {
                        if(tText[iActiveField]->length() < iMax[iActiveField] && iMax[iActiveField] > 0 || iMax[iActiveField] == -1)
                            *tText[iActiveField] += cASCII;
                    };
                }; // end if
                
                if(cScanCode == KEY_BACKSPACE && tText[iActiveField]->length() > 0)
                {
                    tText[iActiveField]->erase(tText[iActiveField]->length() - 1, 1);
                }; //end if
    
                if(cScanCode == KEY_ESC || cScanCode == KEY_ENTER)
                {
                    iActiveField = -1;
                }; //end if
            }; // end if
        }; // end if
    }; // end if
    
    return 0; // Success    
};
