#include "stdafx.h"
#include "header.h"

const int iTotalButtons = 100;

bool bBlink = false;
int iBlinker = 0;

typedef struct stButton
{
	BITMAP *mDown;
	BITMAP *mHover;
	BITMAP *mUp;
	bool bActive;
	bool bClicked;
	bool bDown;
	bool bHover;
	int iHeight;
	int iWidth;
	int iOffsetX;
	int iOffsetY;
    int iOpacity;
	int iX;
	int iY;
} makeButton;

makeButton sButton[iTotalButtons];


void butBlink(bool bSet)
{
	// Tell the program whether or not to make the buttons "blink"
	// when hovered over;

	bBlink = bSet;
	iBlinker = 0;
};


int  butCheck(int iToCheck)
{
	// Returns whether or not the button has been pressed.
	
	if(sButton[iToCheck].bActive == true && sButton[iToCheck].bClicked == true)
    {
        sButton[iToCheck].bClicked = false;
        return true;
    }
	else
		return false;
};



void butDisplay()
{
	// Displays all the active button to the buffer.

	if(bBlink == true)
	{
		iBlinker++;
		if(iBlinker > 5)
			iBlinker = 0;
	};
      
	for(int i = 0; i < iTotalButtons; i++)
	{
		if(sButton[i].bActive == true)
		{
            set_trans_blender(0, 0, 0, sButton[i].iOpacity); // Sets the trans_blender.
            drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);

			if(sButton[i].bHover == true && iBlinker < 3)
			{
				draw_trans_sprite(mBuffer, sButton[i].mHover, sButton[i].iX, sButton[i].iY);
			}
			else if(sButton[i].bDown == true && iBlinker < 3)
			{
				draw_trans_sprite(mBuffer, sButton[i].mDown, sButton[i].iX, sButton[i].iY);
			}
			else
			{
				draw_trans_sprite(mBuffer, sButton[i].mUp, sButton[i].iX, sButton[i].iY);
			};
		};
	}; // end for
    
    solid_mode();
    set_trans_blender(0, 0, 0, 127); // Return the trans_blender back to default.
};



int  butKill(int iToKill)
{
	// Deletes a single button, clearing it and its
	// bitmaps from memory.

	sButton[iToKill].bActive = false;
	destroy_bitmap(sButton[iToKill].mUp);
	destroy_bitmap(sButton[iToKill].mDown);
	destroy_bitmap(sButton[iToKill].mHover);
	sButton[iToKill].mUp = NULL;
	sButton[iToKill].mDown = NULL;
	sButton[iToKill].mHover = NULL;

	return 0;
};



int  butKillAll()
{
	// Deletes all the buttons, clearing their bitmaps
	// from memory, and setting their status flags to
	// inactive.

	for(int i = 0; i < iTotalButtons; i++)
	{
		butKill(i);
	};

	return 0;
};



int  butNew(int iToSet, int iSetX, int iSetY, string tUp, string tDown, string tHover, int iOffset)
{
	// Creates a new button.

	string tTemp;
	
    if(sButton[iToSet].bActive == true)
        return -1; // This button already exists
    
	sButton[iToSet].bActive = true;
	sButton[iToSet].iX = iSetX * giGrid;
	sButton[iToSet].iY = iSetY * giGrid;
	sButton[iToSet].bClicked = false;
	sButton[iToSet].bDown = false;
	sButton[iToSet].bHover = false;
    sButton[iToSet].iOpacity = 255;

    sButton[iToSet].mUp = gfxLoad(tUp + "_u", "but");
	sButton[iToSet].mDown = gfxLoad(tUp + "_d", "but");
	sButton[iToSet].mHover = gfxLoad(tUp + "_h", "but");
    
    //colorAlpha(sButton[iToSet].mUp);
    //colorAlpha(sButton[iToSet].mDown);
    //colorAlpha(sButton[iToSet].mHover);
	
	sButton[iToSet].iHeight = sButton[iToSet].mUp->h;
	sButton[iToSet].iWidth = sButton[iToSet].mUp->w;
	sButton[iToSet].iOffsetX = iOffset;
	sButton[iToSet].iOffsetY = iOffset;

	//colorAlpha(sButton[iToSet].mUp);
	//colorAlpha(sButton[iToSet].mDown);
	//colorAlpha(sButton[iToSet].mHover);

	return 0;
};



int butOpacity(int iToSet, int iOpac)
{
    // Sets the opacity of a button. In the future, this will
    // likely be replaced by full translucency support using
    // 24/32-bit PNG files.
    
    if(iOpac < 0 || iOpac > 255)
        return -1; //Failure
    
    sButton[iToSet].iOpacity = iOpac;
    
    return 0; // Success
};
    



int butReset(int iToSet)
{
	// Sets a button back to its unclicked state.

	sButton[iToSet].bClicked = false;

	return 0;
};



void butUpdate()
{
	// Checks on the status of all the buttons currently
	// active, and makes ajustments as neccisary.

	bool bAlreadySetOne = false;	// Only one button may be selected at a time.  If one
									// is set, then all the other ones are ignored, and
									// just set to down.

	for(int i = 0; i < iTotalButtons; i++)
	{
		if(sButton[i].bActive == true)
		{
			if(mouse_x >= sButton[i].iX - sButton[i].iOffsetX &&
				mouse_x <= sButton[i].iX + sButton[i].iWidth + sButton[i].iOffsetX &&
				mouse_y >= sButton[i].iY - sButton[i].iOffsetY &&
				mouse_y <= sButton[i].iY + sButton[i].iHeight + sButton[i].iOffsetY &&
				bAlreadySetOne == false)
			{
				if(mouse_b & 1)
				{
					sButton[i].bDown = true;
					sButton[i].bHover = false;
				}
				else
				{
					if(sButton[i].bDown == true)
						sButton[i].bClicked = true;
					sButton[i].bDown = false;
					sButton[i].bHover = true;
				}

				bAlreadySetOne = true;
			}
			else
			{
				sButton[i].bDown = false;
				sButton[i].bHover = false;
			};
		};
	};
};
