#include "stdafx.h"
#include "header.h"

string saveDialog (string tFolder, string tExtension, string tFile, string tMessage, int iOption)
{
    // Gets input from the user on where they want to save a
    // file. This information is then relayed back to whatever
    // function it was called by.
    //
    // string tFolder
    //    The folder to save to.
    // string tExtension
    //    The file extension.
    // string tFile
    //    The current name of the file to be saved, if
    //    there is one.
    // string tMessage
    //    What to name the save dialog box.
    // int iOption
    //    (CURRENTLY UNUSED)
    
    // Declare any needed variables here.
    
    BITMAP *mBG = create_bitmap(SCREEN_W, SCREEN_H);        // Static Background
    bool bQuit = false;                                     // Boolean to end main loop
    CFileList flFiles;                                      // The file list
    int iTop = 0;                                           // Where to start displaying files from,
                                                            // used for scrolling.
    
    // Get the file list.
    
    flFiles.Get("*" + tExtension, tFolder, 0);
    
    // Grab and darken the background, so we have something behind
    // the dialog box.
    
    screenGet(mBG);
    
    drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
	rectfill(mBG, 0, 0, SCREEN_W, SCREEN_H, makecol(0, 0, 0));
	solid_mode();
    
    // First, we'll set up the window.
    
    guiEZ(8);
    txtNew(0, 25, 15, tMessage, 2, -1, alignLEFT, 0);    
    guiEZ(16);
    win.New(1, "window", 11, 8, 18, 14);
    win.New(2, "window", 12, 7, (txtCheckWordLength(2, tMessage) / 16) + 2, 2);
    field.New(1, 2, tFile, 12, 10, 16, 1, 16);
    butNew(1, 12, 20, "sml_01", "", "", 0);
    butNew(2, 21, 20, "sml_01", "", "", 0);
    
    if(flFiles.iNumber > 7)
    {
        butNew(3, 27, 12, "scrollup", "", "", 0);
        butNew(4, 27, 17, "scrolldown", "", "", 0);
    };
    
    for(int i = 0; i < 7 && i < flFiles.iNumber; i++)
    {
        butNew(i + 10, 12, i + 12, "file", "", "", 0);
        txtNew(i + 10, 12, i + 12, "", 2, -1, alignLEFT, 0);
        butOpacity(i + 10, 128);
    };
  
    guiEZ(1);
	txtNew(1, (12*16) + 56, (20*16) + 4, gTxt.Get("save"), 2, -1, alignCENTER, 0);
    txtNew(2, (21*16) + 56, (20*16) + 4, gTxt.Get("cancel"), 2, -1, alignCENTER, 0);
    
    while(!bQuit)
    {
        for(int i = 0; i < flFiles.iNumber && i < 7; i++)
            txtReset(i + 10, " " + flFiles.tName[i + iTop]);
        draw_sprite(mBuffer, mBG, 0, 0);
        displayAll();
        
        if(butCheck(1))
        {
            bQuit = true;
        };
        if(butCheck(2))
        {
            bQuit = true;
            tFile = "";
        };
        
        // Scrolling
        
        if(butCheck(3) && iTop > 0)
            iTop--;
        if(butCheck(4) && iTop < flFiles.iNumber - 7)
            iTop++;
        
        for(int i = 0; i < flFiles.iNumber && i < 7; i++)
        {
            if(butCheck(i + 10))
            {
                tFile = flFiles.tName[i + iTop];
            };
        };
    };
    
    guiKillAll();
    flFiles.Kill();
    destroy_bitmap(mBG);
    
    // Append the extension to the end if the user didn't add it manually.
    
    if(tFile != "")
    {
        if(tFile.length() >= tExtension.length())
        {
            if(tFile.substr(tFile.length() - tExtension.length(), tExtension.length()) != tExtension)
                tFile = tFile + tExtension;
        }
        else
            tFile = tFile + tExtension;
    };
    
    return tFile; // Success
};


string loadDialog (string tFolder, string tExtension, string tFile, string tMessage, int iOption)
{
    // Gets input from the user on what file they want to
    // load. This information is then relayed back to whatever
    // function it was called by.
    //
    // string tFolder
    //    The folder to save to.
    // string tExtension
    //    The file extension.
    // string tFile
    //    The current name of the file to be saved, if
    //    there is one.
    // string tMessage
    //    What to name the save dialog box.
    // int iOption
    //    (CURRENTLY UNUSED)
    
    // Declare any needed variables here.
    
    BITMAP *mBG = create_bitmap(SCREEN_W, SCREEN_H);        // Static Background
    bool bQuit = false;                                     // Boolean to end main loop
    CFileList flFiles;                                      // The file list
    int iTop = 0;                                           // Where to start displaying files from,
                                                            // used for scrolling.
    
    // Get the file list.
    
    flFiles.Get("*" + tExtension, tFolder, 0);
    
    // Grab and darken the background, so we have something behind
    // the dialog box.
    
    screenGet(mBG);
    
    drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
	rectfill(mBG, 0, 0, SCREEN_W, SCREEN_H, makecol(0, 0, 0));
	solid_mode();
    
    // First, we'll set up the window.
    
    guiEZ(8);
    txtNew(0, 25, 15, tMessage, 2, -1, alignLEFT, 0);    
    guiEZ(16);
    win.New(1, "window", 11, 8, 18, 14);
    win.New(2, "window", 12, 7, (txtCheckWordLength(2, tMessage) / 16) + 2, 2);
    butNew(2, 21, 20, "sml_01", "", "", 0);
    
    if(flFiles.iNumber > 9)
    {
        butNew(3, 27, 10, "scrollup", "", "", 0);
        butNew(4, 27, 17, "scrolldown", "", "", 0);
    };
    
    for(int i = 0; i < 9 && i < flFiles.iNumber; i++)
    {
        butNew(i + 10, 12, i + 10, "file", "", "", 0);
        txtNew(i + 10, 12, i + 10, "", 2, -1, alignLEFT, 0);
        butOpacity(i + 10, 128);
    };
    
    guiEZ(1);
    txtNew(2, (21*16) + 56, (20*16) + 4, gTxt.Get("cancel"), 2, -1, alignCENTER, 0);
    
    while(!bQuit)
    {
        for(int i = 0; i < flFiles.iNumber && i < 9; i++)
            txtReset(i + 10, " " + flFiles.tName[i + iTop]);
        draw_sprite(mBuffer, mBG, 0, 0);
        displayAll();
        
        if(butCheck(2))
        {
            bQuit = true;
            tFile = "";
        };
        if(butCheck(3) && iTop > 0)
            iTop--;
        if(butCheck(4) && iTop < flFiles.iNumber - 9)
            iTop++;        
        for(int i = 0; i < flFiles.iNumber && i < 9; i++)
        {
            if(butCheck(i + 10))
            {
                bQuit = true;
                tFile = flFiles.tName[i + iTop];
            };
        };
    };
    
    guiKillAll();
    flFiles.Kill();
    destroy_bitmap(mBG);
    
    return tFile; // Success
};
