// -- CLASS DATA CLASS --
// (Ha, ha, funny.)
//
// This is the class structure that stores all the data for
// all the classes in a given game.
//
// IMPORTANT: If you add any variables to the data structure, make sure
// you add them to the Clear routines.

class CClass
{
public:
    
    // Functions
    
    int Purge (void);               // Clears all the data for this class.
    
    // General Data
    
    string tName;                   // The name of this class.
    BITMAP *mUnit;                  // The bitmap for this class's graphics.
    bool bProperties[9];            // Whether or not this class has given properties.
    int iType;                      // What type of movement this class uses.
    int iMaxLEV;                    // The highest level this unit can achieve.
    int iNext;                      // The base "next level" value for this class.
    int iRampUp;                    // The "ramp-up" value for this class.
    
    // Animation Data
    
    bool bNoAnim;                   // Whether or not to disable all this unit's animation.
    int iSpeed;                     // How quickly the unit moves.
    int iFrames[10];                // How many frames a unit has for a given animation.
    
    // Base Stats
    
    int iBHP;                       // Base hit points.
    int iBMOV;                      // Base movement points.
    int iBSTR;                      // The class's base strength.
    int iBDEX;                      // The class's base dexterity.
    int iBMAG;                      // The class's base magic ability.
    int iBCON;                      // The class's base constitution.    
    int iBRES;                      // The class's base resistance.
    int iBSPD;                      // The class's base speed.
    int iBAGL;                      // The class's base agility.
    int iBLUK;                      // The class's base luck.
    int iBBLD;                      // The class's base build.
    
    // Growth Rates
    
    int iGHP;                       // Hit point growth rate.
    int iGMOV;                      // Movement point growth rate.
    int iGSTR;                      // The class's strength growth rate.
    int iGCON;                      // The class's constitution growth rate.    
    
    // Attack
    
    int iNear;                      // How far away the closest tile this class can attack is.
    int iRange;                     // How far from the closest tile this class's range is.    
};
