#include "stdafx.h"
#include "header.h"

int CClass::Purge (void)
{
    // Clears all the data for this class so that we can insert
    // new class data here. Some of the data is set to something
    // besides zero in case the user forgot to set it so that
    // the engine doesn't choke.

    tName = "";
    
    // Level Data
    
    iMaxLEV = 5;
    iNext = 25;
    iRampUp = 10;
    
    // Attributes, Affinities, and Types
    
    iType = 0;
    
    for (int i=0; i < 9; i++)
        bProperties[i] = false;
    
    // Animation
    
    for (int i=0; i < 9; i++)
        iFrames[i] = 4;
    
    bNoAnim = false;
    iSpeed = 2;

    // Basic Attack Data
    
    iNear = 0;
    iRange = 0;
    
    // Base Stats
    
    iBHP = 10;
    iBSTR = 0;    
    iBCON = 0;
    iBDEX = 0;
    iBMAG = 0;
    iBRES = 0;
    iBAGL = 0;
    iBSPD = 0;
    iBLUK = 0;
    iBBLD = 0;
    iBMOV = 5;
    
    return 0; // Done
};

int classLoad(string tFile)
{
	// A routine for parsing class data from a file.
	
	FILE * pFile;					// A pointer to the file.
	string tInput;					// Input from the parser.
	
	// First, we need to make sure the file is actually there. In the future,
	// if it's missing, we fall back on the default class data. For now, we
	// just boot the player. :3
	
	if(!exists(tFile.c_str()))
	{
		allegro_message("The class data that the engine needs appears to be missing.");
		exit(-1);
	}; //end if
	
	// Okay, let's start by clearing out essential old class data. Everything else
	// we can pretty much clear as we go.
	
	giClassSlotsUsed = 0;
	
	// We can now open the file...
	
	pFile = fopen(tFile.c_str(), "rt");
	
	// ...And begin parsing the data. We keep going until we hit the end
	// of the rainbow (or the file, whichever comes first).
	
	while(!feof(pFile))
	{
		// First get the next command.
		
		tInput = parGet(pFile, ' ', '\n', ',');
		
		// CLASS
		
		if(tInput == "CLASS")
		{
			int iSlot = 0;				// The slot number this class will take.
			
            // Increase the total number of classes by one.
            
            giClassSlotsUsed++;
            
			// Get the class's slot number
			
			tInput = parGet(pFile, ' ', '\n', ',');
			iSlot = atoi(tInput.c_str());
            
            // Reset any vital data.
            
            rank[iSlot].Purge();
			
			// Then the class's name.
            
            tInput = parGet(pFile, ' ', '\n', ',');
            rank[iSlot].tName = tInput;
            
            // Now start processing data
            
            tInput = parGet(pFile, ' ', '\n', ',');
            
            while(tInput != "}" && !feof(pFile))
            {                
                // Spite Data
                
                if(tInput == "sprite")
                {
                    // Load the requested sprite.
                    
                    tInput = parGet(pFile, ' ', '\n', ',');
                    rank[iSlot].mUnit = gfxLoad(tInput, "units");
                    colorReplace(rank[iSlot].mUnit, makecol(255, 128, 255), makecol(255, 0, 255));
                } // end if
                
                // Animation Data

                if(tInput == "ANIMATION")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    
                    while(tInput != "}")
                    {
                        if(tInput == "disable")
                        {
                            rank[iSlot].bNoAnim = true;
                        };
                        
                        tInput = parGet(pFile, ' ', '\n', ',');
                    };                    
                } // end if  
                
                // Basic Attack Data

                if(tInput == "ATTACK")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    
                    while(tInput != "}")
                    {
                        if(tInput == "range")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iNear = atoi(tInput.c_str());
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iRange = atoi(tInput.c_str()) - rank[iSlot].iNear;
                        };
                        
                        tInput = parGet(pFile, ' ', '\n', ',');
                    };                    
                } // end if
                
                // Base Stats Data
                
                if(tInput == "BASE_STATS")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    
                    while(tInput != "}")
                    {
                        if(tInput == "hp")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iBHP = atoi(tInput.c_str());
                        };
                        
                        if(tInput == "str")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iBSTR = atoi(tInput.c_str());
                        };

                        if(tInput == "con")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iBCON = atoi(tInput.c_str());
                        };

                        if(tInput == "agl")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iBAGL = atoi(tInput.c_str());
                        };

                        if(tInput == "luk")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iBLUK = atoi(tInput.c_str());
                        };                        

                        if(tInput == "mov")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            rank[iSlot].iBMOV = atoi(tInput.c_str());
                        };
                        
                        tInput = parGet(pFile, ' ', '\n', ',');
                    }; // end while
                }; // end if
                
                // Get the next command, and then loop back around.
                
                tInput = parGet(pFile, ' ', '\n', ',');
            }; // end while
		};// end if CLASS

		// If we ever hit a # comment line, then we want to skip the
		// entire thing. We'll have to handle that locally, so we
		// create a new char variable to deal with it.
		
		if(tInput == "#")
		{
			char cSingle;
            
            cSingle = (char)fgetc(pFile);
			
			while(cSingle != '\n')
			{
				cSingle = (char)fgetc(pFile);
			}; // end while
		}; // end if COMMENTS
	}; // end while
	
	return 0; // Success
};

int classSetup (void)
{
    // A temporary routine used to hardcode the simple
    // rule set classes and other related data.
    
    // TODO: Once the editor function are online, this
    // routine can be phased out.
    
    parStrings(txt, "def_rules");
    
    // Classes
    
    /*sys_tPath = "shared/rulesets/dma_01/";
    colorGet();
	classLoad("shared/rulesets/dma_01/data/class.data");
    terrainLoad("shared/rulesets/dma_01/data/terrain.data");
    factionLoad("shared/rulesets/dma_01/data/faction.data");*/
	
    /*giClassSlotsUsed = 3;
    rank[1].tName = txt.Get("infantry");
    rank[1].mUnit = gfxLoad("infantry_01", "units");
    rank[1].iBMOV = 5;
    rank[1].iBHP = 15;
    rank[1].iBSTR = 16;
    rank[1].iBCON = 4;
    rank[1].iBAGL = 5;
    rank[1].iBLUK = 1;
    rank[1].iNear = 1;
    rank[1].iRange = 0;
    rank[1].iSpeed = 2;
    colorReplace(rank[1].mUnit, makecol(255, 128, 255), makecol(255, 0, 255));
    rank[2].tName = txt.Get("archer");
    rank[2].mUnit = gfxLoad("archer_01", "units");
    rank[2].iBMOV = 6;
    rank[2].iBHP = 12;
    rank[2].iBSTR = 13;
    rank[2].iBCON = 3;
    rank[2].iBAGL = 12;
    rank[2].iBLUK = 3;
    rank[2].iNear = 2;
    rank[2].iRange = 1;
    rank[2].iSpeed = 2;
    colorReplace(rank[2].mUnit, makecol(255, 128, 255), makecol(255, 0, 255));
    rank[3].tName = txt.Get("cavalry");
    rank[3].mUnit = gfxLoad("cavalry_01", "units");
    rank[3].iBMOV = 9;
    rank[3].iBHP = 9;
    rank[3].iBSTR = 24;
    rank[3].iBCON = 2;
    rank[3].iBAGL = 10;
    rank[3].iBLUK = 7;
    rank[3].iNear = 1;
    rank[3].iRange = 0;  
    rank[3].iSpeed = 3;
    colorReplace(rank[3].mUnit, makecol(255, 128, 255), makecol(255, 0, 255));
    rank[4].tName = txt.Get("chickenman");
    rank[4].mUnit = gfxLoad("chickenman_01", "units");
    rank[4].iBMOV = 15;
    rank[4].iBHP = 5;
    rank[4].iBSTR = 1;
    rank[4].iBCON = 1;
    rank[4].iSpeed = 4;
    colorReplace(rank[4].mUnit, makecol(255, 128, 255), makecol(255, 0, 255));*/
    
    // Factions
    
    /*giTotalFactions = 6;
    
    faction[1].iColor = 2;
    faction[1].mIcon = gfxLoad("blue", "teams");
    faction[1].tName = txt.Get("blue");
    faction[2].iColor = 3;
    faction[2].mIcon = gfxLoad("red", "teams");
    faction[2].tName = txt.Get("red");
    faction[3].iColor = 4;
    faction[3].mIcon = gfxLoad("green", "teams");
    faction[3].tName = txt.Get("green");
    faction[4].iColor = 5;
    faction[4].mIcon = gfxLoad("yellow", "teams");
    faction[4].tName = txt.Get("yellow");
    faction[5].iColor = 6;
    faction[5].mIcon = gfxLoad("purple", "teams");
    faction[5].tName = txt.Get("purple");
    faction[6].iColor = 7;
    faction[6].mIcon = gfxLoad("orange", "teams");
    faction[6].tName = txt.Get("orange");*/
    
    // Terrain
    
    /*giTerrainSlotsUsed = 11;
    
    terrain[0].tName = "See-Through Tile";
    terrain[0].iCost[0] = -1;
    
    terrain[1].tName = "Grassland";
    terrain[1].iSmooth = 1;
    terrain[1].iCost[0] = 1;
    terrain[1].iDef = 1;
    terrain[1].iAvo = 0;
    
    terrain[2].tName = "Sand";
    terrain[2].iSmooth = 1;
    terrain[2].iCost[0] = 2;
    terrain[2].iDef = 0;
    terrain[2].iAvo = 0;
    
    terrain[3].tName = "Road";
    terrain[3].iSmooth = 1;
    terrain[3].iCost[0] = 1;
    terrain[3].iDef = 0;
    terrain[3].iAvo = 0;
    
    terrain[4].tName = "Forest";
    terrain[4].iBase = 1;
    terrain[4].iCost[0] = 2;
    terrain[4].iDef = 2;
    terrain[4].iAvo = 1;
    
    terrain[5].tName = "Water";
    terrain[5].iCost[0] = -1;
    terrain[5].iDef = 0;
    terrain[5].iAvo = 0;
    
    terrain[6].tName = "Mountain";
    terrain[6].iBase = 1;
    terrain[6].iCost[0] = 5;
    terrain[6].iDef = 4;
    terrain[6].iAvo = 3;
    
    terrain[7].tName = "Fortress";
    terrain[7].iBase = 1;
    terrain[7].iCost[0] = 1;
    terrain[7].iDef = 3;
    terrain[7].iHeal = 5;
    terrain[7].iAvo = 1;

    terrain[8].tName = "Bridge";
    terrain[8].iBase = 0;
    terrain[8].iSmooth = 2;
    terrain[8].iCost[0] = 1;
    terrain[8].iDef = 0;
    terrain[8].iAvo = 0;

    terrain[9].tName = "Foot Hills";
    terrain[9].iBase = 1;
    terrain[9].iSmooth = 0;
    terrain[9].iCost[0] = 4;
    terrain[9].iDef = 3;
    terrain[9].iAvo = 2;

    terrain[10].tName = "Village";
    terrain[10].iBase = 1;
    terrain[10].iSmooth = 0;
    terrain[10].iCost[0] = 1;
    terrain[10].iDef = 2; 
    terrain[10].iHeal = 3;
    terrain[10].iAvo = 1;
    
    terrain[11].tName = "River";
    terrain[11].iSmooth = 1;
    terrain[11].iCost[0] = 5;
    terrain[11].iDef = 0;
    terrain[11].iAvo = 0;
    
    giTerrainPres[0] = 7;
    giTerrainPres[1] = 10;
    giTerrainPres[2] = 9;    
    giTerrainPres[3] = 8;
    giTerrainPres[4] = 6;
    giTerrainPres[5] = 4;
    giTerrainPres[6] = 1;
    giTerrainPres[7] = 3;
    giTerrainPres[8] = 2;
    giTerrainPres[9] = 11;
    giTerrainPres[10] = 5;
    giTerrainPres[11] = 0;*/
    
    return 0; // Success
};
