#include "stdafx.h"
#include "header.h"

class CUsrLogin
{
public:
    int Main (void);
private:
    void Done_ (void);
    void Loop_ (void);
    void Setup_ (void);
    BITMAP *mBG;
    CFileList flUsers;
    string tNewLogin;
    string tNewName;
} login;

int CUsrLogin::Main (void)
{
    // The Main loop for the user login screen.
    
    // First, we need to find out how many user files are installed
    // on this setup, and who they are.
    
    // Second, we display the screen.
    
    Setup_();
    
    // Now we run the primary loop, waiting for user input.
    
    Loop_();
    
    // Finally, we log the user in, clear the screen and continue
    // on our way.
    
    Done_();
    
    return 0; // Success
};

void CUsrLogin::Done_ (void)
{
    // Clears everything that the login screen needed and
    // sets up any variables needed for the selected user.

    flUsers.Kill();
    destroy_bitmap(mBG);
    guiKillAll();
};

void CUsrLogin::Loop_ (void)
{    
    // The main loop that waits for user input.
    
    bool bQuit = false;
    
    while(bQuit == false) //&& !keyCheck(KEY_ESC))
    {
        blit(mBG, mBuffer, 0, 0, 0, 0, mBG->w, mBG->h);
        //txtOut(2, 400, 32, flUsers.tName[2], -1, -1); // For testing
        displayAll();
        
        if(butCheck(0))
        {
            sys_tUser = tNewLogin;
            tNewLogin = "users/" + tNewLogin;
            mkdir(tNewLogin.c_str());
            bQuit = true;
        };
        for(int i = 0; i < 7 && flUsers.iNumber >= i + 2; i++)
        {            
            if(butCheck(5 + i))
            {
                sys_tUser = flUsers.tName[2 + i];
                bQuit = true;
            };
        };
    };
};

void CUsrLogin::Setup_ (void)
{
    // Sets up the display of the login screen
  
    parStrings(txt, "login");
    flUsers.Get("*", sys_tUserPath, FA_DIREC);
    
    mBG = gfxLoad("title_01", "bg");
    
    guiEZ(8);
    win.New(0, "window", 4, ((272 - txtHeight(3, txt.Get("welcome"), 272, -1)) / 8) - 2, 32, ((txtHeight(3, txt.Get("welcome"), 272, -1)) / 8) + 3);
    guiEZ(16);
    win.New(1, "window", 2, 20, 16, 8);
    win.New(2, "window", 3, 19, 8, 2);
    
	guiEZ(8);
    butNew(0, 20, 51, "sml_01", "", "", 0);
	guiEZ(1);
    txtNew(0, 216, 413, txt.Get("create"), 2, -1, alignCENTER, 0);   
    guiEZ(16);
    
    // New User Window
    
    guiEZ(8);
    txtNew(2, 8, 39, txt.Get("new"), 2, -1, alignLEFT, 0);   
    txtNew(3, 7, 44, txt.Get("name"), 3, -1, alignLEFT, 0);
    guiEZ(16);
    field.New(1, 2, tNewLogin, 3, 23, 14, 1, 16);
    
    // Login Choices
    
    for(int i = 0; i < 7 && flUsers.iNumber >= i + 2; i++)
    {
        if(flUsers.iNumber > 2 + i)
        {
            guiEZ(8);
            image.New(5 + i, sys_tUserPath + flUsers.tName[i+2] + "/" + sys_tAvatarPath + "large", "root", 43, 3 + (i*8), 1);
            guiEZ(16);
            if(image.mImage[5 + i]->w != 48 || image.mImage[5 + i]->h != 48)
                image.Kill(5 + i);
            butNew(5 + i, 20, 1 + (i*4), "login", "", "", 0);
            butOpacity(5 + i, 128);
            txtNew(25 + i, 25, 2 + (i*4), flUsers.tName[i+2], 2, -1, alignLEFT, 0);
        };
    };
    
    // Welcome Text
    
    guiEZ(8);
    txtNew(1, 5, ((280 - txtHeight(3, txt.Get("welcome"), 272, -1)) / 8) - 2, txt.Get("welcome"), 3, 29, alignLEFT, 0);
    
    guiEZ(1);       // Return Snap to Normal
};

int usrLogin (void)
{
    // Calls up the user login screen.
    
    login.Main();
    
    return 0; // Success
};
