#include "stdafx.h"
#include "header.h"

// Title page and menu for SRPG Factory.  Not the title page or
// menu for individual projects.

class CTitlePage
{
public:
    int Page (void);
private:
    int PageKill_ (void);
    int PageSetup_ (void);
    BITMAP *mBG;
    BITMAP *mLogo;
} title;

int CTitlePage::Page (void)
{
	// The main title page and menu loop.
    
    PageSetup_();
    
    while(!butCheck(0) && !keyCheck(KEY_ESC))
    {
        blit(mBG, mBuffer, 0, 0, 0, 0, mBG->w, mBG->h);
        set_alpha_blender();
        draw_trans_sprite(mBuffer, mLogo, 0, 16);
        displayAll();
        
        if(butCheck(2))
        {
            string tLoadTo;
            PageKill_();
            tLoadTo = loadDialog(sys_tMPMapPath, ".map", "", "Load Map File...", 0);
            if(tLoadTo != "")
            {
                int iWinner;
                guiLoading();
                loadMap(sys_tMPMapPath + tLoadTo);
                map.LoadTiles("001");       // TODO: Once tile sets are enabled, this hard-coded
                                            // loading will no longer be needed.
                iWinner = playMap();
                if(iWinner != -1)
                    mpWin(iWinner);
            };            
            PageSetup_();
        };
        if(butCheck(4))
        {
            PageKill_();
            //editSelect();
            editMap();
            PageSetup_();
        };
        
        if(butCheck(6))
        {
            PageKill_();
            htmManual("index");
            PageSetup_();
        };            
        
        if(butCheck(21))
        {
            PageKill_();
            usrLogin();
            PageSetup_();
        };        
    };
    
    PageKill_();

	return 0;
};

int CTitlePage::PageKill_ (void)
{
    // Clears all the title screen's GUI objects and images.
    
    guiKillAll();
    destroy_bitmap(mBG);
    mBG = NULL;
    destroy_bitmap(mLogo);
    mLogo = NULL;
  
    return 0; //success
};

int CTitlePage::PageSetup_ (void)
{
    // Sets up the Title Page for display.

    // Load the text.
    
    parStrings(txt, "title");

    // Set the background.
    
    mBG = gfxLoad("title_01", "bg");
    mLogo = gfxLoad("logo_01", "titles");
    
    // Set Windows
    
    win.New(0, "window", 320, 432 - txtHeight(3, txt.Get("welcome"), 272, -1), 288, txtHeight(3, txt.Get("welcome"), 272, -1) + 16);
    
    // Set the buttons.
    
	//butNew(1, 352, 232, "big_01", "", "", 0);
	//txtNew(1, 480, 237, txt.Get("campaign"), 2, -1, alignCENTER, 0);
	butNew(2, 32, 10*32 + 8, "big_01", "", "", 0);
	txtNew(2, 160, 10*32 + 13, txt.Get("multi"), 2, -1, alignCENTER, 0);
	//butNew(3, 352, 296, "big_01", "", "", 0);
	//txtNew(3, 480, 301, txt.Get("tutorial"), 2, -1, alignCENTER, 0);
	butNew(4, 32, 11*32 + 8, "big_01", "", "", 0);
	txtNew(4, 160, 11*32 + 13, txt.Get("editor"), 2, -1, alignCENTER, 0);
	//butNew(5, 352, 360, "big_01", "", "", 0);
	//txtNew(5, 480, 365, txt.Get("options"), 2, -1, alignCENTER, 0);
	butNew(6, 32, 12*32 + 8, "big_01", "", "", 0);
	txtNew(6, 160, 12*32 + 13, txt.Get("help"), 2, -1, alignCENTER, 0);
	butNew(0, 32, 13*32 + 8, "big_01", "", "", 0);
	txtNew(0, 160, 13*32 + 13, txt.Get("quit"), 2, -1, alignCENTER, 0);
    
    
    // Show the User Login info
    
    //image.New(0, "large", "avatar", 16, 16, 1);
    //txtNew(20, 92, 32, txt.Get("hello_1") + sys_tUser + txt.Get("hello_2"), 2, -1, alignLEFT, 0);
    //butNew(20, 320, 16, "login", "", "", 0);
    //butOpacity(20, 128);
    //butNew(21, 352, 32, "big_01", "", "", 0);
    //txtNew(21, 480, 37, txt.Get("logout"), 2, -1, alignCENTER, 0);
    
    // Set any additional text.
    
    txtNew(15, 328, 440 - txtHeight(3, txt.Get("welcome"), 272, -1), txt.Get("welcome"), 3, 272, alignLEFT, 0);
    txtNew(16, 32, 460, txt.Get("ver") + " " + sys_tVersion, 1, -1, alignLEFT, 0);
    txtNew(17, 320, 460, txt.Get("copyright") , 1, -1, alignCENTER, 0);
    
    return 0; // Success
};



int titlePage (void)
{
    // Calls the title page, which takes over for the
    // core loop.
    
    title.Page();
    
    return 0; // Success
};
