#include "stdafx.h"
#include "header.h"

class CPlayer
{
public:
    int ClearMenu (void);
    int Flush (void);
    int MenuItem (int iToReturn, string tToCall);
    int TakeTurn (int iFaction);
    
    bool bMenu;                     // Whether or not the menu is up.
private:    
    int DoBoxes_ (int iFaction);
    int DoMenu_ (void);
    int UnitOrders_ (void);
    int UnitWait_ (void);

    bool bAttack;                   // Whether or not the player is choosing a target.
    
    int iFunctionReturn;            // What value the main player function will return.
    int iMenuItems;                 // How many options are currently on the menu.
    int iMouseAtOldX;               // The tile the mouse was hovering over before. (Used for path-finding.)
    int iMouseAtOldY;               // The tile the mouse was hovering over before. (Used for path-finding.)
    int iOldLocX;                   // If the player cancels an order, move the unit back to this x coordinate.
    int iOldLocY;                   // If the player cancels an order, move the unit back to this y coordinate.
    int iReturnValue[25];           // The return value of a given menu item.
    int iSelected;                  // Which unit is currently selected and being given orders to.
    int iStats;                     // Which unit's stats to display in the stat box.
    int iStatWindow;                // Who's Stat Window to View
    int iTarget;                    // Which unit the player wants to attack.
    
    string tName[25];               // The name of a given menu item.
} player;

int CPlayer::ClearMenu (void)
{
    // Clears the player's pop-up menu.
    
    iMenuItems = 0;
    win.Kill(5);
    
    for(int i = 0; i < 25; i++)
    {
        butKill(i + 10);
        txtKill(i + 10);
    };
    
    // Clear the mouse.
    
    mouseClear();
    
    return 0; // Done
};

int CPlayer::Flush (void)
{
    iSelected = -1;
    iFunctionReturn = 0;
    iTarget = -1;
    bAttack = false;
    bMenu = false;
    iStatWindow = -1;
    ClearMenu();
    
    return 0; // Done
};

int CPlayer::MenuItem (int iToReturn, string tToCall)
{
    // Adds an item to the menu.
    
    if(iMenuItems < 25)
    {
        iReturnValue[iMenuItems] = iToReturn;
        tName[iMenuItems] = tToCall;
        iMenuItems++;
    }
    else
        return -1; // Failure, the menu is already full.
    
    return 0; // Success
};

int CPlayer::TakeTurn (int iFaction)
{
    // Allows the player to move their characters. Returns -1 when turn
    // is ended by the player.
    
    // Display the info boxes as needed.
    
    iFunctionReturn = 0;    
    DoBoxes_(iFaction);
    iStatWindow = -1;
    
    if(!bMenu && iStatWindow == -1)
    {
        if(iSelected != -1 && !bAttack)
        {
            // The player is issuing movement orders, we want to track the
            // path that the player is trying to assign.
            
            if(iMouseAtOldX != giMTileX || iMouseAtOldY != giMTileY)
            {
                if(map.iRange[giMTileX][giMTileY] == 1 || map.iRange[giMTileX][giMTileY] == 2)
                    unitAddPath(iSelected, giMTileX, giMTileY, false);
                //aiFindPath(iSelected, giMTileX, giMTileY, false);
                iMouseAtOldX = giMTileX;
                iMouseAtOldY = giMTileY;
            };
        };
        if(mouseClick(1))
        {
            // The user has clicked the left mouse button.
            
            if(iSelected == -1)
            {
                // No unit is selected, so we need to see if there is a unit in
                // this square to be selected.
                
                bool bActiveHere = false;       // Whether or not there's any active unit in this square;
                
                for(int i = 0; i < 250; i++)
                {
                    if(unit[i].bActive == true && unit[i].iLocX == giMTileX && unit[i].iLocY == giMTileY && unit[i].iMoves != 0)
                    {
                        // There's a unit here; check his range.
                        
                        bActiveHere = true;
                        
                        if(unit[i].iMoves > 0)
                        {
                            unitAddPath(iSelected, giMTileX, giMTileY, false);
                            iMouseAtOldX = -1;
                            iMouseAtOldY = -1;
                            aiRange(i);
                            iSelected = i;
                            map.iGlowValue = 0;
                        };
                        
                        break;
                    }                        
                };

                if(!bActiveHere)
                {
                    // There is no unit here, the player wants to bring
                    // up the menu.
                    
                    //MenuItem(2, txt.Get("options"));
                    MenuItem(1, txt.Get("end"));
                    bMenu = true;
                };                
            }
            else if(iSelected != -1 && !bAttack)
            {
                // The player has a unit selected and is issuing movement orders.
                
                if(map.iRange[giMTileX][giMTileY] == 1 && unit[iSelected].iFaction == iFaction)
                {
                    // The unit can move here; tell it to do so, and store its old location
                    // in case the player changes their mind.

                    //unit[iSelected].vPath.clear();
                    iOldLocX = unit[iSelected].iLocX;
                    iOldLocY = unit[iSelected].iLocY;                    
                    //unit[iSelected].iLocX = giMTileX;
                    //unit[iSelected].iLocY = giMTileY;
                    //unit[iSelected].iX = unit[iSelected].iLocX * giTileX;
                    //unit[iSelected].iY = unit[iSelected].iLocY * giTileY;                    
                    unit[iSelected].bMoving = true;
                    map.ClearRange();
                    
                    // Now that the unit has moved, display its options.
                    
                    UnitOrders_();
                    bMenu = true;                    
                }
                else
                {
                    // The player has clicked outside of the unit's range.
                    
                    //map.ClearRange();
                    //iSelected = -1;
                };                
            }
            else if(iSelected != -1 && bAttack && map.iRange[giMTileX][giMTileY] == 3)
            {
                // The player is choosing a target.
                
                bool bUnitHere = false;
                
                for(int i = 0; i < 250; i++)
                {
                    if(unit[i].bActive && unit[i].iLocX == giMTileX && unit[i].iLocY == giMTileY && unit[i].iFaction != unit[iSelected].iFaction)
                    {
                        // There is a unit here that the player can attack
                        
                        bUnitHere = true;
                        iTarget = i;
                        battle.Calculate(iSelected, i);
                        UnitWait_();
                        i = 250;
                    };                        
                };
                if(!bUnitHere)
                {
                    // There isn't a unit here, or it's not a space we can attack.
                    // Cancel the player's orders.
                    
                    
                };
            };
        }; //end if
        if(mouseClick(2))
        {
            // The player has clicked the right mouse button, and wants to cancel any
            // orders being issued, or they want to look at the stats of a given unit.
            
            if(!bAttack && iSelected == -1)
            {                
                for(int i = 0; i < giMaxUnits; i++)
                {
                    if(unit[i].bActive && unit[i].iLocX == giMTileX && unit[i].iLocY == giMTileY)
                    {
                        iStatWindow = i + 1;
                        i = giMaxUnits;
                    }
                    else
                        iStatWindow = -1;
                };
                //iStatWindow = iStats + 1;
                //iFunctionReturn = iStats + 1;
            }
            else if(!bAttack)
            {
                unit[iSelected].vPath.clear();
                map.ClearRange();
                iSelected = -1;
            }
            else if(bAttack)
            {
                iTarget = -1;
                map.ClearRange();
                UnitOrders_();
                bMenu = true;
                bAttack = false;
            };
        };        
    }
    else if(!unitMoving())
    {
        int iChoice = DoMenu_();
        
        if(iChoice < 0)
        {
            if(iSelected == -1)
            {
                // The player wants to close the menu.
                ClearMenu();
                bMenu = false;
            }
            else if(!bAttack)
            {
                // The player is canceling their movement orders.
                unit[iSelected].iLocX = iOldLocX;
                unit[iSelected].iLocY = iOldLocY;
                unit[iSelected].iX = unit[iSelected].iLocX * giTileX;
                unit[iSelected].iY = unit[iSelected].iLocY * giTileY;
                ClearMenu();                
                iSelected = -1;
            }
            else if(bAttack)
            {
                // The player is canceling the attack.
                bAttack = false;
                ClearMenu();
                map.ClearRange();
                UnitOrders_();                
                bMenu = true;
            };
        };
        switch(iChoice)
        {
        case 1:
            ClearMenu();
            return -1; // The player has ended their turn.
        case 2:
            ClearMenu();
            MenuItem(4, txt.Get("settings"));
            MenuItem(3, txt.Get("quit"));
            bMenu = true;
            break;
        case 3:
            ClearMenu();
            return -2; // The player wants to stop playing.
        case 5:
            // The player has instructed a unit to wait.
            UnitWait_();
            break;
        case 6:
            // The player wishes to attack.
            map.ClearRange();
            aiAttackRange(iSelected, unit[iSelected].iLocX, unit[iSelected].iLocY);
            bAttack = true;
            ClearMenu();
            bMenu = false;
            break;
        }; // end switch
    };
    
    //if(keyCheck(KEY_ENTER))
    //    return -1; // The player has ended their turn.
        
    return iFunctionReturn; // Done
};

int CPlayer::DoBoxes_ (int iFaction)
{
    // Displays the info boxes around the screen for the player
    
    // Unit Box
    
    for(int i = 0; i < 250; i++)
    {
        if(unit[i].bActive && unit[i].iLocX == giMTileX && unit[i].iLocY == giMTileY)
        {
            iStats = i;
            i = 250;
        }
        else
            iStats = -1;
    };
    if(iStats != -1 && !bMenu && !bAttack && iStatWindow == -1)
    {
        win.New(4, "window", 16, 16, 144, 4*16);
        txtNew(8, 88, 32, "", 2, -1, alignCENTER, 0);
        txtReset(8, unit[iStats].tName + "/n"
            + txt.Get("hp") + ": " + txtInt(unit[iStats].iHP) + "/" + txtInt(unit[iStats].iMaxHP));

        if(mouse_x < 300 /*&& mouse_y < 224*/)
        {
            win.Move(4, 480, 16);
            txtMove(8, 552, 32);
        }
        else if (mouse_x > 340 /*&& mouse_y < 224*/)
        {
            win.Move(4, 16, 16);
            txtMove(8, 88, 32);
        };
    }
    else
    {
        win.Kill(4);
        txtKill(8);
        txtKill(9);
    };
    
    // Terrain Box
    
    if(!bMenu && !bAttack && iStatWindow == -1)
    {
        win.New(3, "window", 16, 368, 144, 96);
        txtNew(5, 88, 384, "", 2, -1, alignCENTER, 0);
        txtReset(5, terrain[terrainAt(giMTileX, giMTileY)].tName + "/n " + 
            txt.Get("def") + txtInt(terrain[terrainAt(giMTileX, giMTileY)].iDef) + "/n " +
            txt.Get("res") + txtInt(terrain[terrainAt(giMTileX, giMTileY)].iRes) + "/n " +
            txt.Get("avo") + txtInt(terrain[terrainAt(giMTileX, giMTileY)].iAvo));
        
        if(mouse_x < 320 /*&& mouse_y > 260*/)
        {
            win.Move(3, 480, 368);
            txtMove(5, 552, 384);
        }
        else if (mouse_x > 319 /*&& mouse_y > 260*/)
        {
            win.Move(3, 16, 368);
            txtMove(5, 88, 384);
        };
    }
    else
    {
        win.Kill(3);
        txtKill(5);
    };    
    
    // Attack Info Box
    
    if(iStats != -1 && !bMenu && bAttack && unit[iStats].iFaction != iFaction)
    {
        int iDamageTo = unit[iSelected].iSTR - (unit[iStats].iCON + terrain[unitTerrain(iStats)].iDef);
        int iDamageFrom = unit[iStats].iSTR - (unit[iSelected].iCON + terrain[unitTerrain(iSelected)].iDef);
        int iDistanceFrom = aiHeuristic(unit[iSelected].iLocX, unit[iSelected].iLocY, unit[iStats].iLocX, unit[iStats].iLocY);
        
        if(iDamageTo < 0)
            iDamageTo = 0;
        if(iDamageFrom < 0)
            iDamageFrom = 0;
        
        win.New(2, "window", 16, 16, 144, 176);
        txtNew(3, 88, 32, "", 2, -1, alignCENTER, 0);
        txtNew(4, 44, 64, "", 2, -1, alignCENTER, 0);
        if(iDistanceFrom >= unit[iStats].iNear && iDistanceFrom <= unit[iStats].iNear + unit[iStats].iRange)
            txtNew(5, 128, 64, "", 2, -1, alignCENTER, 0);
        //txtNew(6, 88, 64, "", 2, -1, alignCENTER, 0);
        txtReset(3, unit[iSelected].tName + "/n" + " /n" + txt.Get("hp") + "/n" + txt.Get("mp") + "/n"
            + txt.Get("mt") + "/n" + txt.Get("hit") + "/n" + txt.Get("crt") + "/n" + "/n" + unit[iStats].tName);
        txtReset(4, txtInt(unit[iSelected].iHP) + "/n" + txtInt(unit[iSelected].iMP)
            + "/n " + txtInt(iDamageTo) + "/n" + txtInt(unitHit(iSelected) - unitAvoid(iStats)) + "/n" + "0");
        txtReset(5, txtInt(unit[iStats].iHP) + "/n" + txtInt(unit[iStats].iMP)
            + "/n " + txtInt(iDamageFrom) + "/n" + txtInt(unitHit(iStats) - unitAvoid(iSelected)) + "/n" + "0");

    }
    else
    {
        win.Kill(2);
        txtKill(3);
        txtKill(4);
    }; 
    
    // Stat Window Handling
    
    if(iStatWindow != -1)
    {        
        iFunctionReturn = iStatWindow + 1;
    }

    return 0; // Done
};

int CPlayer::DoMenu_ (void)
{
    // Displays the player's pop-up menu, and returns a value
    // if the player has made a selection. Otherwise, returns
    // a 0. If there are no items on the menu, then it will
    // return a -2. If the user wants to close the menu, it
    // will return a -1.
    
    int iAtX = mouse_x - 72;
    int iAtY = mouse_y + 16; //- 32 - iMenuItems*16;
    
    if(iAtY < 32)
        iAtY = 32;
    if(iAtY > 416 - iMenuItems*16)
        iAtY = 416 - iMenuItems*16;
    if(iAtX < 32)
        iAtX = 32;
    if(iAtX > 464)
        iAtX = 464;    
    
    if(iMenuItems == 0)
        return -2;  // Failure, there are no menu items.
    
    win.New(5, "window", iAtX, iAtY, 144, 32 + iMenuItems*16);
    
    for(int i = 0; i < iMenuItems; i++)
    {
        butNew(i + 10, iAtX + 16, iAtY + (i*16) + 16, "plain_small", "", "", 0);
        txtNew(i + 10, iAtX + 16, (iAtY + 16 + i*16)+2, " " + tName[i], 2, -1, alignLEFT, 0);
        butOpacity(i + 10, 127);
        
        if(butCheck(i + 10))
        {
            mouseClear();
            return iReturnValue[i];
        };
    };
    if(mouseClick(2))
        return -1;  // Done, the player wants to close the menu.
    
    return 0; // Done, the player has not made a selection.    
};

int CPlayer::UnitOrders_ (void)
{
    // Checks which orders can be given to a unit, then adds them
    // to the menu.
    
    int iEndX = unit[iSelected].iLocX;      // The unit's X desitnation
    int iEndY = unit[iSelected].iLocY;      // The unit's Y destination
    
    if(unit[iSelected].vPath.size() > 0)
    {
        iEndX = unit[iSelected].vPath[unit[iSelected].vPath.size() - 1].iX;
        iEndY = unit[iSelected].vPath[unit[iSelected].vPath.size() - 1].iY;
    };
    
    if(unitCanAttack(iSelected, iEndX, iEndY))
        MenuItem(6, txt.Get("attack"));
    MenuItem(5, txt.Get("wait"));
    MenuItem(-1, txt.Get("cancel"));
    
    return 0; // Done
};

int CPlayer::UnitWait_ (void)
{
    // Instructs the given unit to wait.
    
    map.ClearRange();
    colorGray(unit[iSelected].mImage);
    unit[iSelected].iMoves = 0;
    iSelected = -1;
    iTarget = -1;
    ClearMenu();
    bMenu = false;
    bAttack = false;
    
    return 0; // Success
};

bool playerBusy (void)
{
    // Checks if the player has the menu up, etc.
    
    if(player.bMenu == true)
        return true; // The player has the menu up.
    else
        return false; // The player is issuing normal commands.
};

int playerTurn (int iFaction)
{
    // Simply calls and returns the calue of player.TakeTurn.
    // If -1 is passed, all the data is flushed, so that the next
    // faction can take their turn.
    
    if(iFaction == -1)
        return player.Flush();
    else
        return player.TakeTurn(iFaction); // Done
};
