#include "stdafx.h"
#include "header.h"

typedef struct stHelpMenu
{
    string tName;
    string tLink;
    int iType;
} makeMenu;

class CHtml
{
public:
	int Core (string tPage);
private:
	
	// Private Functions
	
	int NewPage_ (int iPage, int iSetX, int iSetY, int iSetW, int iSetH, int iSetMargin);
    int parHTML_ (int iPage, string tFile);
    int parMENU_ (int iPage, string tFile);
    
	
	// Private Variables
	
	BITMAP *mPage[10];					// The page we will render to.
	
	int iMargin[10];                    // A page's margin size.
    int iWidth[10];						// How wide the HTML display area is.
	int iHeight[10];					// How high the HTML display area is.
	int iX[10];				    		// The X origin of the HTML display area.
	int iY[10];							// The Y origin of the HTML display area.
	
	string tCurrentPath;				// The current path we are browsing.
    string tTitle[10];                  // Page titles
    
    makeMenu sMenu[50];
} manual;

int CHtml::Core (string tPage)
{
    BITMAP *mBG = create_bitmap(SCREEN_W, SCREEN_H);    
    
    parStrings(txt, "html");    
    tCurrentPath = sys_tSysPath + sys_tTextPath + sys_tLanguage + "/" + sys_tHTML;

    NewPage_(0, 160, 64, 416, 384, 10);
	parHTML_(0, tPage);
    parMENU_(1, tCurrentPath + "menu_home.txt");
    
    screenGet(mBG);
	drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
	rectfill(mBG, 16, 16, 624, 464, makecol(0, 0, 0));
    rectfill(mBG, 16, 16, 624, 464, makecol(0, 0, 0));
    rectfill(mBG, 16, 16, 624, 464, makecol(0, 0, 0));
	solid_mode();
    
    //win.New(0, "window", 16, 16, 608, 448);
    txtNew(1, 32, 32, " ", 2, -1, alignLEFT, 0);
    butNew(0, 32, 424, "sml_01", "", "", 0);
    txtNew(0, 88, 430, txt.Get("exit"), 2, -1, alignCENTER, 0);
    //butNew(2, 32, 64, "sml_01", "", "", 0);
    //txtNew(2, 88, 70, txt.Get("home"), 2, -1, alignCENTER, 0);
    //butNew(3, 32, 96, "sml_01", "", "", 0);
    //txtNew(3, 88, 102, txt.Get("tile"), 2, -1, alignCENTER, 0);
    //butNew(4, 32, 128, "sml_01", "", "", 0);
    //txtNew(4, 88, 134, txt.Get("about"), 2, -1, alignCENTER, 0);
	
	while(!keyCheck(KEY_ESC) && !butCheck(0))
	{
        txtReset(1, gTxt.Get("name") + " " + txt.Get("help") + " - " + tTitle[0]);
        blit(mBG, mBuffer, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
        masked_blit(mPage[0], mBuffer, 0, 0, iX[0], iY[0], iWidth[0], iHeight[0]);
		displayAll();
        
        // Check to see if a menu button has been pushed.
        
        for(int i = 0; i < 20; i++)
        {
            if(butCheck(i+10))
                parHTML_(0, sMenu[i].tLink);
        };
    };
	
	// Clean up before returning.
	
	guiKillAll();
    
    destroy_bitmap(mPage[0]);
    destroy_bitmap(mBG);
	
	return 0; // Success
};

int CHtml::NewPage_ (int iPage, int iSetX, int iSetY, int iSetW, int iSetH, int iSetMargin)
{
    // Sets up a new HTML "page" to get ready to be parsed.
    
	iWidth[iPage] = iSetW;
    iHeight[iPage] = iSetH;
	iX[iPage] = iSetX;
	iY[iPage] = iSetY;
    iMargin[iPage] = iSetMargin;
    
    mPage[iPage] = create_bitmap(iSetW, 1500);
    colorReplace(mPage[iPage], makecol(0, 0, 0), makecol(255, 0, 255));    
    
    return 0; // Success
};


int CHtml::parHTML_ (int iPage, string tFile)
{
	// This routine goes through an xhtml file and parses
	// the data for use in a simple HTML browser that the
	// help manual uses.
	
	FILE * pFile;					// A pointer to the file itself.
	char cCommand;					// A single character from the file.
	int iColor = makecol(255, 255, 255);    // The color to give to rendered elements.
    int iOffset = iMargin[iPage];	// How far from the top of the page to display a text object.
	int iTxtObj = 0;				// Which text object to write to.
	bool bDisplayText = false;		// Until a tag tells us to do so, we don't display text.
	string tTemp;					// A working string.
	string tText;					// Text to actually be displayed.

	// Open the file and check for errors.
    
    // TODO: In the future, this should just show up as an error message,
    // and not boot the user just because the engine can't find the
    // requested help page on something useless like the about page.
	
    tFile = tCurrentPath + tFile + ".txt";
    
	if(!exists(tFile.c_str()))
	{
		allegro_message("Cannot find the requested file for the help guide, or it may be corrupt.");
		exit(-1);
	};
    
	pFile = fopen(tFile.c_str(), "rt");

	// And now to begin parsing.
	
	clear_bitmap(mPage[iPage]);
    if(!sys_bDebugMode)
        colorReplace(mPage[iPage], makecol(0, 0, 0), makecol(255, 0, 255));
    txtSetBitmap(mPage[iPage]);

	while(!feof(pFile))
	{
		// The basic idea is to sort between two data catagories:
		// XHTML tags, and text.

		cCommand = (char)fgetc(pFile);

		if(cCommand == '<') // Stop the presses, we've found a tag!
        {
			// First, print anything to the screen that we've already
			// processed.
			
			if(bDisplayText)
			{				
				tText += tTemp;
				iTxtObj++;
			};
			
			cCommand = (char)fgetc(pFile);

			while(cCommand != '>')
			{
				// We want to continue gathering data from the tag
				// until we hit the end.
				
				tTemp = "";
				
				while(cCommand != '>' && cCommand != ' ')
				{
					tTemp += cCommand;
					cCommand = (char)fgetc(pFile);				
				};
				
				if(tTemp == "title")
					bDisplayText = true;
				if(tTemp == "/title")
				{
                    tTitle[iPage] = tText;
					bDisplayText = false;
					tText = "";
				};
				if(tTemp == "p")
					bDisplayText = true;
				if(tTemp == "/p")
				{
					txtOut(3, iMargin[iPage], 0 + iOffset, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					iOffset += txtHeight(3, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					iOffset += txtHeight(3, " ", iWidth[iPage] - (iMargin[iPage] * 2), -1);
					bDisplayText = false;
					tText = "";
				};
                
                // Header Lines
                
				if(tTemp == "h1")
					bDisplayText = true;                
				if(tTemp == "/h1")
				{
					txtCenter(2, iWidth[iPage] / 2, 0 + iOffset, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					iOffset += txtHeight(2, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					line(mPage[iPage], iMargin[iPage], iOffset, iWidth[iPage] - iMargin[iPage], iOffset, iColor);
                    iOffset += txtHeight(2, " ", iWidth[iPage] - (iMargin[iPage] *2), -1);
					bDisplayText = false;
					tText = "";
				};
                
                if(tTemp == "h2")
					bDisplayText = true;                
				if(tTemp == "/h2")
				{
					txtCenter(2, iWidth[iPage] / 2, 0 + iOffset, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					iOffset += txtHeight(2, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
                    iOffset += txtHeight(2, " ", iWidth[iPage] - (iMargin[iPage] *2), -1);
					bDisplayText = false;
					tText = "";
				};
                
                if(tTemp == "h6")
					bDisplayText = true;                
				if(tTemp == "/h6")
				{
					txtCenter(1, iWidth[iPage] / 2, 0 + iOffset, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					iOffset += txtHeight(1, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
                    iOffset += txtHeight(2, " ", iWidth[iPage] - (iMargin[iPage] *2), -1);
					bDisplayText = false;
					tText = "";
				};
                
                // Line Break
                
				if(tTemp == "br")
				{
					txtOut(2, iMargin[iPage], 0 + iOffset, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					iOffset += txtHeight(2, tText, iWidth[iPage] - (iMargin[iPage] * 2), -1);
					tText = "";
				};
			};
			
			tTemp = "";
		}
		else
		{
			// We haven't hit a tag yet, so we'll add data to
			// the tTemp string to get it ready for display.
			
			tTemp += cCommand;
		};
	};
	
	// Before we go, we need to write the last bit of data to the
	// text object, as neccisary.  (Actually, no we don't, if it's
    // valid XHTML.)
	
	//if(bDisplayText)
		//txtOut(2, iX[iPage], iY[iPage] + iOffset, tText, iWidth[iPage], 0);

	// Okay, we're done here; close the file and clean everything up.

	fclose(pFile);
	txtSetBitmap(mBuffer);

	return 0; // Success
};

int CHtml::parMENU_ (int iPage, string tFile)
{
    // Parses the menu file for the left-hand selection menu.
    
    ifstream file;
    char cRead;
    char cBuffer[2000];
    string tBuffer;
    int iObject = 0;
    
    // Open the file.
    
    if(!exists(tFile.c_str()))
        return -1; // Failure, the file isn't there
    
    file.open(tFile.c_str());
    
	while(!file.eof())
	{
        // We want to continue reading until we come to a tag.
        
        cRead = file.get();
        
        if(cRead == '<') // Stop the presses, we've found a tag!
        {
            tBuffer = "";
            while(cRead != '>')
            {
                cRead = file.get();
                if(cRead != ' ')
                    tBuffer += cRead;
                
                if(tBuffer == "home")
                {
                    sMenu[iObject].iType = 1;
                    sMenu[iObject].tName = "";
                    sMenu[iObject].tLink = "";
                    tBuffer = "";
                };
                if(tBuffer == "book")
                {
                    sMenu[iObject].iType = 2;
                    sMenu[iObject].tName = "  ";
                    sMenu[iObject].tLink = "";
                    tBuffer = "";
                };
                if(tBuffer == "page")
                {
                    sMenu[iObject].iType = 3;
                    sMenu[iObject].tName = "    ";
                    sMenu[iObject].tLink = "";
                    tBuffer = "";
                };
                
                if(tBuffer == "link=")
                {
                    while(cRead != '\"')
                    {
                        cRead = file.get();
                    };
                    cRead = file.get();
                    while(cRead != '\"')
                    {
                        sMenu[iObject].tLink += cRead;
                        cRead = file.get();
                    };                 
                };
            };
            
            // Now, get the name of this object.
            
            file.getline(cBuffer, 2000);
            file.getline(cBuffer, 2000);
            sMenu[iObject].tName += cBuffer;
            txtNew(10 + iObject, 2*16, ((4 + iObject)*16)+4, sMenu[iObject].tName, 1, -1, alignLEFT, 0);
            if(sMenu[iObject].tLink != "")
            {
                butNew(10 + iObject, 2*16, (4 + iObject)*16, "plain_small", "", "", 0);
                butOpacity(10 + iObject, 128);
            };
            
            iObject++; // We've already written to this object, on to the next one.
        };
        if(cRead == '#') // We want to skip comments.
        {
            file.getline(cBuffer, 2000);
        };
    };    
    
    // We're done -- Close the file.
    
    file.close();
    
    return 0; // success
};

int htmManual (string tPage)
{
	// Displays the user help files by calling up the
	// manual class.
	
	manual.Core(tPage);
	
	return 0; // Success
};
