// -- header.h --
//
// A list of all the functions used by the program, collected into a header
// file for easy use.

#pragma once


// Global Defines

#define alignLEFT		0
#define alignCENTER		1
#define alignRIGHT		2

#define dDOWN			2
#define dLEFT			4
#define dRIGHT			6
#define dUP				8

#define maxHEIGHT		120
#define maxWIDTH		120


// Global Classes

#include "battle_data.h"
#include "class_data.h"
#include "faction_data.h"
#include "file_list.h"
#include "gui_image.h"
#include "gui_integer-field.h"
#include "gui_text-box.h"
#include "gui_windows.h"
#include "lang_strings.h"
#include "map_data.h"
#include "map_terrain-data.h"
#include "sys_message-data.h"
#include "unit_data.h"

// Global Functions

int  aiAttackRange (int iUnit, int iX, int iY);
int  aiFindPath (int iUnit, int iX, int iY, bool bIgnoreCost);
int  aiHeuristic (int iX1, int iY1, int iX2, int iY2);
int  aiRange (int iUnit);

void butBlink(bool bSet);
int  butCheck(int iToCheck);
void butDisplay();
int  butKill(int iToKill);
int  butKillAll();
int  butNew(int iToSet, int iSetX, int iSetY, string tUp, string tDown, string tHover, int iOffset);
int  butOpacity(int iToSet, int iOpac);
int  butReset(int iToSet);
void butUpdate();

int  classLoad(string tFile);
int  classSetup();

int  colorAlpha (BITMAP *bImage);
int  colorGet (void);
int  colorGray (BITMAP *bImage);
int  colorReplace (BITMAP *bImage, const int iColor, const int iReplace);
int  colorSwap (BITMAP *bImage, const int iFrom, const int iTo);

void displayAll (void);

int  editMap (void);
int  editSelect (void);

int  factionLoad (string tFile);
int  factionStart (int iFaction);

BITMAP  *gfxLoad (string tFile, string tLocation);
int  gfxUnload (BITMAP *bImage);

int  guiEZ (int iSpacing);
int  guiKillAll (void);
int  guiLoading (void);

bool keyCheck (int iKey);
int  keyReset (void);
int  keyUpdate (void);

int  htmManual (string tPage);

string loadDialog (string tFolder, string tExtension, string tFile, string tMessage, int iOption);
int  loadMap (string tFile);

void mapProperties (void);

int  mpWin (int iTeam);

int  mouseClear (void);
bool mouseClick(int iButton);
int  mouseGFX(string tFileName);
int  mouseUpdate (void);

int  musPlay(int iTrack);
int  musStop();

string parGet (FILE *pFile, ...);
int  parSettingsIni (void);
int  parStrings (CText &txtObj, string tFileName);

int  playMap (void);

bool playerBusy (void);
int  playerTurn (int iFaction);

int  rulesetLoad (string tPath);

string saveDialog (string tFolder, string tExtension, string tFile, string tMessage, int iOption);
int saveMap (string tFile);

void screenDisplay (void);
void screenGet (BITMAP *mBitmap);
void screenIn (int iSpeed, int iColor);
void screenOut (int iSpeed, int iColor);

void systemQuit (void);

int  setupCore (void);

int  terrainAt (int iX, int iY);
int  terrainFind (string tToFind);
int  terrainLoad (string tFile);

bool timeCheck (void);
void timeIncrease();
void timeSecondIncrease();
void timeStandby(int iToWait);
void timeWait();

void titleLanguageSelect (void);
int  titlePage (void);

int  txtCheckWordLength(int iFont, string tText);
int  txtCenter(int iFont, int iLocX, int iLocY, string tText, int iLength, int iToPrint);
void txtDisplay();
int  txtHeight (int iFontToUse, string tText, int iTextLength, int iNumberOfCharactersToPrint);
string txtInt (int iInteger);
int  txtKill(int iToKill);
int  txtKillAll();
int  txtMove (int iToSet, int iNewX, int iNewY);
int  txtNew(int iToSet, int iLocX, int iLocY, string tText, int iFont, int iWidth, int iAlign, int iSpeed);
int  txtOut(int iFontToUse, int iTextLocationX, int iTextLocationY, string tText, int iTextLength, int iNumberOfCharactersToPrint);
int  txtReset (int iToSet, string tText);
int  txtRight(int iFont, int iLocX, int iLocY, string tText, int iLength, int iToPrint);
int  txtSetBitmap (BITMAP *mToSetTo);
int  txtSetFont(int iFontNumberToSet, char cFontImageName[], int iFontWidthToSet, int iFontHeightToSet);
int  txtWidthOfChar (const int iFont, const int iChar);

int  unitAddPath (int iUnit, int iX, int iY, bool bIgnoreCost);
int  unitAt (int iX, int iY);
int  unitAvoid (int iUnit);
bool unitCanAttack(int iUnit, int iX, int iY);
int  unitClear (void);
int  unitDisplay (int iClass, int iColor, int iAnim, int iX, int iY);
int  unitHit (int iUnit);
int  unitKillAll (void);
bool unitMoving (void);
int  unitReset (int iFaction);
int  unitTerrain (int iUnit);
int  unitUpdate (void);

int  usrLogin (void);



// Global Class Objects

extern CBattle battle;
extern CClass rank[250];
extern CFaction faction[16];
extern CImage image;
extern CIntFld intFld;
extern CMap map;
extern CMessage msg;
extern CTerrain terrain[50];
extern CText txt;
extern CText gTxt;
extern CText eTxt;
extern CTxtBox field;
extern CUnit unit[250];
extern CWindows win;



// Declare Global Variables and structures.

extern	BITMAP	*mBuffer;
extern	BITMAP	*mMouse;

extern	bool	sys_bClock;
extern	bool	sys_bDebugMode;
extern  bool    sys_bDisplay;
extern  bool    sys_bFrameSkip;
extern	bool	sys_bFPS;
extern	bool	sys_bUseVSync;
extern	bool	sys_bWindowedMode;

extern  string  gtDebug;
extern	string	sys_tLanguage;
extern	string	sys_tPath;
extern  string  sys_tUser;

extern  int     giClassSlotsUsed;
extern  int     giColorChart[20][10];
extern  int     giGrid;
extern  int     giMTileX;
extern  int     giMTileY;
extern  int     giTeams;
extern  int     giTerrainPres[50];
extern  int     giTerrainSlotsUsed;
extern  int     giTotalFactions;
extern  int     giTotalUnits;
extern  int     giUnitBob[2];

extern  int     sys_iFrameSkip;

// Declare Global Constants

const	int		sys_iScreenHeight	= 480;
const	int		sys_iScreenWidth	= 640;

const   int     giMaxUnits          = 100;
const   int     giUnitSourceX       = 32;
const   int     giUnitSourceY       = 32;
const   int     giUnitOffsetX       = 32;
const   int     giUnitOffsetY       = 48;
const   int     giUnitHeight        = 96;
const   int     giUnitWidth         = 96;
const	int		giTileX				= 32;
const	int		giTileY				= 32;
const	int		giTileHeight		= 48;
const	int		giTileWidth			= 32;
const	int		giTilesHigh			= 15;
const	int		giTilesWide			= 20;
const	int		giTerrainLayers		= 4;

const   string  sys_tAvatarPath     = "avatars/";
const   string  sys_tBGPath         = "images/bg/";
const	string	sys_tButPath		= "images/buttons/";
const   string  sys_tDataPath       = "data/";
const	string	sys_tElmPath		= "images/elements/";
const   string  sys_tFontPath       = "images/fonts";
const	string	sys_tGUIPath		= "images/gui/";
const	string	sys_tHTML   		= "manual/";
const   string  sys_tMPMapPath      = "shared/maps/";
const	string	sys_tMousePath		= "images/mouse/";
const   string  sys_tRuleSetPath    = "shared/rulesets/";
const	string	sys_tSysPath		= "system/";
const   string  sys_tTeamPath       = "images/teams/";
const	string	sys_tTextPath		= "text/";
const	string	sys_tTilePath		= "images/tilesets/";
const   string  sys_tTitlePath      = "images/titles/";
const   string  sys_tUserPath       = "users/";
const	string	sys_tUnitPath		= "images/units/";
const	string	sys_tVersion		= "0.5.0";

