#include "stdafx.h"
#include "header.h"

int CImage::Display (int iDisplayLayer)
{
    // Displays all the GUI images in a given layer.
    
    for(int i = 0; i < giTotalImages; i++)
    {
        if(bActive[i] == true && iLayer[i] == iDisplayLayer)
            draw_sprite(mBuffer, mImage[i], iX[i], iY[i]);
    };
    
    return 0; // Success
};

int CImage::Kill (int iToKill)
{
    // Clears a given GUI image.
    
    bActive[iToKill] = false;
    destroy_bitmap(mImage[iToKill]);
    mImage[iToKill] = NULL;
    
    return 0; // Success
};

int CImage::KillAll (void)
{
    // Clears all GUI images.
    
    for(int i = 0; i < giTotalImages; i++)
        Kill(i);
    
    return 0; // Success
};

int CImage::New (int iSetTo, string tFileName, string tLocation, int iSetX, int iSetY, int iSetLayer)
{
    // Loads a new GUI image.
    
    bActive[iSetTo] = true;
    mImage[iSetTo] = gfxLoad(tFileName, tLocation);
    iX[iSetTo] = iSetX * giGrid;
    iY[iSetTo] = iSetY * giGrid;
    iLayer[iSetTo] = iSetLayer;
    
    return 0; // Success
};
