// Global Variables

#include "stdafx.h"
#include "header.h"


// Allegro Bitmap Objects

BITMAP	*mBuffer;		// The buffer is what all the graphics are displayed
						// to.  Once the display is ready, it will be copied
						// directly to the screen.

BITMAP	*mMouse;		// This is the bitmap for the mouse pointer.


// Other Global Objects

CBattle     battle;         // The results of a battle.

CClass      rank[250];      // The data for all the classes.

CFaction    faction[16];    // Faction data.

CImage      image;          // GUI Images

CIntFld     intFld;         // Integer fields objects.

CMap    	map;			// All the map data and functions for handling it.

CMessage    msg;            // The message system data.

CTerrain    terrain[50];    // The data for the current map terrain.

CText   	txt;			// Basic text object, changed out depending on the need.

CText	    gTxt;			// Global text, used everywhere.  Only loaded once and saved.

CText   	eTxt;			// Error text.  Only loaded once and saved.

CTxtBox     field;          // Text box object

CUnit       unit[250];      // Unit data

CWindows    win;            // Data for the GUI display windows.


// Booleans

bool sys_bClock = false;			// If true, will display the current time on the screen.

bool sys_bDebugMode = false;		// The debug mode toggle.

bool sys_bDisplay = true;           // The screenDisplay() routine will only draw to the
                                    // screen if this is "true." Set to false if you need to
                                    // get the screen ready between fades, for example.

bool sys_bFrameSkip = false;        // Toggle for frame skipping.

bool sys_bFPS = false;				// Frames per second display toggle.

bool sys_bUseVSync = true;			// Whether or not to wait for the vertical refresh
									// before blitting the buffer to the screen.

bool sys_bWindowedMode = false;		// Whether or not to use windowed mode.


// Integers

int  giClassSlotsUsed;              // How many classes there currently are that can be used.

int  giColorChart[20][10];          // Look-up chart for "palette swaps."

int  giGrid = 1;                    // The "EZ Grid" used for GUI layout. This is the number
                                    // to multiply GUI coordinates by so that elements can be
                                    // laid out in increments of, for example, 16 or 32.

int  giTeams = 0;                   // How many teams are still alive and active on the map.

int  giMTileX = 0;                  // What absolute tile the mouse is hovering over at the moment.

int  giMTileY = 0;                  // What absolute tile the mouse is hovering over at the moment.

int  giTerrainPres[50];             // Terrain presidence. The lower the number, the more types
                                    // of terrain this one will overlap.

int  giTerrainSlotsUsed;            // How many types of terrain there currently are that can
                                    // be used.

int  giTotalFactions;               // The total number of factions used on the current map.

int  giTotalUnits;                  // The total number of active units on the map.

int  giUnitBob[2];                  // A simple array used to time the animation of units on
                                    // the map display.


int  sys_iFrameSkip;                // The frame skip counter.


// C++ Style Strings

string gtDebug = "";                // Debug text, displayed when debug mode is on. Can display
                                    // messages that have been hard-coded into the engine during
                                    // work on various routines.

string sys_tLanguage = "XX";		// What language to use. English (EN) is the default.
									// See the language source files for more information.

string sys_tPath = "system/";		// The current path that the engine is using.  This starts
									// out as the system folder, but will be changed as needed.
                                    // Generaly, in most cases this will be whatever campaign
                                    // or rule set's folder the engine is currently running.
									// If a file cannot be found in the current folder, the
									// engine will look in the current user's custom folder,
                                    // and finally the system path.

string sys_tUser = "";              // This is the current user. In the beginning, it is empty.
