#include "stdafx.h"
#include "header.h"

// Public

int CFileList::Get (string tToFind, string tLookIn, int iType)
{
    // Find all the requested file types.
    
    tFolder = tLookIn;
    tToFind = tFolder + tToFind;
    
    iLoops = -1;
    iNumber = for_each_file_ex(tToFind.c_str(), iType, 0, STATICfileCallback, this);
    
    if(iNumber == 0)
        return -1; // There are no files
    
    tName = new string[iNumber];
    iSize = new int[iNumber];
    
    iLoops = 0;
    for_each_file_ex(tToFind.c_str(), iType, 0, STATICfileCallback, this);

    return iNumber; // Success
};

int CFileList::Kill (void)
{
    // To avoid memory leaks, deletes all the pointer data
    // once the engine is done with it.
    
    //delete [] tName;
    delete [] iSize;
    
    return 0; // Success
};

int CFileList::Handle (const char* cFileName, int iAttrib)
{
    // Gets file info from each file. Called by the Get routine.
    // If the iLoops variable has been set to -1, that means that
    // we're only inspecting the number of files, and don't need
    // to get individual information on each of them.
    
    if(iLoops != -1)
    {
        tName[iLoops] = cFileName;
        tName[iLoops].erase(0, tFolder.length());
        //iSize = file_size(tFileName.c_str());
        
        iLoops++;
    };
    
    return 0; // Success
};
