#include "stdafx.h"
#include "header.h"

class CMapEditor
{
public:
	int TileRover (void);
private:

	// Functions

	int  FindMouse_ (void);
	int  Menu_ (void);
	int  MenuDisplay_ (void);
	int  MoveMap_ (int iDirection);
	int  Palette_ (void);
	int  PaletteDisplay_ (void);
    int  PointerSet_ (bool bSet);
    int  RoverGUI_ (void);
	int  ScrollMap_ (void);

	// Variables
	
	bool bQuit;
	bool bKeyDown[127];		// Waiting for the user to let go of a key.

	int iClass;             // The generic unit that the user is wanting to lay down.
    int iFaction;           // The faction that the user currently wants the units to be a part of.
    int iTool;				// The current tool that the user is using.
	int iTerrain;			// The terrain that the user is wanting to lay down.
    int iTerrainAlt;        // The specific tile in a non-smoothing terrain group that the user wants to use.
	int iLayer;				// The current layer being edited to.

	int iOffsetX;			// How far from the map's X origin the screen is.
	int iOffsetY;			// How far from the map's X origin the screen is.
	int iOffsetXX;			// An additional pixel offset to add to OffsetX to give a true scrolling effect.
	int iOffsetYY;			// An additional pixel offset to add to OffsetY to give a true scrolling effect.
	int iScrollSpeed;		// How quickly to scroll the screen.
	int iX;					// The X Location of the Tile that the mouse is currently hovering over.
	int iY;					// The Y Location of the Tile that the mouse is currently hovering over.
	int iXPos;				// The exact location on the screen of the tile that the mouse is hovering over on the screen.
	int iYPos;				// The exact location on the screen of the tile that the mouse is hovering over on the screen.

	string tFile;           // The name of the file we're currently working with.
    string tPath;           // The path to the file we're currently working with.
} edit; // end CMapEditor



// Public Functions

int CMapEditor::TileRover (void)
{
    rulesetLoad("default");
	bQuit = false;
    iOffsetX = 0;
    iOffsetY = 0;
	map.Clear();
	iScrollSpeed = 4;
    
    parStrings(txt, "map_editor");

	map.LoadTiles("001");
    
    // Set the tool to the Terrain Tool
    
    iTool = 0;
    PointerSet_(true);
    iTerrain = 1;
    iTerrainAlt = 0;
    iClass = 1;
    iFaction = 1;
    tPath = sys_tMPMapPath;

	// Main "Tile Rover" Loop
    
    RoverGUI_();

	while(bQuit == false)
	{
        // Update the mouse.
        
        FindMouse_();
            
        // Before displaying, we need to keep the info boxes out of the user's way.
            
        guiEZ(16);
        
        if(iX < 7 && iY < 6)
        {
            txtMove(4, 30, 1);
            txtMove(2, 30, 3);
            txtMove(3, 30, 4);
            txtMove(5, 30, 6);
            win.Move(1, 1, 25);
            txtMove(0, 5, 26);
            txtMove(1, 5, 27);
        };
        if(iX > 11 && iY < 6)
        {
            txtMove(4, 1, 1);
            txtMove(2, 1, 3);
            txtMove(3, 1, 4);
            txtMove(5, 1, 6);
            win.Move(1, 1, 25);
            txtMove(0, 5, 26);
            txtMove(1, 5, 27);            
        };        
        if(iX < 7 && iY > 8)
        {
            txtMove(4, 30, 1);
            txtMove(2, 30, 3);
            txtMove(3, 30, 4);
            txtMove(5, 30, 6);
            win.Move(1, 1, 1);
            txtMove(0, 5, 2);
            txtMove(1, 5, 3);            
        };
        
		clear(mBuffer);

		// Highlight the tile that the mouse is hovering over.


        // Display whatever unit, terrain, or object the current tool is set to place.
        
		map.Display(iOffsetX, iOffsetY, iOffsetXX, iOffsetYY, false, iLayer);
        unitUpdate();
		drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
		rectfill(mBuffer, iXPos, iYPos, iXPos + giTileX - 1, iYPos + giTileY - 1, makecol(255, 255, 255));
		solid_mode();

        {
            int iLocX = mouse_x + 16;
            int iLocY = mouse_y + 16 - (giTileHeight - giTileY);
            
            // Terrain
            
			if(iTool == 0)
            {
                int iSrcX = (iTerrainAlt * giTileWidth) + giTileWidth;
                int iSrcY = ((iTerrain - 1) * giTileHeight) + giTileHeight;
            
                if(iTerrain != 0)
                {
                    rect(mBuffer, iLocX - 1, iLocY - 1 + (giTileHeight/3), iLocX + giTileWidth, iLocY + giTileHeight, makecol(0,0,0));
                    masked_blit(map.mTiles, mBuffer, iSrcX, iSrcY, iLocX, iLocY, giTileWidth, giTileHeight);
                }
                else
                    rectfill(mBuffer, iLocX - 1, iLocY - 1 + (giTileHeight/3), iLocX + giTileWidth, iLocY + giTileHeight, makecol(0,0,0));
            };
            
            // Units
            
			if(iTool == 1)
            {
                //masked_blit(rank[iClass].mUnit, mBuffer, giUnitSourceX, giUnitSourceY, iLocX - giUnitOffsetX, iLocY - giUnitOffsetY + (giTileHeight/3), giUnitWidth, giUnitHeight);
                //circlefill(mBuffer, iLocX + 24, iLocY + 39, 7, giColorChart[iFaction + 1][3]);
                //draw_sprite(mBuffer, faction[iFaction - 1].mIcon, iLocX + 16, iLocY + 32);
                unitDisplay(iClass, iFaction, 0, iLocX, iLocY + (giTileHeight - giTileY));
            };                
		};
        
        // Display Tool information
        
        txtReset(2, txt.Get("horizontal") + " " + txtInt(iX + iOffsetX + 1));
        txtReset(3, txt.Get("vertical") + " " + txtInt(iY + iOffsetY + 1));
        
        if(iTool == 0)
        {
            txtReset(0, txt.Get("placing"));
            txtReset(1, terrain[iTerrain].tName);
            txtReset(5, "");
        };
        if(iTool == 1)
        {
            txtReset(0, txt.Get("placing"));
            txtReset(1, rank[iClass].tName);
            txtReset(5, "Surplus: " + txtInt(giMaxUnits - giTotalUnits));
        };
        if(iTool == 2)
        {
            txtReset(0, txt.Get("eraser"));
            txtReset(1, "");
            txtReset(5, "");
        };

		// Copy Everything to the Screen

		displayAll();
        
        // Make sure that the user isn't outside the bounds of the map.
        
        if(iOffsetX > map.iSizeX - giTilesWide)
            iOffsetX = map.iSizeX - giTilesWide;
        if(iOffsetY > map.iSizeY - giTilesHigh)
            iOffsetY = map.iSizeY - giTilesHigh;
		
		// Map Scrolling
		
		ScrollMap_();
		
		if(mouse_x > (SCREEN_W - giTileX) && iOffsetX < map.iSizeX - giTilesWide
			|| key[KEY_RIGHT] && iOffsetX < map.iSizeX - giTilesWide)
			MoveMap_(dRIGHT);
		if(mouse_x < giTileX && iOffsetX > 0
			|| key[KEY_LEFT] && iOffsetX > 0)
			MoveMap_(dLEFT);
		if(mouse_y > (SCREEN_H - giTileY) && iOffsetY < map.iSizeY - giTilesHigh
			|| key[KEY_DOWN] && iOffsetY < map.iSizeY - giTilesHigh)
			MoveMap_(dDOWN);
		if(mouse_y < giTileY && iOffsetY > 0
			|| key[KEY_UP] && iOffsetY > 0)
			MoveMap_(dUP);
        
        guiEZ(1);
		
        // Tool Selection
            
        if(keyCheck(KEY_T))
        {
            iTool = 0;
            PointerSet_(true);
        };
        if(keyCheck(KEY_U))
        {
            iTool = 1;
            PointerSet_(true);
        };
        if(keyCheck(KEY_E))
        {
            iTool = 2;
            PointerSet_(true);
        };
        
		// Tool Input

		if(mouse_b & 1)
        {
            if(iTool == 0)
            {
                int iBase = terrainFind(terrain[iTerrain].tBase);
                
                if(iBase != -1)
                {
                    map.iTerrain[0][iX + iOffsetX][iY + iOffsetY] = iBase;
                    map.iTile[0][iX + iOffsetX][iY + iOffsetY] = 0;
                    map.iTerrain[1][iX + iOffsetX][iY + iOffsetY] = iTerrain;
                    map.iTile[1][iX + iOffsetX][iY + iOffsetY] = iTerrainAlt;
                }
                else
                {
                    map.iTerrain[0][iX + iOffsetX][iY + iOffsetY] = iTerrain;
                    map.iTile[0][iX + iOffsetX][iY + iOffsetY] = iTerrainAlt;
                    map.iTerrain[1][iX + iOffsetX][iY + iOffsetY] = 0;             
                    map.iTile[1][iX + iOffsetX][iY + iOffsetY] = 0;
                };       
            };
            if(iTool == 1 && giTotalUnits < giMaxUnits)
            {
                if(map.iGeneric[iX + iOffsetX][iY + iOffsetY] == 0)
                    giTotalUnits ++;
                map.iGeneric[iX + iOffsetX][iY + iOffsetY] = iClass;
                map.iFaction[iX + iOffsetX][iY + iOffsetY] = iFaction;
            };
            if(iTool == 2)
            {
                if(map.iGeneric[iX + iOffsetX][iY + iOffsetY] != 0)
                {
                    map.iGeneric[iX + iOffsetX][iY + iOffsetY] = 0;            
                    giTotalUnits--;
                }
            };
        };
		if(mouse_b & 2)
        {
            if(iTool == 0)
            {
                if(map.iTerrain[2][iX + iOffsetX][iY + iOffsetY] != 0)
                {
                    iTerrain = map.iTerrain[2][iX + iOffsetX][iY + iOffsetY];
                    iTerrainAlt = map.iTile[2][iX + iOffsetX][iY + iOffsetY];
                }
                else if(map.iTerrain[1][iX + iOffsetX][iY + iOffsetY] != 0)
                {
                    iTerrain = map.iTerrain[1][iX + iOffsetX][iY + iOffsetY];
                    iTerrainAlt = map.iTile[1][iX + iOffsetX][iY + iOffsetY];
                }
                else
                {
                    iTerrain = map.iTerrain[0][iX + iOffsetX][iY + iOffsetY];
                    iTerrainAlt = map.iTile[0][iX + iOffsetX][iY + iOffsetY];
                };
            };
            if(iTool == 1)
            {
                if(map.iGeneric[iX + iOffsetX][iY + iOffsetY] != 0)
                {
                    iClass = map.iGeneric[iX + iOffsetX][iY + iOffsetY];
                    iFaction = map.iFaction[iX + iOffsetX][iY + iOffsetY];
                }
                else
                {
                    iTool = 2;
                    PointerSet_(true);
                };
            };
        };
        
        // Tile/Unit/Object/Faction Selection

		if(keyCheck(KEY_MINUS_PAD) || keyCheck(KEY_MINUS))
        {
            if(iTool == 0 && iTerrain > 0)
                iTerrain--;
            if(iTool == 1 && iClass > 1)
                iClass--;            
        };
		if(keyCheck(KEY_PLUS_PAD) || keyCheck(KEY_EQUALS))
        {
            if(iTool == 0 && iTerrain < giTerrainSlotsUsed)
                iTerrain++;
            if(iTool == 1 && iClass < giClassSlotsUsed)
                iClass++;
        };
        if(keyCheck(KEY_STOP) || keyCheck(KEY_ASTERISK))
        {
            if(iTool == 0 && iTerrainAlt < 18)
                iTerrainAlt++; 
            if(iTool == 1 && iFaction < giTotalFactions)
                iFaction++;
        };
        if(keyCheck(KEY_COMMA) || keyCheck(KEY_SLASH_PAD))
        {
            if(iTool == 0 && iTerrainAlt > 0)
                iTerrainAlt--; 
            if(iTool == 1 && iFaction > 1)
                iFaction--;
        };
        
        // Make sure the user hasn't selected a tile they aren't supposed to have. :P
        
        if(iTerrainAlt > 0 && terrain[iTerrain].iSmooth != 2)
            iTerrainAlt = 0;
        
        // Other Input
        
		if(keyCheck(KEY_G))
			map.ToggleGrid();
                
        if(keyCheck(KEY_TAB) || mouse_b & 4)
            Palette_();            
        if(keyCheck(KEY_F1))
        {
            guiKillAll();
            PointerSet_(false);
            htmManual("index");
            parStrings(txt, "map_editor");
            PointerSet_(true);
            RoverGUI_();
        };
		if(keyCheck(KEY_ESC))
        {
            PointerSet_(false);
			Menu_();
            PointerSet_(true);
        };
	};
    
    guiKillAll();
    PointerSet_(false);

	return 0;
};



// Private Functions

int CMapEditor::FindMouse_ (void)
{
	// Finds which tile the mouse is hovering over and
	// updates the variables accordingly.  This is done
	// by simply diving the mouse coordinates by the
	// size of an individual tile.

	iX = mouse_x / giTileX;
	iY = mouse_y / giTileY;
	iXPos = iX * giTileX;
	iYPos = iY * giTileY;

	return 0; // Success
};


int CMapEditor::Menu_ (void)
{
	// The system menu for the map editor, displaying basic
	// functions and giving access to other sub-editors.

	keyReset();
    guiKillAll();

	// Set up the menu buttons and text.

	MenuDisplay_();

	// Wait for the user to make a selection.

	while(!butCheck(0))
	{
		clear(mBuffer);
		map.Display(iOffsetX, iOffsetY, iOffsetXX, iOffsetYY, false, iLayer);
        unitUpdate();
		
		displayAll();

        if(butCheck(1))
        {
            guiKillAll();
            mapProperties();
            MenuDisplay_();
        };
        if(butCheck(2))
        {
            string tSaveTo = "";
            guiKillAll();
            tSaveTo = saveDialog(tPath, ".map", tFile, "Save Map As...", 0);
            if(tSaveTo != "")
            {
                tFile = tSaveTo;
                saveMap(tPath + tFile);
            };
            MenuDisplay_();
        };
        if(butCheck(3))
        {
            string tLoadTo = "";
            guiKillAll();
            tLoadTo = loadDialog(tPath, ".map", tFile, "Load Map File...", 0);
            if(tLoadTo != "")
            {
                iOffsetX = 0;
                iOffsetY = 0;
                tFile = tLoadTo;
                loadMap(tPath + tFile);
                map.LoadTiles("001");       // TODO: Once tile sets are enabled, this hard-coded
                                            // loading will no longer be needed.
            };
            MenuDisplay_();
        };
        if(butCheck(4))
        {
            // Create New Map
            
            string tToLoad = "";
            guiKillAll();
            tToLoad = loadDialog(sys_tRuleSetPath, "", "", "Select a Rule Set", FA_DIREC);
            if(tToLoad != "" && tToLoad != "." & tToLoad != "..")
            {
                rulesetLoad(tToLoad);
                map.Clear();
                iTool = 0;
                PointerSet_(true);
                iTerrain = 1;
                iTerrainAlt = 0;
                iClass = 1;
                iFaction = 1;
                map.LoadTiles("001"); // TODO: Scrap this once tile sets are fully enabled.
            }; // end if
            break;
        };
        if(butCheck(6))
        {
            guiKillAll();
            htmManual("index");
            parStrings(txt, "map_editor");
            MenuDisplay_();
        };
		if(butCheck(7))
        {
            bQuit = true;
            break;
        };
		if(keyCheck(KEY_ESC))
			break;
	}; // end while

	keyReset();

	// Clean up.

    guiKillAll();
    RoverGUI_();

	return 0;
};


int CMapEditor::MenuDisplay_ (void)
{
    win.New(1, "window", 164, 48, 311, 384);
    
	butNew(4, 192, 60, "big_01", "", "", 0);
	txtNew(4, 320, 65, txt.Get("new"), 2, -1, alignCENTER, 0);
	butNew(1, 192, 100, "big_01", "", "", 0);
	txtNew(1, 320, 105, txt.Get("prop_ed"), 2, -1, alignCENTER, 0);
	butNew(2, 192, 140, "big_01", "", "", 0);
	txtNew(2, 320, 145, txt.Get("save"), 2, -1, alignCENTER, 0);
	butNew(3, 192, 180, "big_01", "", "", 0);
	txtNew(3, 320, 185, txt.Get("restore"), 2, -1, alignCENTER, 0);
	//butNew(5, 192, 220, "big_01", "", "", 0);
	//txtNew(5, 320, 225, txt.Get("prep_ed"), 2, -1, alignCENTER, 0);
	butNew(6, 192, 260, "big_01", "", "", 0);
	txtNew(6, 320, 265, txt.Get("help"), 2, -1, alignCENTER, 0);
	butNew(7, 192, 300, "big_01", "", "", 0);
	txtNew(7, 320, 305, txt.Get("quit"), 2, -1, alignCENTER, 0);

	butNew(0, 192, 380, "big_01", "", "", 0);
	txtNew(0, 320, 385, txt.Get("continue"), 2, -1, alignCENTER, 0);

	return 0; // Success
};

int CMapEditor::MoveMap_ (int iDirection)
{
	// Moves the map in a given direction.
	
	static int iWaiterX;
	static int iWaiterY;
	
	if(iDirection == dRIGHT && iWaiterX > 0 || iDirection == dLEFT && iWaiterX > 0)
		iWaiterX--;
	if(iDirection == dUP && iWaiterY > 0 || iDirection == dDOWN && iWaiterY > 0)
		iWaiterY--;
	
	// Set up the scrolling
	
	if(iDirection == dRIGHT && iOffsetXX == 0 && iWaiterX == 0)
	{
		iOffsetXX = -1 * (giTileX / iScrollSpeed);
		iWaiterX = giTileX / (-1 * iOffsetXX);		
	};

	if(iDirection == dLEFT && iOffsetXX == 0 && iWaiterX == 0)
	{
		iOffsetXX = giTileX / iScrollSpeed;
		iWaiterX = giTileX / iOffsetXX;
	};	

	if(iDirection == dDOWN && iOffsetYY == 0 && iWaiterY == 0)
	{
		iOffsetYY = -1 * (giTileY / iScrollSpeed);
		iWaiterY = giTileY / (-1 * iOffsetYY);
	};	

	if(iDirection == dUP && iOffsetYY == 0 && iWaiterY == 0)
	{
		iOffsetYY = giTileY / iScrollSpeed;
		iWaiterY = giTileY / iOffsetYY;
	};
	
	return 0; // Success
};

int CMapEditor::Palette_ (void)
{
    // The palette, used for selecting tools and tool options.
    
    bool bGoBack = false;
    
    guiKillAll();
    PointerSet_(false);
    PaletteDisplay_();
    
    while (bGoBack == false)
    {
		clear(mBuffer);
		map.Display(iOffsetX, iOffsetY, iOffsetXX, iOffsetYY, false, iLayer);
        unitUpdate();
		
		displayAll();
        
        if(butCheck(0))
        {
            iTool = 0;
            bGoBack = true;
        };
        if(butCheck(1))
        {
            iTool = 1;
            bGoBack = true;
        };
        if(butCheck(2))
        {
            iTool = 2;
            bGoBack = true;
        };
        
        if(keyCheck(KEY_ESC) || mouse_b & 2)
            bGoBack = true;
    };    
    
    guiKillAll();
    PointerSet_(true);
    RoverGUI_();
    
    return 0; // Done
};

int CMapEditor::PaletteDisplay_ (void)
{
    // Displays the tool palette.
    
    guiEZ(16);
    
    butNew(0, 1, 1, "terrain", "", "", 0);
    butNew(1, 1, 3, "gunit", "", "", 0);
    butNew(2, 1, 5, "eraser", "", "", 0);
    win.New(1, "window", 1, 22, 38, 7);

    guiEZ(1);
  
    return 0; // Success
};

int CMapEditor::PointerSet_ (bool bSet)
{
    // Sets the mouse cursor to whatever the current tool is.
    // Send FALSE to reset the cursor to the default.
    
    if(bSet == true)
    {
        if(iTool == 0)
            mouseGFX("terrain_tool_01");
        if(iTool == 1)
            mouseGFX("unit_tool_01");
        if(iTool == 2)
            mouseGFX("erase_tool_01");        
    }
    else
        mouseGFX("pointer_01");
    
    return 0; // Success
};

int CMapEditor::RoverGUI_ (void)
{
    // Sets the GUI for the tile rover. Remember to call this
    // whenever you come back to the rover.
  
    guiEZ(16);
    win.New(1, "window", 1, 25, 8, 4);
    txtNew(0, 5, 26, txt.Get("placing"), 2, -1, alignCENTER, 0);
    txtNew(1, 5, 27, "", 2, -1, alignCENTER, 0);
    txtNew(4, 1, 1, txt.Get("forpal"), 4, -1, alignLEFT, 0);
    txtNew(2, 1, 3, "", 4, -1, alignLEFT, 0);
    txtNew(3, 1, 4, "", 4, -1, alignLEFT, 0);
    txtNew(5, 1, 6, "", 4, -1, alignLEFT, 0);
    guiEZ(1);
    
    return 0; // Success
};

int CMapEditor::ScrollMap_ (void)
{
	// Handles the actual pixel scrolling set up by MoveMap_
	
	if(iOffsetXX > 0)
		iOffsetXX += giTileX / iScrollSpeed;
	if(iOffsetXX < 0)
		iOffsetXX -= giTileX / iScrollSpeed;
	if(iOffsetYY > 0)
		iOffsetYY += giTileY / iScrollSpeed;
	if(iOffsetYY < 0)
		iOffsetYY -= giTileY / iScrollSpeed;
	
	if(iOffsetXX >= giTileX)
	{
		iOffsetX --;
		iOffsetXX = 0;
	};
	if(iOffsetXX <= -1 * giTileX)
	{
		iOffsetX ++;
		iOffsetXX = 0;
	};
	if(iOffsetYY >= giTileY)
	{
		iOffsetY --;
		iOffsetYY = 0;
	};
	if(iOffsetYY <= -1 * giTileY)
	{
		iOffsetY ++;
		iOffsetYY = 0;
	};
	
	return 0; // Success
};

// Function used for calling the map editor routines.

int editMap (void)
{
	edit.TileRover();

	return 0; // Success
};
