struct sPath
{
    int iX;                     // X position of a tile in the path list.
    int iY;                     // Y position of a tile in the path list.
    int iDistance;              // How many movement points are required to move this far in the path.
};

class CUnit
{
public:
    
    // Functions
    
    int AddPath (int iX, int iY, bool bIgnoreCost);
    int CanAttack (int iX, int iY);
    
    // General Information
    
    string tName;                   // The unit's name
    bool bActive;                   // Whether or not the unit is on the field.
    BITMAP *mImage;                 // The bitmap object of the unit.
    int iClass;                     // What class this unit is.
    int iChar;                      // Which character this unit is; -1 if it's a generic unit.
    int iFaction;                   // What faction this unit is a part of.
    int iType;                      // What type of movement this unit uses.
    
    // Animation
    
    int iSpeed;                     // How quickly this unit moves visibly across the map.
    bool bMoving;                   // If true, then the unit will be begin to move down the path it has been assigned.
    
    // Status
    
    int iLocX;                      // The unit's x location in tiles.
    int iLocY;                      // The unit's y location in tiles.
    int iX;                         // The unit's x location in pixels.
    int iY;                         // The unit's y location in pixels.
    int iMoves;                     // How many more moves the unit has left this turn.
    
    // Level Data
    
    int iLev;                       // What level this unit is at.
    int iEXP;                       // How much experience the unit has.
    int iNext;                      // How much experience is needed to advance to the next level.
    
    // Stats
    
    int iNEXT;                      // How much experience is needed to level up.
    int iHP;                        // This unit's current hit points.
    int iHPBar;                     // What the HP bar currently displays; used to make the bar rise and fall.
    int iMaxHP;                     // This unit's max hit point level.
    int iMP;                        // This unit's current magic points.
    int iMaxMP;                     // This unit's max magic point level.    
    int iSTR;                       // The unit's strength.
    int iDEX;                       // The unit's dexterity.
    int iMAG;                       // The unit's magic.
    int iCON;                       // The unit's constitution.
    int iRES;                       // The unit's resistance.
    int iSPD;                       // The unit's speed.
    int iAGL;                       // The unit's agility.
    int iLUK;                       // The unit's luck.
    int iBLD;                       // The unit's build.
    int iMOV;                       // How many movement points this units gets per turn.
    
    // Attack
    
    int iNear;                      // How far away the closest tile this unit can attack is.
    int iRange;                     // How far from the closest tile this unit's range is.
    
    // AI-Related
    
    bool bBeenAttacked;             // Whether or not this unit has bee attacked yet.
    vector<sPath> vPath;            // The unit's path data, used to move the unit visably on the screen.
};
