#include "stdafx.h"
#include "header.h"

void screenDisplay (void)
{
	// Displays everything on the buffer to the screen.  If the
	// VSync option is active, it will also wait for the vertical
	// refresh so that the graphics will display cleaner and won't
	// appear "clipped" when scrolling.

	if(sys_bUseVSync == true) // Check VSync
		vsync();
    
    if(sys_bDisplay) // Only display if true
        blit(mBuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H); // Copy the buffer to the screen.
};


void screenGet (BITMAP *mBitmap)
{
	// Grabs a copy of the screen buffer and stuffs it to a bitmap.
	// For when you want to make something look like it's still
	// running in the background without eating up extra CPU cycles
	// to actually display it.

	blit(mBuffer, mBitmap, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
};



void screenIn (int iSpeed, int iColor)
{
	// Fades in from black.  I think someone on Allegro.cc wrote this,
	// but I'm not sure...  Either way, I edited it to work for my
	// own needs.

	BITMAP *mTemp = create_bitmap(SCREEN_W, SCREEN_H);
	int i;

	show_mouse(NULL);
	blit(mBuffer, mTemp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

	if(iSpeed <= 0)
		iSpeed = 16;
	
	for(i = 0; i < 255; i += iSpeed)
	{
		rectfill(mBuffer, 0, 0, SCREEN_W, SCREEN_H, iColor);
		set_trans_blender(0, 0, 0, i);
		draw_trans_sprite(mBuffer, mTemp, 0, 0);
		vsync();
		screenDisplay();
	};

	destroy_bitmap(mTemp);
};



void screenOut (int iSpeed, int iColor)
{
	// Fades to iColor.  See screenIn for any additional notes.

	BITMAP *mTemp = create_bitmap(SCREEN_W, SCREEN_H);
	int i;

	show_mouse(NULL);	
	blit(mBuffer, mTemp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

	if(iSpeed <= 0)
		iSpeed = 16;
	
	for(i = 255; i > 0; i -= iSpeed)
	{
		rectfill(mBuffer, 0, 0, SCREEN_W, SCREEN_H, iColor);
		set_trans_blender(0, 0, 0, i);
		draw_trans_sprite(mBuffer, mTemp, 0, 0);
		vsync();
		screenDisplay();
	};

	destroy_bitmap(mTemp);
	rectfill(screen, 0, 0, SCREEN_W, SCREEN_H, iColor);
};
