#include "stdafx.h"
#include "header.h"

BITMAP *gfxLoad (string tFile, string tLocation)
{
    // Loads an image. Will try loading a given file name in the
    // following order: PNG, JPEG, BMP. If the file does not exist,
    // this function will create an empty bitmap instead.
    
    string tFileName[2];   // We'll be using this to determain where the image we
                            // need is, and if it exists.
    
    // First, determain the path.
    
    if(tLocation == "avatar")
        tFileName[0] = sys_tUser + "/" + sys_tAvatarPath + tFile;
    else if(tLocation == "bg")
        tFileName[0] = sys_tBGPath + tFile;
    else if(tLocation == "but")
        tFileName[0] = sys_tButPath + tFile;
    else if(tLocation == "elements")
        tFileName[0] = sys_tElmPath + tFile;
    else if(tLocation == "fonts")
        tFileName[0] = sys_tFontPath + tFile;
    else if(tLocation == "gui")
        tFileName[0] = sys_tGUIPath + tFile;    
    else if(tLocation == "mouse")
        tFileName[0] = sys_tMousePath + tFile;
    else if(tLocation == "root")
        tFileName[0] = tFile;
    else if(tLocation == "teams")
        tFileName[0] = sys_tTeamPath + tFile;
    else if(tLocation == "text")
        tFileName[0] = sys_tTextPath + tFile;    
    else if(tLocation == "tiles")
        tFileName[0] = sys_tTilePath + tFile;    
    else if(tLocation == "titles")
        tFileName[0] = sys_tTitlePath + tFile;
    else if(tLocation == "units")
        tFileName[0] = sys_tUnitPath + tFile;    

    // We need to look in the current rule set or campaign folder and
    // see if the image is there.
    
    tFileName[1] = sys_tPath + tFileName[0] + ".png";
    if(!exists(tFileName[1].c_str()))
    {
        tFileName[1] = sys_tPath + tFileName[0] + ".jpg";
        if(!exists(tFileName[1].c_str()))
        {
            tFileName[1] = sys_tPath + tFileName[0] + ".jpeg";
            if(!exists(tFileName[1].c_str()))
            {
                tFileName[1] = sys_tPath + tFileName[0] + ".bmp";
                if(!exists(tFileName[1].c_str()))
                {
                    // The file isn't here. :(
                };
            };
        };
    };
    
    if(exists(tFileName[1].c_str()))
        return load_bitmap(tFileName[1].c_str(), NULL); // Success

    // We can't find the file in the current rule set or campaign folder, so
    // we'll check to see if it's in the user's custom folder.
    
    tFileName[1] = sys_tUser + tFileName[0] + ".png";
        
    if(!exists(tFileName[1].c_str()))
    {
        tFileName[1] = sys_tUser + tFileName[0] + ".jpg";
        if(!exists(tFileName[1].c_str()))
        {
            tFileName[1] = sys_tUser + tFileName[0] + ".jpeg";
            if(!exists(tFileName[1].c_str()))
            {
                tFileName[1] = sys_tUser + tFileName[0] + ".bmp";
                if(!exists(tFileName[1].c_str()))
                {
                    // The file isn't here. :(
                };
            };
        };
    };

    if(exists(tFileName[1].c_str()))
        return load_bitmap(tFileName[1].c_str(), NULL); // Success    
    
    // It's not anywhere else, so let's see if it's in the default system folder...
    
    tFileName[1] = sys_tSysPath + tFileName[0] + ".png";
    if(!exists(tFileName[1].c_str()))
    {
        tFileName[1] = sys_tSysPath + tFileName[0] + ".jpg";
        if(!exists(tFileName[1].c_str()))
        {
            tFileName[1] = sys_tSysPath + tFileName[0] + ".jpeg";
            if(!exists(tFileName[1].c_str()))
            {
                tFileName[1] = sys_tSysPath + tFileName[0] + ".bmp";
                if(!exists(tFileName[1].c_str()))
                {
                    // If we got this far up the chain, then the file apparently
                    // isn't here.  Create a dummy bitmap and return negative.
                                        
                    return create_bitmap(16, 16); // Failure
                };
            };
        };
    };
        
    return load_bitmap(tFileName[1].c_str(), NULL); // Success
};

int gfxUnload (BITMAP *bImage)
{
    // Clears a given bitmap from memory.
    
    destroy_bitmap(bImage);
    
    return 0; // Success
};
