#include "stdafx.h"
#include "header.h"

string parGet (FILE *pFile, ...)
{
	// When given a file, it will grab the next "word" from the current
	// location in the file, skipping all the white space before it.
	
	// TODO: In the future, the function calling this needs to specifically
	// tell parGet what characters to stop at (including white spaces).
	// Right now, parGet has these values hardcoded, but call this function
	// from elsewhere in the program EXPECTING THIS TO CHANGE IN THE FUTURE.
	// You have been warned; failure to comply means more work later. :(
	
	int iTotalStops = 3;
	char cStopAt[] = {' ', '\n', ','};
	char cSingle;
	string tReturn = "";
	
	// Skip all the whitespace until we hit something.
	
	cSingle = (char)fgetc(pFile);
	
	while(cSingle == ' ' || cSingle == '\n')
	{
		// If we hit the end of the file, return an empty string.
		
		if(feof(pFile))
		{
			return ""; // Done.
		}; // end if
		
		// Otherwise, check and see if the next character is what
		// we're looking for.
		
		cSingle = (char)fgetc(pFile);
	}; // end while
	
	// Okay, now we're ready to pull data out of the file! We'll start
	// by putting the first character into the return string, unless it's
	// a " character, in which case we'll run a different version of the
    // parser.
	
	if(cSingle != '"')
	{
		tReturn += cSingle;
	
		// And then we'll continue to stuff characters in until we hit
		// either a cStopAt character, or the end of the file.
		
		while(!feof(pFile))
		{
			// Get the next character.
			
			cSingle = (char)fgetc(pFile);
			
			// Check its value against cStopAt. If it's a character we want
			// to stop at, then stop collecting data and return the string
			// we compiled.
			
			for(int i = 0; i < iTotalStops; i++)
			{
				if(cSingle == cStopAt[i])
					return tReturn; // Done.
			}; // end for
			
			// Now, put the character we just got out into the return string.
			
			tReturn += cSingle;
		}; // end while
	} // end if
	else
	{
		// This version of the function operated a bit differently. Instead
        // of using the cStopAt characters, we just keep going until we
        // hit another " character.
        
        while(!feof(pFile))
        {
            // Get the next character.
                
            cSingle = (char)fgetc(pFile);
            
            // If it's a " character, stop and return.
            
            if(cSingle == '"')
            {
                return tReturn; // Done.
            }; // end if
            
            // Otherwise put the character we just got out into the return string.
                
            tReturn += cSingle;
        }; // end while
    } // end else        
	
	// If we hit the end of the file, we still need to return the value
	// we collected up to this point.		
	
	return tReturn; // Done.
}; // end parGet
