// -- MAP DATA CLASS --
// Working Version 0.1
// Based on Proposed Version 0.5
//
// This is the "universal map class" which is used to store whatever
// map is currently in memory.  Because of their size, only one map may
// be loaded and active at a time, which shouldn't be a problem because
// you only need one map at a time.
//
// IMPORTANT: If you add any variables to the data structure, make sure
// you add them to the Clear routines.



class CMap
{
public:
	
    // Functions
    
    int ClearRange (void);
    int Terrain (int iX, int iY);
    
	// Header Data

	string tName;				// The name of the map.
	string tAuthor;				// Who made the made.
	string tDescription;		// A description of the map for multiplayer play or note-taking.
	string tVersion;     		// What version this map data was saved with.
    string tRuleSet;            // What rule set this map uses.
	int iSizeX;					// How wide the map is.
	int iSizeY;					// How tall the map is.
	int iTileSet;				// Which tile set to use to display the map.

	// Terrain Data

    BITMAP *mTiles;								// A bitmap containing all the tiles.
    int iFlag[maxWIDTH][maxHEIGHT];             // What faction has a flag in this tile.
	int iTerrain[4][maxWIDTH][maxHEIGHT];		// What terrain is in a given space at a given layer. 
    int iTile[4][maxWIDTH][maxHEIGHT];          // For selecting specific tiles in non-smoothing terrain groups.
    string tTerrainName[maxWIDTH][maxHEIGHT];   // Terrain name over-ride for custom names.
    
    // Character and Unit Data
    
    int iGeneric[maxWIDTH][maxHEIGHT];              // What generic unit is in a given space.
    int iFaction[maxWIDTH][maxHEIGHT];              // What faction controls the unit in this square.
    int iRange[maxWIDTH][maxHEIGHT];                // The movement range of a unit
	
	// Misc. Display Data
	
	bool bGrid;									// Whether or not to display the grid.
    int iGlowValue;                             // The white value of the range's "glow."
    int iGlowAt;                                // What to add to the glow value.

	// Public Functions and Routines

	int  Clear (void);					        // Clears all map data.
	int  Display (int iX, int iY, int iOffsetX, int iOffsetY, bool bOjectsOn, int iWorkingLayer); // Displays the map to the buffer.
    int  Grid (int iX, int iY);			        // Displays a grid on the screen.
	int  LoadTiles (string tFile);		        // Loads a given tile set.
	int  ToggleGrid (void);				        // Toggles the grid display.

private:

	// Private Functions and Routines

	int ClearHeader_ (void);
	int ClearTerrain_ (void);
    int ClearUnits_ (void);
    int DisplayTile_ (BITMAP *mTo, int iX, int iY, int iAtX, int iAtY);

	// Private Variables and Objects
};

