// Text String Data Class
//
// In order for multilanguage support to work, all the
// text must be externally stored.  This is how we hold
// the text strings and interface with them once they
// have been parsed.

const int giTotalStrings = 500;		// The total number of text strings we can support per class object.

class CText
{
public:
	string Get (string tName);						// Returns the string of text called for by its refrence name.
	int  Clear (void);								// Clears all the text and starts over from scratch.
	int  Put (string tName, string tContent);		// Puts text into a string.
private:
	int Find (string tName);			// Find the ID of a string with the given name.
	int FindEmpty (void);				// Find the first empty string.
	bool bOccupied[giTotalStrings];		// Whether or not a specific string has been used yes.
	string tHandle[giTotalStrings];		// The refrence name of a text string.
	string tString[giTotalStrings];		// The actual text itself.
};
