#include "stdafx.h"
#include "header.h"

int CWindows::Display (void)
{
    // Displays all the GUI windows
    
    set_trans_blender(0, 0, 0, 160); // Sets the trans_blender.
    
    for(int i = 0; i < giTotalWindows; i++)
    {
        if(bActive[i])
		{
            // TODO: Currently this function only draws a semi-transparent black
            // box for a window.  This needs to be built on.
            
            drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
            rectfill(mBuffer, iX[i], iY[i], iX[i] + iW[i] - 1, iY[i] + iH[i] - 1, makecol(0, 0, 0));
            solid_mode();
            rect(mBuffer, iX[i], iY[i], iX[i] + iW[i] - 1, iY[i] + iH[i] - 1, makecol(255, 255, 255));
            rect(mBuffer, iX[i] - 2, iY[i] - 2, iX[i] + iW[i] + 1, iY[i] + iH[i] + 1, makecol(255, 255, 255));
        }; // end if
    }; // end for
    
    set_trans_blender(0, 0, 0, 127); // Return the trans_blender back to default.
    
    return 0; // Success
};

int CWindows::Kill (int iID)
{
    // Turns a specific GUI window off and releases its
    // bitmaps from memory.
    
    bActive[iID] = false;
    
    // TODO: Add graphic killing features.
    
    return 0; // Success
};

int CWindows::KillAll (void)
{
    // Turns off all the GUI windows.
    
    for(int i = 0; i < giTotalWindows; i++)
        Kill(i);
    
    return 0; // Success
};

int CWindows::Move (int iID, int iNewX, int iNewY)
{
    // Moves a window to a new location.
    
    iX[iID] = iNewX * giGrid;
    iY[iID] = iNewY * giGrid;    
    
    return 0; // Success    
};

int CWindows::New (int iID, string tStyle, int iSetX, int iSetY, int iSetW, int iSetH)
{
    // Creates a new GUI window
    
    if(bActive[iID] == true)
        return -1; // This window already exists.
    
    bActive[iID] = true;
    iX[iID] = iSetX * giGrid;
    iY[iID] = iSetY * giGrid;
    iW[iID] = iSetW * giGrid;
    iH[iID] = iSetH * giGrid;
    
    // TODO: Add graphic loading features.
    
    return 0; // Success
};
