// Generic GUI and display routines

#include "stdafx.h"
#include "header.h"

// Define Functions

void guiDebug_ (void);
void guiScreen_ (void);



void displayAll (void)
{
	// Displays all the elements on the screen, as well as
	// handling anything else that needs to be done. All
	// other display functions should be handled before
	// calling this routine.
    
    //poll_mouse();

    if(sys_bFrameSkip)
    {
        sys_iFrameSkip++;
        if(sys_iFrameSkip > 1)
            sys_iFrameSkip = 0;
    };
    
    // We will only display if the global frame skip counter
    // is at 0.
    
    if(sys_iFrameSkip == 0)
    {
        // Display Layer 3 Images
        
        image.Display(3);
        
        // Display GUI Windows
        
        win.Display();
        
        // Display Layer 2 Images
        
        image.Display(2);
        
        // Display and Update Integer and Text Fields
        
        intFld.Update();
        intFld.Display();
        field.Update();
        field.Display();
    
        // Display and Update Buttons
    
        keyUpdate();
        mouseUpdate();
        butUpdate();
        butDisplay();
        
        // Display Layer 1 Images
        
        image.Display(1);
        
        // Display Text
        
        txtDisplay();
        
        // Display Layer 0 Images
        
        image.Display(0);
    
        // Check user options and optional displays.
    
        guiDebug_();
        guiScreen_();
    
        // Display the mouse, and then blit everything
        // to the screen. Afterwards, hide the mouse again.
    
        show_mouse(mBuffer);
        screenDisplay();
        show_mouse(NULL);
    }
    else
        guiDebug_();

	// Wait for a frame tick before passing control
	// back to the function that called this.

	timeWait();
};

int guiEZ (int iSpacing)
{
    // When TRUE is passed to this function, it allows GUI
    // elements to be "snapped to the grid."  In other words,
    // layout can be handled in pixel increments, instead of
    // exact numbers. ***Remember to set it back to 1 when
    // you're done with the layout!***
    
    if(iSpacing < 1)
        return -1; // Failure
    
    giGrid = iSpacing;
    
    return 0; // Success
};

int guiKillAll (void)
{
    // Kills all GUI objects in one convienient function.
    
    butKillAll();
    image.KillAll();
    field.KillAll();
    txtKillAll();
    win.KillAll();
    keyReset();
    mouseClear();
    
    return 0; // Success
};

int guiLoading (void)
{
    // Displays the "loading" screen which will
    // remain until displayed over.
    
    BITMAP *mBG = create_bitmap(SCREEN_W, SCREEN_H);
    
    // Grab and darken the background.
    
    screenGet(mBG);
    
    drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
	rectfill(mBG, 0, 0, SCREEN_W, SCREEN_H, makecol(0, 0, 0));
	solid_mode();
    
    // Now display it all.
    
    draw_sprite(mBuffer, mBG, 0, 0);
    txtOut(5, 32*14, 16*27, gTxt.Get("loading"), 0, -1);
    screenDisplay();
    
    destroy_bitmap(mBG);
    
    return 0; // Done
};    

void guiDebug_ (void)
{
	char tTemp[20];					// Used for passing the FPS number to the text display.
	static int iFPS;				// How many frames per second the engine is currently able to run at.
	static int iFPSCounter = 0;		// Used to keep track of the FPS.


	// First, let's check the F9 key.  If the F9 key has been
	// pressed, we go into debug mode.

	if (keyCheck(KEY_F9))
	{
		if (sys_bDebugMode == true)
			sys_bDebugMode = false;
		else
			sys_bDebugMode = true;
	}; // end if

	// This is stuff for keeping track of how many frames per
	// second the engine is getting.

	if(timeCheck())
	{
		iFPS = iFPSCounter;
		iFPSCounter = 1;
	}
	else
		iFPSCounter++;

	// Now, if the user wants it, we display it on the screen.

	if(sys_bDebugMode == true || sys_bFPS == true)
	{
		drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
		rectfill(mBuffer, 8, 457, 632, 472, makecol(0, 0, 0));
		solid_mode();
		sprintf(tTemp, "FPS: %-i", iFPS);
		txtCenter(1, 28, 461, tTemp, 0, -1);
        txtCenter(1, 320, 461, gtDebug, 0, -1);
	};
};

void guiScreen_ (void)
{
	// Changes the screen size if the user so requests.
	
	if(keyCheck(KEY_F5))
	{
        if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
    	{
			set_color_depth(16);
			if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
			{
				// TODO: Display error in-game.
			};
		};    
	}
	else if(keyCheck(KEY_F6))
	{
		if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
    	{
			set_color_depth(16);
			if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, sys_iScreenWidth, sys_iScreenHeight, 0, 0) != 0)
			{
				// TODO: Display error in-game.
			};
		};    
	};
};

void systemQuit (void)
{
    exit(0);
};
