#include "stdafx.h"
#include "header.h"

int saveMap (string tFile)
{
    // Saves a map file.

    // Create a handle and open the file.
    
	ofstream file;
    file.open(tFile.c_str());
    
    // Compatibility Information
    // This is ALWAYS in English!
    
    file << "Tactics Heroes Map File\n";
    file << "ver. 0.5.0\n";
    
    // Header Information
    
    file << map.tRuleSet << endl;
    file << map.tName << endl;
    file << map.tAuthor << endl;
    file << map.tDescription << endl;
    file << map.iSizeX << endl;
    file << map.iSizeY << endl;
    
    // Terrain, Object, and Unit data for every tile.
    
    for(int x = 0; x < map.iSizeX; x++)
    {
        for(int y = 0; y < map.iSizeY; y++)
        {
            for(int l = 0; l < 4; l++)
            {
                file << map.iTerrain[l][x][y] << endl;
                file << map.iTile[l][x][y] << endl;
            }; // end layer
            file << map.iGeneric[x][y] << endl;
            file << map.iFaction[x][y] << endl;
            file << map.iFlag[x][y] << endl;
        }; // end y
    }; // end x
    
    // When we're done, close the file.
    
    file.close();
    
    return 0; // Success
};

int loadMap (string tFile)
{
    // Loads a map file.

    // Declare variables here.
    
    ifstream file;                  // The file handle.
    //string tInfo;                   // A string used to check information from the file.
    char cInfo[500];
    
    // Open the file.
    
    if(!exists(tFile.c_str()))
        return -1; // Failure, the file isn't there
    
    file.open(tFile.c_str());
    
    // First, clear the current map.
    
    map.Clear();
    
    // Now we need to make sure this is a Tactics Heroes map file.
    // (Or, at least a file posing as one...)
    
    file.getline(cInfo, 500);
    
    if(strcmp(cInfo, "Tactics Heroes Map File") != 0)
    {
        allegro_message(cInfo);
        exit(0);
    };
    
    file.getline(cInfo, 500);
    map.tVersion = cInfo;
    
    //
    // LOAD VERSION 0.3.3
    //
    
    if(map.tVersion == "ver. 0.3.3")
    {
        // Header Information
        
        map.tRuleSet = "default";
        rulesetLoad(map.tRuleSet);
        
        file.getline(cInfo, 500);
        map.tName = cInfo;
        file.getline(cInfo, 500);
        map.tAuthor = cInfo;
        file.getline(cInfo, 500);
        map.tDescription = cInfo;
        file >> map.iSizeX;
        file >> map.iSizeY;
        
        // Terrain, Object, and Unit data for every tile.
        
        for(int x = 0; x < map.iSizeX; x++)
        {
            for(int y = 0; y < map.iSizeY; y++)
            {
                for(int l = 0; l < 4; l++)
                {
                    file >> map.iTerrain[l][x][y];
                    file >> map.iTile[l][x][y];
                }; // end layer
                file >> map.iGeneric[x][y];
                file >> map.iFaction[x][y];
            }; // end y
        }; // end x
    }; // end 0.3.3
    
    //
    // LOAD VERSION 0.5.0
    //
    
    if(map.tVersion == "ver. 0.5.0")
    {
        // Header Information

        file.getline(cInfo, 500);
        map.tRuleSet = cInfo;   

        rulesetLoad(map.tRuleSet);
        
        file.getline(cInfo, 500);
        map.tName = cInfo;
        file.getline(cInfo, 500);
        map.tAuthor = cInfo;
        file.getline(cInfo, 500);
        map.tDescription = cInfo;
        file >> map.iSizeX;
        file >> map.iSizeY;
        
        // Terrain, Object, and Unit data for every tile.
        
        for(int x = 0; x < map.iSizeX; x++)
        {
            for(int y = 0; y < map.iSizeY; y++)
            {
                for(int l = 0; l < 4; l++)
                {
                    file >> map.iTerrain[l][x][y];
                    file >> map.iTile[l][x][y];
                }; // end layer
                file >> map.iGeneric[x][y];
                file >> map.iFaction[x][y];
                file >> map.iFlag[x][y];
            }; // end y
        }; // end x
    }; // end 0.5.0    

    // When we're done, close the file.
    
    file.close();
    
    return 0; // Success
};
