#include "stdafx.h"
#include "header.h"

int CFaction::Purge (void)
{
    bActive = false;
    
    mIcon = gfxLoad("!Null", "Root");
    mFlag = gfxLoad("!Null", "Root");
    
    iColor = 2;
    iMoney = 0;
    iUnits = 0;
    
    tName = "";
    tHandle = "";
    tMusic = "";
    
    return 0; // Done
};

int factionLoad (string tFile)
{
	// A routine for parsing faction data from a file.
	
	FILE * pFile;					// A pointer to the file.
	string tInput;					// Input from the parser.
	
	// First, we need to make sure the file is actually there. In the future,
	// if it's missing, we fall back on the default class data. For now, we
	// just boot the player. :3
	
	if(!exists(tFile.c_str()))
	{
		allegro_message("The faction data that the engine needs appears to be missing.");
		exit(-1);
	}; //end if
	
	// Okay, let's start by clearing out major faction data. Everything else
	// we can pretty much clear as we go.
	
	giTotalFactions = -1;
	
	// We can now open the file...
	
	pFile = fopen(tFile.c_str(), "rt");
	
	// ...And begin parsing the data. We keep going until we hit the end of the file.
	
	while(!feof(pFile))
	{
		// First get the next command.
		
		tInput = parGet(pFile, ' ', '\n', ',');

		// CLASS
		
		if(tInput == "FACTION")
		{
			int iSlot = 0;				// The slot number this faction will take.
			
            // Increase the total number of terrains availible by one.
            
            giTotalFactions++;
            
			// Get the terrain's slot number, then assign this terrain to
            // the priority list.
			
			tInput = parGet(pFile, ' ', '\n', ',');
			iSlot = atoi(tInput.c_str());
            
            // Reset any vital data.
            
            faction[iSlot].Purge();
			
			// Then get the terrain's name.
            
            tInput = parGet(pFile, ' ', '\n', ',');
            faction[iSlot].tName = tInput;
            faction[iSlot].tHandle = tInput;
            
            // Now start processing data
            
            tInput = parGet(pFile, ' ', '\n', ',');        

            while(tInput != "}" && !feof(pFile))
            {            
                // color
                
                if(tInput == "color")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    tInput = parGet(pFile, ' ', '\n', ',');
                    faction[iSlot].iColor = atoi(tInput.c_str());
                }; // end if color                
                
                // SPRITES
                
                if(tInput == "SPRITES")
                {
                    tInput = parGet(pFile, ' ', '\n', ',');
                    
                    while(tInput != "}")
                    {
                        // icon
                        
                        if(tInput == "icon")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            faction[iSlot].mIcon = gfxLoad(tInput, "teams");
                        }; // end if icon
                        
                        // flag
                        
                        if(tInput == "flag")
                        {
                            tInput = parGet(pFile, ' ', '\n', ',');
                            tInput = parGet(pFile, ' ', '\n', ',');
                            faction[iSlot].mFlag = gfxLoad(tInput, "teams");
                        }; // end if flag 
                        
                        tInput = parGet(pFile, ' ', '\n', ',');
                    }; // end while
                }; // end if SPRITES
                
                tInput = parGet(pFile, ' ', '\n', ',');
            }; // end while
        };
        
		// If we ever hit a # comment line, then we want to skip the
		// entire thing. We'll have to handle that locally, so we
		// create a new char variable to deal with it.
		
		if(tInput == "#")
		{
			char cSingle;
            
            cSingle = (char)fgetc(pFile);
			
			while(cSingle != '\n')
			{
				cSingle = (char)fgetc(pFile);
			}; // end while
		}; // end if COMMENTS
	}; // end while
	
	return 0; // Success    
}; // end factionLoad

int factionStart (int iFaction)
{
    // Sets a faction up, so that they're ready to begin their turn.
    
    // Heal all units on healing tiles.
    
    for(int i = 0; i < 250; i++)
    {
        if(unit[i].bActive && unit[i].iFaction == iFaction)
        {
            // If the terrain this unit is on heals the unit, then
            // apply the HP recovery and inform the player.
            
            if(terrain[unitTerrain(i)].iHeal != 0)
            {
                int iToHeal = terrain[unitTerrain(i)].iHeal;
                while(iToHeal + unit[i].iHP > unit[i].iMaxHP)
                    iToHeal--;
                if(iToHeal > 0)
                {
                    msg.New(unit[i].iX + (giTileX / 2), unit[i].iY - 16, "+" + txtInt(iToHeal));
                    unit[i].iHP += terrain[unitTerrain(i)].iHeal;
                    if(unit[i].iHP > unit[i].iMaxHP)
                        unit[i].iHP = unit[i].iMaxHP;
                };
            };
        };
    };
    
    return 0; // Done
};
