#include "stdafx.h"
#include "header.h"

int CBattle::Calculate (int iAtkID, int iDefID)
{
    // Calculates the results of a battle, so that the battle
    // can be "simulated" by any of the battle animation options.
    
    //int iDefFac = unit[iDefID].iFaction;
    
    // Turn the battle "on" so that the engine will know to play
    // the battle animation when we're done.
    
    bActive = true;
    iOn = 0;
    
    // Reset the battle counter used by the "simple" version of
    // the battle animation.
    
    iTimer = 0;
    
    // Calculate the initial attack.

    CalculateRound_(0, iAtkID, iDefID);
    iRounds = 1;
    
    // Calculate the retaliation attack, if neccisary.
    
    aiAttackRange(iDefID, unit[iDefID].iLocX, unit[iDefID].iLocY);
    if(map.iRange[unit[iAtkID].iLocX][unit[iAtkID].iLocY] == 3 && unit[iDefID].iHP - iDamage[0] > 0)
    {
        CalculateRound_(1, iDefID, iAtkID);
        iRounds = 2;
    };
    map.ClearRange();
    
    
    return 0; // Done
};

int CBattle::Simple (void)
{
    // This is the simplified version of the battle engine display.
    
    int iAtkID = iAttacker[iOn];
    int iDefID = iDefender[iOn];
    
//    int iDefFac = unit[iDefID].iFaction;
    
    iTimer++;
    
    // Move the attacker to "bump" into/towards the defender.
    
    if(iTimer < 8)
    {
        if(unit[iAtkID].iLocX > unit[iDefID].iLocX)
            unit[iAtkID].iX--;
        if(unit[iAtkID].iLocX < unit[iDefID].iLocX)
            unit[iAtkID].iX++;
        if(unit[iAtkID].iLocY > unit[iDefID].iLocY)
            unit[iAtkID].iY--;
        if(unit[iAtkID].iLocY < unit[iDefID].iLocY)
            unit[iAtkID].iY++;       
    }
    else
    {
        if(unit[iAtkID].iLocX > unit[iDefID].iLocX)
            unit[iAtkID].iX++;
        if(unit[iAtkID].iLocX < unit[iDefID].iLocX)
            unit[iAtkID].iX--;
        if(unit[iAtkID].iLocY > unit[iDefID].iLocY)
            unit[iAtkID].iY++;
        if(unit[iAtkID].iLocY < unit[iDefID].iLocY)
            unit[iAtkID].iY--;
    };
    
    // If the unit is all the way into their "bump," then perform damage and
    // inform the player of the results for this round.
    
    if(iTimer == 7)
    {
        if(bHit[iOn])
        {
            if(iDamage[iOn] > 0)
                msg.New(unit[iDefID].iX + (giTileX / 2), unit[iDefID].iY - 16, "-" + txtInt(iDamage[iOn]));
            else if (iDamage[iOn] == 0)
                msg.New(unit[iDefID].iX + (giTileX / 2), unit[iDefID].iY - 16, txt.Get("nodam"));
            
            unit[iDefID].iHP -= iDamage[iOn];
        }
        else
        {
            msg.New(unit[iDefID].iX + (giTileX / 2), unit[iDefID].iY - 16, txt.Get("miss"));
        };
    };
    
    // If we're done with this round, move on.
    
    if(iTimer == 15)
    {
        iOn++;
        iTimer = 0;
        
        // Make sure the unit is centered in their tile correctly.
        
        unit[iAtkID].iX = unit[iAtkID].iLocX * giTileX;
        unit[iAtkID].iY = unit[iAtkID].iLocY * giTileY;
        
        // Check to see if this was the final round.
        
        if(iOn == iRounds)
            bActive = false;
    }
    
    return 0; // Done
};

int CBattle::CalculateRound_ (int iRound, int iAtkID, int iDefID)
{
    // Claculates a single round of battle for the main
    // calculation routine.
    
    int iDefTer = unitTerrain(iDefID);
    int iHitChance;
    
    // Record who's attacking and defending this round.
    
    iAttacker[iRound] = iAtkID;
    iDefender[iRound] = iDefID;
    
    // Calculate if there was a hit
    
    iHitChance = unitHit(iAtkID) - unitAvoid(iDefID);
    
    if((rand()%100 + 1) <= iHitChance)
        bHit[iRound] = true;
    else
        bHit[iRound] = false;
    
    // Calculate the damage inflicted.
    
    iDamage[iRound] = unit[iAtkID].iSTR - (unit[iDefID].iCON + terrain[iDefTer].iDef);
    
    if(iDamage[iRound] < 0)
        iDamage[iRound] = 0;
    
    return 0; // Done
};
