#include "stdafx.h"
#include "header.h"

int aiAttackRange (int iUnit, int iX, int iY)
{
    // Given a unit and the coordinates of a tile, finds all the possible
    // squares the unit can attack.
    
    int iNear = unit[iUnit].iNear;
    int iFar = unit[iUnit].iNear + unit[iUnit].iRange;
    
    if(iNear == 0)
        return 0; // Done, the unit cannot attack.
    
    for(int i = iNear; i <= iFar; i++)
    {
        // For each square's worth of range, we "draw" a diamond
        // into the map by going around the four farthest squares
        // in a line.
        
        int x = iX - i;
        int y = iY;
        while(x != iX && y != iY - i)
        {
            if(map.iRange[x][y] == 0)
                map.iRange[x][y] = 3;
            x++;
            y--;
        };
        while(x != iX + i && y != iY)
        {
            if(map.iRange[x][y] == 0)
                map.iRange[x][y] = 3;
            x++;
            y++;
        };
        while(x != iX && y != iY + i)
        {
            if(map.iRange[x][y] == 0)
                map.iRange[x][y] = 3;
            x--;
            y++;
        };
        while(x != iX - i && y != iY)
        {
            if(map.iRange[x][y] == 0)
                map.iRange[x][y] = 3;
            x--;
            y--;
        };        
    };
    
    return 0; // Done
};

int aiFindPath (int iUnit, int iX, int iY, bool bIgnoreCost)
{
    // Finds a path for the given unit from their current location to
    // coordinate iX, iY. If bIgnoreCost is false, it will truncate
    // the path so that the unit will move towards a destination using
    // as many movement points are availible to it in any given turn.
    //
    // To do this, we use classic A* pathfinding with a Manhattan heuristic.
    //
    // TODO: This is a rather rough version of A*.  It could probably use
    // a good cleaning to make it work faster and more efficently, but it
    // will get the job done for the time being.
    
    bool bChecked[map.iSizeX][map.iSizeY];      // Whether or not we've checked a given tile.
    int iCost[map.iSizeX][map.iSizeY];          // How much it will cost to get to this tile.
    int iScore[map.iSizeX][map.iSizeY];         // This tile's "score."
    int iParent[map.iSizeX][map.iSizeY][2];     // The parent tile to this given tile.
    int iQueue[map.iSizeX * map.iSizeY][3];     // The tiles we wish to check.
    int iOn = 0;                                // Out current location in the queue.
    int iNext = 1;                              // Where to put the next item in the queue
    
    // Clear the unit's current path so that we start from scratch.
    
    unit[iUnit].vPath.clear();
    
    // Empty the Queue while we're at it. D:
    
    for(int i = 0; i < map.iSizeX * map.iSizeY; i++)
        iQueue[i][0] = 0;
    
    for(int x = 0; x < map.iSizeX; x++)
    {
        for(int y = 0; y < map.iSizeY; y++)
        {
            bChecked[x][y] = false; // We haven't checked this tile yet.
            iScore[x][y] = -1; // This tile does not yet have a score.
        };
    };
    
    // Stuff the opening tile into the queue. :D
    
    iQueue[0][0] = 1;
    iQueue[0][1] = unit[iUnit].iLocX;
    iQueue[0][2] = unit[iUnit].iLocY;
    iScore[unit[iUnit].iLocX][unit[iUnit].iLocY] = 0;
    
    // Now, as long as there are items in the queue, we will continue to
    // search for a path.
    
    for(int i = 0; i < iNext; i++)
    {
        // Variables
        
        int iThisX;
        int iThisY;
        //int iTerrain = 0;
        //int iTileCost = 0;
        
        // Find the tile with the lowest score that we haven't checked yet.
        
        if(iScore[iQueue[0][1]][iQueue[0][2]] == -1)
        {
            iOn = 0;
        }
        else
        {
            int iLowest = 99999;
            
            for(int j = 1; j < iNext; j++)
            {
                //int iParentX = iParent[iQueue[j][1]][iQueue[j][2]][0];
                //int iParentY = iParent[iQueue[j][1]][iQueue[j][2]][1];
                int ijX = iQueue[j][1];
                int ijY = iQueue[j][2];
                
                //if(iScore[iParentX][iParentY] + terrain[map.Terrain(ijX, ijY)].iCost[unit[iUnit].iType] < iLowest
                if(iScore[ijX][ijY] < iLowest && bChecked[ijX][ijY] == false)
                {
                    iLowest = iScore[ijX][ijY];
                    iOn = j;
                };
            };
        };
        
        // Get the corridinates of this tile.
        
        iThisX = iQueue[iOn][1];
        iThisY = iQueue[iOn][2];
        
        // Note that we've checked this tile.
        
        bChecked[iThisX][iThisY] = true;
        
        // Calculate the score for this tile.  The score is equal to
        // the sum of the heuristic, plus the cost to move to this
        // tile from the source tile.
        
        //if(iOn != 0)
        //    iCost[iThisX][iThisY] = terrain[map.Terrain(iThisX, iThisY)].iCost[unit[iUnit].iType]
        //        + iCost[iParent[iThisX][iThisY][0]][iParent[iThisX][iThisY][1]];
        //else
        if(iOn == 0)
        {
            iCost[iThisX][iThisY] = 0;  // (The origin tile doesn't cost anything.)
            iScore[iThisX][iThisY] = aiHeuristic(iQueue[0][1], iQueue[0][2], iX, iY);
        };
        
        //iScore[iThisX][iThisY] = aiHeuristic(iQueue[iOn][1], iQueue[iOn][2], iX, iY) + iCost[iThisX][iThisY];
        
        // Now, insert the surrounding tiles into the queue
        
        if(iThisX > 0)
        {
            if(terrain[map.Terrain(iThisX - 1, iThisY)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX - 1, iThisY) == unit[iUnit].iFaction
                || terrain[map.Terrain(iThisX - 1, iThisY)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX - 1, iThisY) == -1)
            {
                if(iScore[iThisX - 1][iThisY] == -1)
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iThisX - 1;
                    iQueue[iNext][2] = iThisY;
                    iNext++;
                    iCost[iThisX - 1][iThisY] = terrain[map.Terrain(iThisX - 1, iThisY)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX - 1][iThisY] = aiHeuristic(iQueue[iOn][1] - 1, iQueue[iOn][2], iX, iY) + iCost[iThisX - 1][iThisY];                    
                    iParent[iThisX - 1][iThisY][0] = iThisX;
                    iParent[iThisX - 1][iThisY][1] = iThisY;
                }
                else if(iCost[iThisX][iThisY] + terrain[map.Terrain(iThisX - 1, iThisY)].iCost[unit[iUnit].iType]
                    < iCost[iThisX - 1][iThisY])
                {
                    iParent[iThisX - 1][iThisY][0] = iThisX;
                    iParent[iThisX - 1][iThisY][1] = iThisY;
                    iCost[iThisX - 1][iThisY] = terrain[map.Terrain(iThisX - 1, iThisY)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX - 1][iThisY] = aiHeuristic(iQueue[iOn][1] - 1, iQueue[iOn][2], iX, iY) + iCost[iThisX - 1][iThisY];
                };
            };
        };
        if(iThisX < map.iSizeX)
        {
            if(terrain[map.Terrain(iThisX + 1, iThisY)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX + 1, iThisY) == unit[iUnit].iFaction
                || terrain[map.Terrain(iThisX + 1, iThisY)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX + 1, iThisY) == -1)
            {
                if(iScore[iThisX + 1][iThisY] == -1)
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iThisX + 1;
                    iQueue[iNext][2] = iThisY;
                    iNext++;
                    iCost[iThisX + 1][iThisY] = terrain[map.Terrain(iThisX + 1, iThisY)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX + 1][iThisY] = aiHeuristic(iQueue[iOn][1] + 1, iQueue[iOn][2], iX, iY) + iCost[iThisX + 1][iThisY];                    
                    iParent[iThisX + 1][iThisY][0] = iThisX;
                    iParent[iThisX + 1][iThisY][1] = iThisY;
                }
                else if(iCost[iThisX][iThisY] + terrain[map.Terrain(iThisX + 1, iThisY)].iCost[unit[iUnit].iType]
                    < iCost[iThisX + 1][iThisY])
                {
                    iParent[iThisX + 1][iThisY][0] = iThisX;
                    iParent[iThisX + 1][iThisY][1] = iThisY;
                    iCost[iThisX + 1][iThisY] = terrain[map.Terrain(iThisX + 1, iThisY)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX + 1][iThisY] = aiHeuristic(iQueue[iOn][1] + 1, iQueue[iOn][2], iX, iY) + iCost[iThisX + 1][iThisY];
                };
            };
        };
        if(iThisY > 0)
        {
            if(terrain[map.Terrain(iThisX, iThisY - 1)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX, iThisY - 1) == unit[iUnit].iFaction
                || terrain[map.Terrain(iThisX, iThisY - 1)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX, iThisY - 1) == -1)
            {
                if(iScore[iThisX][iThisY - 1] == -1)
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iThisX;
                    iQueue[iNext][2] = iThisY - 1;
                    iNext++;
                    iParent[iThisX][iThisY - 1][0] = iThisX;
                    iParent[iThisX][iThisY - 1][1] = iThisY;
                    iCost[iThisX][iThisY - 1] = terrain[map.Terrain(iThisX, iThisY - 1)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX][iThisY - 1] = aiHeuristic(iQueue[iOn][1], iQueue[iOn][2] - 1, iX, iY) + iCost[iThisX][iThisY - 1];                    
                }
                else if(iCost[iThisX][iThisY] + terrain[map.Terrain(iThisX, iThisY - 1)].iCost[unit[iUnit].iType]
                    < iCost[iThisX][iThisY - 1])
                {
                    iParent[iThisX][iThisY - 1][0] = iThisX;
                    iParent[iThisX][iThisY - 1][1] = iThisY;
                    iCost[iThisX][iThisY - 1] = terrain[map.Terrain(iThisX, iThisY - 1)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX][iThisY - 1] = aiHeuristic(iQueue[iOn][1], iQueue[iOn][2] - 1, iX, iY) + iCost[iThisX][iThisY - 1];
                };
            };
        };
        if(iThisY < map.iSizeY)
        {
            if(terrain[map.Terrain(iThisX, iThisY + 1)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX, iThisY + 1) == unit[iUnit].iFaction
                || terrain[map.Terrain(iThisX, iThisY + 1)].iCost[unit[iUnit].iType] != -1
                && unitAt(iThisX, iThisY + 1) == -1)
            {
                if(iScore[iThisX][iThisY + 1] == -1)
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iThisX;
                    iQueue[iNext][2] = iThisY + 1;
                    iNext++;
                    iParent[iThisX][iThisY + 1][0] = iThisX;
                    iParent[iThisX][iThisY + 1][1] = iThisY;
                    iCost[iThisX][iThisY + 1] = terrain[map.Terrain(iThisX, iThisY + 1)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX][iThisY + 1] = aiHeuristic(iQueue[iOn][1], iQueue[iOn][2] + 1, iX, iY) + iCost[iThisX][iThisY + 1];                    
                }
                else if(iCost[iThisX][iThisY] + terrain[map.Terrain(iThisX, iThisY + 1)].iCost[unit[iUnit].iType]
                    < iCost[iThisX][iThisY + 1])
                {
                    iParent[iThisX][iThisY + 1][0] = iThisX;
                    iParent[iThisX][iThisY + 1][1] = iThisY;
                    iCost[iThisX][iThisY + 1] = terrain[map.Terrain(iThisX, iThisY + 1)].iCost[unit[iUnit].iType]
                        + iCost[iThisX][iThisY];
                    iScore[iThisX][iThisY + 1] = aiHeuristic(iQueue[iOn][1], iQueue[iOn][2] + 1, iX, iY) + iCost[iThisX][iThisY + 1];
                };
            };
        };

        // Check and see if this is the destination tile, in which case
        // we can begin to trace the path.
        
        if(iThisX == iX && iThisY == iY)
        {
            vector<sPath> tempPath;
            sPath tempStep;
            //int iAt = 0;
            
            while(iThisX != unit[iUnit].iLocX || iThisY != unit[iUnit].iLocY)
            {
                int iCurrentX = iThisX;
                int iCurrentY = iThisY;
                
                tempStep.iX = iThisX;
                tempStep.iY = iThisY;
                tempStep.iDistance = iCost[iThisX][iThisY];
                
                // Make the vector bigger.
                
                //unit[iUnit].vPath.resize(unit[iUnit].vPath.size() + 1);
                
                // Move everything up, then insert this tile at the beginning of the path.
                
                //for(int j = unit[iUnit].vPath.size() - 1; j > -1; j--)
                //    unit[iUnit].vPath[j + 1] = unit[iUnit].vPath[j];
                
                //unit[iUnit].vPath[0].iX = iThisX;
                //unit[iUnit].vPath[0].iY = iThisY;
                //unit[iUnit].vPath[0].iDistance = iCost[iThisX][iThisY];
                
                //unit[iUnit].AddPath(iThisX, iThisY, false);
                
                tempPath.push_back(tempStep);
                
                // Go to the next tile.
                
                iThisX = iParent[iCurrentX][iCurrentY][0];
                iThisY = iParent[iCurrentX][iCurrentY][1];
            };
            
            //unit[iUnit].vPath.resize(500);
            //unit[iUnit].vPath[5].iX = 12;
            //unit[iUnit].vPath[5].iY = 10;
            
            tempStep.iX = iThisX;
            tempStep.iY = iThisY;
            tempStep.iDistance = iCost[iThisX][iThisY];  

            tempPath.push_back(tempStep);
            
            //unit[iUnit].AddPath(iThisX, iThisY, false);
            
            // Make the vector bigger.
            
            //unit[iUnit].vPath.resize(unit[iUnit].vPath.size() + 1);
            
            // Move everything up, then insert the origin at the beginning of the path.
            
            for(int j = tempPath.size() - 1; j > -1; j--)
            {
                unit[iUnit].vPath.push_back(tempPath[j]);
            };
            
            unit[iUnit].vPath[0].iX = iThisX;
            unit[iUnit].vPath[0].iY = iThisY;
            unit[iUnit].vPath[0].iDistance = iCost[iThisX][iThisY];            
            
            //unit[iUnit].vPath[0] = tempPath;
                
            return 0; // Success, the path is complete.
        };        
    };
    
    return -1; // Failure!  We couldn't find a path to the given tile. Oh, the humanity!
};

int aiHeuristic (int iX1, int iY1, int iX2, int iY2)
{
    // Calculates the heuristic value using the Manhattan method to
    // "guess" how far two tiles are from each other, not taking
    // any obstacles into account.
    
    return abs(iX1 - iX2) + abs(iY1 - iY2);
};

int aiRange (int iUnit)
{
    // Finds the movement and attack range of a given unit, and
    // passes that information to the map data class.
    
    int iCost[map.iSizeX][map.iSizeY];          // How much it will cost to get to this tile.
    int iChecked[map.iSizeX][map.iSizeY];       // Whether we've checked this tile yet or not, and if so, how much the current parent tile costs.
    int iParent[map.iSizeX][map.iSizeY][2];     // Which tile is this tile's "parent."
    int iQueue[map.iSizeX * map.iSizeY][3];     // The tiles we want to check.
    int iOn = 0;                                // Where in the queue we are.
    int iNext = 1;                              // Where to put the next item in the queue.
    
    // First, reset the range already displayed on the map.
    
    map.ClearRange();
    
    // Empty the Queue
    
    for(int i = 0; i < map.iSizeX * map.iSizeY; i++)
        iQueue[i][0] = 0;
    
    for(int x = 0; x < map.iSizeX; x++)
    {
        for(int y = 0; y < map.iSizeY; y++)
        {
            iChecked[x][y] = 999;
        };
    };
    
    // Stuff the tile we're standing on in the queue.
    
    iQueue[iOn][0] = 1;
    iQueue[iOn][1] = unit[iUnit].iLocX;
    iQueue[iOn][2] = unit[iUnit].iLocY;
    iChecked[unit[iUnit].iLocX][unit[iUnit].iLocY] = 0;
    
    while(iQueue[iOn][0] != 0)
    {
        // Get the coordinates of this tile.
        
        int iX = iQueue[iOn][1];
        int iY = iQueue[iOn][2];
        int iTerrain = 0;
        int iTileCost = 0;
        
        // Find which terrain we need to check against.
        
        for(int l = 3; l >= 0; l--)
        {
            if(map.iTerrain[l][iX][iY] != 0 && iTerrain == 0)
                iTerrain = map.iTerrain[l][iX][iY];
        };
        
        iTileCost = terrain[iTerrain].iCost[0];

        // If a tile is inaccessible (marked by -1), change the terrain cost
        // to a really high number so we know it costs too much to reach.
        
        if(iTileCost == -1)
            iTileCost = 99;
        
        // Check and see if there is an enemy unit in this square, in which case,
        // we can't move into it, so make the terrain cost a really high number.
        
        for(int i = 0; i < 250; i++)
        {
            if(unit[i].bActive == true && unit[i].iLocX == iX && unit[i].iLocY == iY && unit[i].iFaction != unit[iUnit].iFaction)
                iTileCost = 99;
        };
        
        // Calculate the cost for this tile by adding the base cost, and the
        // cost of the tile's parent.
        
        if(iOn != 0)
        {
            int iParentX = iParent[iX][iY][0];
            int iParentY = iParent[iX][iY][1];
            iTileCost += iCost[iParentX][iParentY];
            iCost[iX][iY] = iTileCost;
        }
        else
            iCost[iX][iY] = 0;
        
        // If this tile is accessible to the unit, pass it on to the map
        // display routine to make it light up, and then add the surrounding
        // tiles to the queue.
        
        if(iCost[iX][iY] <= unit[iUnit].iMoves)
        {
            // Two units can't sit in the same space. If there's a friendly unit here,
            // we can move PAST him, but not INTO him. On the other hand, the square this
            // unit already occupies can be "moved into" so that the unit can attack from
            // here.
            
            bool bUnitHere = false;
            
            for(int i = 0; i < 250; i++)
            {
                if(iOn != 0 && unit[i].bActive == true && unit[i].iLocX == iX && unit[i].iLocY == iY)
                {
                    map.iRange[iX][iY] = 2;
                    bUnitHere = true;
                    break;
                }
                else
                {
                    map.iRange[iX][iY] = 1;
                };
            }            
            
            if(!bUnitHere)
                aiAttackRange(iUnit, iX, iY);
            
            // Now, stuff the adjacent tiles into the queue
            
            if(iX - 1 > -1)
            {
                if(iTileCost < iChecked[iX-1][iY])
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iX - 1;
                    iQueue[iNext][2] = iY;
                    iParent[iX - 1][iY][0] = iX;
                    iParent[iX - 1][iY][1] = iY;
                    iChecked[iX - 1][iY] = iTileCost;
                    iNext++;
                };
            };
            if(iY - 1 > -1)
            {
                if(iTileCost < iChecked[iX][iY-1])
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iX;
                    iQueue[iNext][2] = iY - 1;
                    iParent[iX][iY - 1][0] = iX;
                    iParent[iX][iY - 1][1] = iY;                
                    iChecked[iX][iY - 1] = iTileCost;
                    iNext++;
                };
            };
            if(iX + 1 < map.iSizeX)
            {
                if(iTileCost < iChecked[iX + 1][iY])
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iX + 1;
                    iQueue[iNext][2] = iY;
                    iParent[iX + 1][iY][0] = iX;
                    iParent[iX + 1][iY][1] = iY;                
                    iChecked[iX + 1][iY] = iTileCost;
                    iNext++;
                };
            };
            if(iY + 1 < map.iSizeY)
            {
                if(iTileCost < iChecked[iX][iY + 1])
                {
                    iQueue[iNext][0] = 1;
                    iQueue[iNext][1] = iX;
                    iQueue[iNext][2] = iY + 1;
                    iParent[iX][iY + 1][0] = iX;
                    iParent[iX][iY + 1][1] = iY;
                    iChecked[iX][iY + 1] = iTileCost;
                    iNext++;
                };
            };
        };
        
        iOn++;
    };

    return 0; // Done
};
