/// \file resource_jpeg.h
/// Resource manager plugin for JPEGs

#ifndef RESOURCE_JPEG_H_INCLUDED
#define RESOURCE_JPEG_H_INCLUDED

#include "resource.h"

class JpegResource: public BitmapResource
{
	public: // Public static function
		static Resource* Factory()
		{ return new JpegResource; }
		
	public: // Public functions
		JpegResource();
		JpegResource(BITMAP* data);
		
		void Save(std::iostream* f);
		void Load(std::iostream* f);
};

class MaskedJpegResource: public JpegResource
{
	public: // Public static function
		static Resource* Factory()
		{ return new MaskedJpegResource; }
		
	public: // Public functions
		MaskedJpegResource();
		MaskedJpegResource(BITMAP* data);
		
		void Save(std::iostream* f);
		void Load(std::iostream* f);
};

#endif

// The end
