/// \file resource_dumb.cpp
/// Resource manager plugin for DUMB files.

#include "resource_dumb.h"

using namespace std;

DumbResource::DumbResource(): data(NULL), datafile(NULL)
{
}

DumbResource::DumbResource(const string& data): StringResource(data), data(NULL), datafile(NULL)
{
}

DumbResource::~DumbResource()
{
	unload_duh(data);
	if(datafile)
		dumbfile_close(datafile);
}

void DumbResource::Save(std::iostream* f)
{
	f->put(ft);
	StringResource::Save(f);
}

void DumbResource::Load(std::iostream* f)
{
	ft = (FileType) f->get();
	StringResource::Load(f);
	datafile = dumbfile_open_memory(&StringResource::data[0], StringResource::data.length());
	switch(ft)
	{
		case FT_Mod:
			data = dumb_read_mod(datafile);
			break;
		case FT_It:
			data = dumb_read_it(datafile);
			break;
		case FT_Xm:
			data = dumb_read_xm(datafile);
			break;
		case FT_S3m:
			data = dumb_read_s3m(datafile);
			break;
	}
}

// The end
