/// \file mainmenu.cpp
/// The Main Menu class

#include <sstream>
#include "dumb/include/aldumb.h"
#include "mainmenu.h"
#include "global.h"
#include "akilahscreen.h"
#include "helpscreen.h"
#include "wordscreen.h"
#include "resource_jpeg.h"
#include "resource_dumb.h"

using namespace std;

MainMenuScreen::MainMenuScreen(): cur_sel(0), down(false)
{
	bg = g_data->Retrieve<JpegResource>("mainmenu")->data;
	if(g_music && !g_player)
	{
		int ntracks = g_music->Retrieve<BasicResource<int> >("track_count")->data;
		stringstream str;
		str << "track[" << (rand() % ntracks) << "]";
		DUH* duh = g_music->Retrieve<DumbResource>(str.str())->data;
		g_player = al_start_duh(duh, 2, 0, 1.0f, 4096, 48000);
	}
}

MainMenuScreen::~MainMenuScreen()
{
	g_data->Remove("mainmenu");
}

GameScreen* MainMenuScreen::Logic()
{
	if(key[KEY_ESC])
		return NULL;
	
	al_poll_duh(g_player);
		
	if(key[KEY_DOWN] || mouse_z < 0)
	{
		if(!down)
			++cur_sel;
		down = true;
		position_mouse_z(0);
	}
	else if(key[KEY_UP] || mouse_z > 0)
	{
		if(!down)
			--cur_sel;
		down = true;
		position_mouse_z(0);
	}
	else if(key[KEY_F1])
	{
		if(!down && g_music)
		{
			al_stop_duh(g_player);
			int ntracks = g_music->Retrieve<BasicResource<int> >("track_count")->data;
			stringstream str;
			str << "track[" << (rand() % ntracks) << "]";
			DUH* duh = g_music->Retrieve<DumbResource>(str.str())->data;
			g_player = al_start_duh(duh, 2, 0, 1.0f, 4096, 48000);
		}
		down = true;
	}
	else
		down = false;
		
	if(cur_sel < 0)
		cur_sel = 3;
	if(cur_sel > 3)
		cur_sel = 0;
		
	if(key[KEY_ENTER] || mouse_b & 1)
	{
		while(key[KEY_ENTER] || mouse_b & 1)
			rest(1);
		switch(cur_sel)
		{
			case 0:
				delete this;
				return new AkilahScreen;
			case 1:
				return NULL;
			case 2:
				delete this;
				return new HelpScreen;
			case 3:
				delete this;
				return new WordScreen("credits");
		}
	}
		
	return this;
}

void MainMenuScreen::Draw(BITMAP* to)
{
	blit(bg, to, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	
	textprintf_ex(to, g_font, 150, 270, 0, -1, "Play");
	textprintf_ex(to, g_font, 150, 310, 0, -1, "Quit");
	textprintf_ex(to, g_font, 150, 350, 0, -1, "Help");
	textprintf_ex(to, g_font, 150, 390, 0, -1, "Credits");
	
	textprintf_ex(to, g_font, 130, 270 + (cur_sel * 40), 0, -1, ">");
}

// The end
