/// \file helpscreen.cpp
/// Display the help screen

#include "helpscreen.h"
#include "mainmenu.h"
#include "resource_jpeg.h"
#include "global.h"

HelpScreen::HelpScreen()
{
	bg = g_data->Retrieve<JpegResource>("help_screen")->data;
	clear_keybuf();
}

HelpScreen::~HelpScreen()
{
	g_data->Remove("help_screen");
}

GameScreen* HelpScreen::Logic()
{
	if(keypressed() || mouse_b)
	{
		delete this;
		return new MainMenuScreen;
	}
	
	al_poll_duh(g_player);
	
	return this;
}

void HelpScreen::Draw(BITMAP* to)
{
	blit(bg, to, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

// The end
