/// \file game.h
/// Global data structures

#ifndef GAME_H_INCLUDED
#define GAME_H_INCLUDED

#include <allegro.h>
#include <vector>
#include "enemy.h"
#include "resource.h"


// Level progression
// 1  2  3  4  5  6  7
// 5  5  5 10 10 15 20
//       D  A     S
// Deans
// Andrew
// Swing dancers

class Game
{
	public: // Types
		enum { PanSpeed = 2 };
		enum EResult {
			R_None,
			R_Won,
			R_Lost,
			R_ISS
		};
		
	public: // Public variables
		/// Current background
		BITMAP* background;
		/// Where the camera looks
		int camx;
		/// Rate the camera is panning
		int cam_move;
		/// List of enemies
		std::vector<Enemy*> enemies;
		/// Next enemy to show
		std::vector<Enemy*>::iterator cur_enemy;
		/// Game's resources
		ResourceManager res;
		/// Game's enemy resources
		ResourceManager ene;
		/// Game's level database
		ResourceManager lev;
		/// Number of levels
		int num_lev;
		/// Akilah's hit count
		int score;
		/// Akilah's miss count
		int misses;
		/// Akilah's referral count
		int referrals;
		/// Ticks left until winning
		int win_cd;
		/// Number of enemies on screen
		int num_ene;
		/// Difficulty level
		int level;
		/// Points left for this level
		int level_rem;
		/// Ticks till the next enemy spawns
		int spawn_cd;
		
	public: // Public functions
		Game();
		~Game();
		
		void New();
		void End();
		void Levelup();
		EResult Logic();
		
		void Shoot(int x, int y);
		
	protected: // Protected functions
		void NextEnemy();
};

extern Game game;

#endif

// The end
