/// \file enemy.h
/// Enemy class

#ifndef ENEMY_H_INCLUDED
#define ENEMY_H_INCLUDED

#include <string>
#include <allegro.h>

class Enemy
{
	public: // Types
		enum EState {
			ES_Dead,
			ES_Birthing,
			ES_Alive,
			ES_Dying,
			ES_Leaving
		};
		
	public: // Public variables
		BITMAP* stoned;
		BITMAP* suprised;
		EState state;
		/// Time spent in a state
		int time;
		/// Enemy position
		int x, y;
		/// Whether or not this is a dean
		bool dean;
		
	public: // Public functions
		Enemy(int id, bool dean = false);
		~Enemy();
		
		void Logic();
		void Draw(BITMAP* to, int x, int y);
		
		void Spawn(int x, int y);
		bool TakeHit(int hx, int hy);
};

#endif

// The end
