/// \file winscreen.cpp
/// Display the next level screen

#include "losescreen.h"
#include "mainmenu.h"
#include "game.h"
#include "global.h"
#include "resource_jpeg.h"

LoseScreen::LoseScreen(bool iss): down(false), time(0)
{
	if(iss)
		bg = game.res.Retrieve<JpegResource>("iss_screen")->data;
	else
		bg = game.res.Retrieve<JpegResource>("lose_screen")->data;
	clear_keybuf();
}

LoseScreen::~LoseScreen()
{
}

GameScreen* LoseScreen::Logic()
{
	if((mouse_b & 1 || keypressed()) && time > 30)
	{
		clear_keybuf();
		delete this;
		return new MainMenuScreen;
	}
	
	al_poll_duh(g_player);
	
	time++;
	
	return this;
}

void LoseScreen::Draw(BITMAP* to)
{
	if(bg)
	{
		blit(bg, to, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
		textprintf_right_ex(to, g_font, 200, 330, 0, -1, "Level:");
		textprintf_ex(to, g_font, 210, 330, 0, -1, "%d", game.level);
		textprintf_right_ex(to, g_font, 200, 370, 0, -1, "Score:");
		textprintf_ex(to, g_font, 210, 370, 0, -1, "%d", game.score);
		textprintf_right_ex(to, g_font, 200, 410, 0, -1, "Referrals:");
		textprintf_ex(to, g_font, 210, 410, 0, -1, "%d", game.referrals);
		game.End();
		bg = NULL;
	}
}

// The end
