/// \file enemy.cpp
/// Enemy class

#include <sstream>
#include "game.h"
#include "enemy.h"
#include "resource_jpeg.h"

using namespace std;

Enemy::Enemy(int id, bool dean): state(ES_Dead), time(0), x(0), y(0), dean(dean)
{
	stringstream str;
	
	if(dean)
		str << "dean[" << id << "]";
	else
		str << "stoned[" << id << "]";
	stoned = game.ene.Retrieve<MaskedJpegResource>(str.str())->data;
	str.str("");
	
	if(dean)
		str << "busted[" << id << "]";
	else
		str << "suprised[" << id << "]";
	suprised = game.ene.Retrieve<MaskedJpegResource>(str.str())->data;
}

Enemy::~Enemy()
{
}

void Enemy::Logic()
{
	++time;
	switch(state)
	{
		case ES_Dead:
			break;
		case ES_Birthing:
			if(time > 30)
			{
				state = ES_Alive;
				time = 0;
			}
			break;
		case ES_Alive:
			if(time > 30)
			{
				state = ES_Leaving;
				time = 0;
				game.num_ene--;
			}
			break;
		case ES_Dying:
			if(time > 30)
			{
				state = ES_Dead;
				time = 0;
			}
			break;
		case ES_Leaving:
			if(time > 30)
			{
				state = ES_Dead;
				time = 0;
				if(!dean)
					game.misses++;
			}
	}
}

void Enemy::Draw(BITMAP* to, int x, int y)
{
	int y_sub = 0;
	switch(state)
	{
		case ES_Dead:
			break;
		case ES_Birthing:
			y_sub = stoned->h * time / 30;
			masked_blit(stoned, to, 0, 0, x, y + stoned->h - y_sub, stoned->w, y_sub);
			break;
		case ES_Alive:
			masked_blit(stoned, to, 0, 0, x, y, stoned->w, stoned->h);
			break;
		case ES_Dying:
			y_sub = suprised->h * (30 - time) / 30;
			if(time / 4 % 2 == 0)
				masked_blit(suprised, to, 0, 0, x, y + suprised->h - y_sub, suprised->w, y_sub);
			break;
		case ES_Leaving:
			y_sub = stoned->h * (30 - time) / 30;
			masked_blit(stoned, to, 0, 0, x, y + stoned->h - y_sub, stoned->w, y_sub);
			break;
	}
}

void Enemy::Spawn(int x, int y)
{
	this->x = x;
	this->y = y;
	state = ES_Birthing;
	time = 0;
}

bool Enemy::TakeHit(int hx, int hy)
{
	if(state != ES_Alive && state != ES_Birthing)
		return false;
	if(state == ES_Birthing)
		hy -= stoned->h - stoned->h * time / 30;
	if(hx < 0 || hy < 0 || hx >= stoned->w || hy >= stoned->h)
		return false;
	if(getpixel(stoned, hx, hy) == bitmap_mask_color(stoned))
		return false;
	if(state == ES_Birthing)
		time = 30 - time;
	else
		time = 0;
	state = ES_Dying;
	game.num_ene--;
	if(dean)
		game.referrals++;
	else
	{
		game.score++;
		game.level_rem--;
	}
	return true;
}

// The end
