/// \file wordscreen.cpp
/// Show words on the screen

#include <sstream>
#include "wordscreen.h"
#include "mainmenu.h"
#include "global.h"
#include "resource_dumb.h"

using namespace std;

WordScreen::WordScreen(const string& wordlist): down(false)
{
	string& file = g_data->Retrieve<StringResource>("credits")->data;
	string::size_type left, right;
	left = 0;
	while((right = file.find("\n", left)) != string::npos)
	{
		string line = file.substr(left, right - left - 1);
		lines.push_back(line);
		left = right + 1;
		if(left > file.length())
			break;
	}
	
	rate = 1;
	const int lps = SCREEN_H / text_height(g_font);
	time = 0;
	end_at = lines.size() * text_height(g_font);
	
	if(g_music)
	{
		al_stop_duh(g_player);
		DUH* duh = g_music->Retrieve<DumbResource>("fanfare")->data;
		g_player = al_start_duh(duh, 2, 0, 1.0f, 4096, 48000);
		int track_len = duh_get_length(duh) * 30 / 65536;
		end_at = track_len;
		rate = (lps * text_height(g_font) + (float) lines.size() * text_height(g_font)) / end_at;
	}
}

WordScreen::~WordScreen()
{
	al_stop_duh(g_player);
	g_player = NULL;
}

GameScreen* WordScreen::Logic()
{
	if(key[KEY_ESC])
		down = true;
	else if(down)
	{
		delete this;
		return new MainMenuScreen;
	}
	
	if(mouse_b & 1)
	{
		delete this;
		return new MainMenuScreen;
	}
	
	al_poll_duh(g_player);
	
	time++;
	
	if(time > end_at)
	{
		delete this;
		return new MainMenuScreen;
	}
	
	return this;
}

void WordScreen::Draw(BITMAP* to)
{
	const int lps = SCREEN_H / text_height(g_font);
	int y = (int) (-time * rate) + lps * text_height(g_font);
	int ls = text_height(g_font);
	unsigned lno = 0;
	while(y < -ls)
	{
		y += ls;
		lno++;
	}
	
	clear(to);
	while(lno < lines.size() && y < SCREEN_H)
	{
		textprintf_centre_ex(to, g_font, SCREEN_W / 2, y, -1, 0, "%s", lines[lno].c_str());
		y += ls;
		++lno;
	}
}

// The end
