/// \file winscreen.cpp
/// Display the next level screen

#include "winscreen.h"
#include "mainmenu.h"
#include "game.h"
#include "global.h"
#include "resource_jpeg.h"

WinScreen::WinScreen(GameScreen* comeback): down(false), time(0), comeback(comeback)
{
	bg = game.res.Retrieve<JpegResource>("win_screen")->data;
}

WinScreen::~WinScreen()
{
}

GameScreen* WinScreen::Logic()
{
	if(key[KEY_ESC])
		down = true;
	else if(down)
	{
		game.End();
		delete comeback;
		delete this;
		return new MainMenuScreen;
	}
	
	al_poll_duh(g_player);
	
	if(mouse_b & 1 && time > 15)
	{
		GameScreen* copy = comeback;
		delete this;
		game.Levelup();
		return copy;
	}
	
	time++;
	
	if(time > 120)
	{
		GameScreen* copy = comeback;
		delete this;
		game.Levelup();
		return copy;
	}
	
	return this;
}

void WinScreen::Draw(BITMAP* to)
{
	if(time > 60)
		blit(bg, to, bg->w - SCREEN_W, 0, 0, 0, SCREEN_W, SCREEN_H);
	else
		blit(bg, to, time * (bg->w - SCREEN_W) / 60, 0, 0, 0, SCREEN_W, SCREEN_H);
}

// The end
